/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.resteasy.plugins.interceptors;

import java.lang.reflect.Method;
import javax.annotation.security.DenyAll;
import javax.annotation.security.PermitAll;
import javax.annotation.security.RolesAllowed;
import javax.ws.rs.WebApplicationException;
import javax.ws.rs.core.SecurityContext;
import org.jboss.resteasy.core.ResourceMethod;
import org.jboss.resteasy.core.ServerResponse;
import org.jboss.resteasy.core.interception.AcceptedByMethod;
import org.jboss.resteasy.core.interception.PreProcessInterceptor;
import org.jboss.resteasy.spi.Failure;
import org.jboss.resteasy.spi.HttpRequest;
import org.jboss.resteasy.spi.ResteasyProviderFactory;

public class SecurityInterceptor
implements PreProcessInterceptor,
AcceptedByMethod {
    protected String[] rolesAllowed;
    protected boolean denyAll;

    public boolean accept(Class declaring, Method method) {
        if (declaring == null || method == null) {
            return false;
        }
        RolesAllowed allowed = declaring.getAnnotation(RolesAllowed.class);
        RolesAllowed methodAllowed = method.getAnnotation(RolesAllowed.class);
        if (methodAllowed != null) {
            allowed = methodAllowed;
        }
        if (allowed != null) {
            this.rolesAllowed = allowed.value();
        }
        this.denyAll = declaring.isAnnotationPresent(DenyAll.class) && !method.isAnnotationPresent(RolesAllowed.class) && !method.isAnnotationPresent(PermitAll.class) || method.isAnnotationPresent(DenyAll.class);
        return this.rolesAllowed != null || this.denyAll;
    }

    public ServerResponse preProcess(HttpRequest request, ResourceMethod method) throws Failure, WebApplicationException {
        SecurityContext context;
        if (this.denyAll) {
            throw new Failure(401);
        }
        if (this.rolesAllowed != null && (context = ResteasyProviderFactory.getContextData(SecurityContext.class)) != null) {
            for (String role : this.rolesAllowed) {
                if (!context.isUserInRole(role)) continue;
                return null;
            }
            throw new Failure(401);
        }
        return null;
    }
}

