/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.resteasy.plugins.interceptors.encoding;

import java.io.IOException;
import java.io.OutputStream;
import java.util.zip.GZIPOutputStream;
import javax.ws.rs.WebApplicationException;
import javax.ws.rs.ext.Provider;
import org.jboss.resteasy.core.interception.ClientInterceptor;
import org.jboss.resteasy.core.interception.MessageBodyWriterContext;
import org.jboss.resteasy.core.interception.MessageBodyWriterInterceptor;
import org.jboss.resteasy.core.interception.ServerInterceptor;

@Provider
@ServerInterceptor
@ClientInterceptor
public class GZIPEncodingInterceptor
implements MessageBodyWriterInterceptor {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void write(MessageBodyWriterContext context) throws IOException, WebApplicationException {
        Object encoding = context.getHeaders().getFirst((Object)"Content-Encoding");
        if (encoding != null && encoding.toString().equalsIgnoreCase("gzip")) {
            OutputStream old = context.getOutputStream();
            GZIPOutputStream gzipOutputStream = new GZIPOutputStream(old);
            context.setOutputStream(gzipOutputStream);
            try {
                context.proceed();
            }
            finally {
                gzipOutputStream.finish();
                context.setOutputStream(old);
            }
            return;
        }
        context.proceed();
    }
}

