/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.resteasy.client.core.executors;

import java.io.IOException;
import java.io.OutputStream;

public class CommitHeaderOutputStream
extends OutputStream {
    protected OutputStream delegate;
    protected boolean isHeadersCommitted;
    protected Headers headers;

    public CommitHeaderOutputStream(OutputStream delegate, Headers headers) {
        this.delegate = delegate;
        this.headers = headers;
    }

    public void commit() {
        if (this.isHeadersCommitted) {
            return;
        }
        this.isHeadersCommitted = true;
        this.headers.commit();
    }

    @Override
    public void write(int i) throws IOException {
        this.commit();
        this.delegate.write(i);
    }

    @Override
    public void write(byte[] bytes) throws IOException {
        this.commit();
        this.delegate.write(bytes);
    }

    @Override
    public void write(byte[] bytes, int i, int i1) throws IOException {
        this.commit();
        this.delegate.write(bytes, i, i1);
    }

    @Override
    public void flush() throws IOException {
        this.commit();
        this.delegate.flush();
    }

    @Override
    public void close() throws IOException {
        this.commit();
        this.delegate.close();
    }

    public static interface Headers {
        public void commit();
    }
}

