/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.resteasy.security.signing;

import java.security.PrivateKey;
import java.security.PublicKey;
import java.security.Signature;
import java.security.SignatureException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Calendar;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.jboss.resteasy.security.signing.ContentSignatures;
import org.jboss.resteasy.util.DateUtil;
import org.jboss.resteasy.util.Hex;
import org.jboss.resteasy.util.ParameterParser;

public class ContentSignature {
    public static final String CONTENT_SIGNATURE = "Content-Signature";
    public static final String TIMESTAMP = "timestamp";
    public static final String SIGNER = "signer";
    public static final String EXPIRATION = "expiration";
    public static final String ALGORITHM = "algorithm";
    public static final String SIGNATURE = "signature";
    public static final String SIGNATURE_REFS = "signature-refs";
    public static final String VALUES = "values";
    public static final String HEADERS = "headers";
    public static final String ID = "id";
    public static String DEFAULT_SIGNER = "DEFAULT_SIGNER";
    public static final String SHA256WITH_RSA = "SHA256withRSA";
    public static String DEFAULT_ALGORITHM = "SHA256withRSA";
    protected PrivateKey privateKey;
    protected Map<String, String> attributes = new HashMap<String, String>();
    protected List<String> displayedAttributes = new ArrayList<String>();
    protected List<String> values = new ArrayList<String>();
    protected List<String> headers = new ArrayList<String>();
    protected List<String> signatureRefs = new ArrayList<String>();
    protected String keyAlias;
    protected byte[] signature;

    public ContentSignature() {
    }

    public ContentSignature(Map<String, String> attrs) {
        this.attributes = attrs;
        this.extractAttributes();
    }

    public ContentSignature(String headerValue) {
        ParameterParser parser = new ParameterParser();
        parser.setLowerCaseNames(true);
        this.attributes = parser.parse(headerValue, ';');
        this.extractAttributes();
    }

    protected void extractAttributes() {
        String sig;
        String refs;
        String heads;
        String vals = this.attributes.get(VALUES);
        if (vals != null) {
            this.values = Arrays.asList(vals.split(":"));
        }
        if ((heads = this.attributes.get(HEADERS)) != null) {
            this.headers = Arrays.asList(heads.split(":"));
        }
        if ((refs = this.attributes.get(SIGNATURE_REFS)) != null) {
            this.signatureRefs = Arrays.asList(refs.split(":"));
        }
        if ((sig = this.attributes.get(SIGNATURE)) != null) {
            this.signature = Hex.decodeHex(sig);
        }
    }

    public String toString() {
        boolean first;
        StringBuffer buf = new StringBuffer();
        boolean firstAttr = true;
        if (this.values.size() > 0) {
            if (!firstAttr) {
                buf.append(";");
            } else {
                firstAttr = false;
            }
            buf.append("values=");
            first = true;
            for (String val : this.values) {
                if (first) {
                    first = false;
                } else {
                    buf.append(":");
                }
                buf.append(val);
            }
        }
        if (this.headers.size() > 0) {
            if (!firstAttr) {
                buf.append(";");
            } else {
                firstAttr = false;
            }
            buf.append("headers=");
            first = true;
            for (String header : this.headers) {
                if (first) {
                    first = false;
                } else {
                    buf.append(":");
                }
                buf.append(header);
            }
        }
        if (this.signatureRefs.size() > 0) {
            if (!firstAttr) {
                buf.append(";");
            } else {
                firstAttr = false;
            }
            buf.append("signature-refs=");
            first = true;
            for (String header : this.signatureRefs) {
                if (first) {
                    first = false;
                } else {
                    buf.append(":");
                }
                buf.append(header);
            }
        }
        for (String name : this.displayedAttributes) {
            boolean needsQuotes;
            String val;
            val = this.attributes.get(name);
            if (!firstAttr) {
                buf.append(";");
            } else {
                firstAttr = false;
            }
            buf.append(name).append("=");
            boolean bl = needsQuotes = val.indexOf(44) > -1 || val.indexOf(59) > -1;
            if (needsQuotes) {
                buf.append("\"");
            }
            buf.append(val);
            if (!needsQuotes) continue;
            buf.append("\"");
        }
        if (this.signature != null) {
            if (!firstAttr) {
                buf.append(";");
            } else {
                firstAttr = false;
            }
            buf.append("signature=").append(Hex.encodeHex(this.signature));
        }
        return buf.toString();
    }

    public String getKeyAlias() {
        return this.keyAlias;
    }

    public void setKeyAlias(String keyAlias) {
        this.keyAlias = keyAlias;
    }

    public void addSignatureRef(ContentSignatures signatures, String id) {
        ContentSignature sig = signatures.getFirstBy(ID, id);
        if (sig == null) {
            throw new RuntimeException("ContentSignatures does not contain id, " + id);
        }
        this.signatureRefs.add(id);
    }

    public void addHeader(String headerName) {
        this.headers.add(headerName);
    }

    public void setAttribute(String name, String value, boolean includeSignature, boolean display) {
        this.attributes.put(name, value);
        if (includeSignature) {
            this.values.add(name);
        }
        if (display) {
            this.displayedAttributes.add(name);
        }
    }

    public void setAlgorithm(String value, boolean includeSignature, boolean display) {
        this.setAttribute(ALGORITHM, value, includeSignature, display);
    }

    public void setTimestamp(String value) {
        this.setAttribute(TIMESTAMP, value, true, true);
    }

    public void setTimestamp() {
        this.setAttribute(TIMESTAMP, DateUtil.formatDate(new Date()), true, true);
    }

    public void setSigner(String signer, boolean includeSignature, boolean display) {
        this.setAttribute(SIGNER, signer, includeSignature, display);
    }

    public void setId(String id, boolean includeSignature) {
        this.setAttribute(ID, id, includeSignature, true);
    }

    public void setExpiration(Date expire) {
        this.setAttribute(EXPIRATION, DateUtil.formatDate(expire), true, true);
    }

    public void setExpiration(int seconds, int minutes, int hours, int days, int months, int years) {
        Calendar now = Calendar.getInstance();
        if (seconds > 0) {
            now.add(13, seconds);
        }
        if (minutes > 0) {
            now.add(12, minutes);
        }
        if (hours > 0) {
            now.add(10, hours);
        }
        if (days > 0) {
            now.add(5, days);
        }
        if (months > 0) {
            now.add(2, months);
        }
        if (years > 0) {
            now.add(1, years);
        }
        this.setExpiration(now.getTime());
    }

    public boolean isExpired() {
        String exp = this.attributes.get(EXPIRATION);
        if (exp == null) {
            return false;
        }
        Date expiration = DateUtil.parseDate(exp);
        return expiration.getTime() < new Date().getTime();
    }

    public boolean isStale(int seconds, int minutes, int hours, int days, int months, int years) {
        String time = this.attributes.get(TIMESTAMP);
        if (time == null) {
            return false;
        }
        Date timestamp = DateUtil.parseDate(time);
        Calendar expires = Calendar.getInstance();
        expires.setTime(timestamp);
        if (seconds > 0) {
            expires.add(13, seconds);
        }
        if (minutes > 0) {
            expires.add(12, minutes);
        }
        if (hours > 0) {
            expires.add(10, hours);
        }
        if (days > 0) {
            expires.add(5, days);
        }
        if (months > 0) {
            expires.add(2, months);
        }
        if (years > 0) {
            expires.add(1, years);
        }
        return new Date().getTime() > expires.getTime().getTime();
    }

    public String getId() {
        return this.attributes.get(ID);
    }

    public String getSigner() {
        return this.attributes.get(SIGNER);
    }

    public String getAlgorithm() {
        return this.attributes.get(ALGORITHM);
    }

    public Map<String, String> getAttributes() {
        return this.attributes;
    }

    public String getHexSignature() {
        return this.attributes.get(SIGNATURE);
    }

    public void setHexSignature(String signature) {
        this.setAttribute(SIGNATURE, signature, false, true);
    }

    public byte[] getSignature() {
        return this.signature;
    }

    public void setSignature(byte[] signature) {
        this.signature = signature;
    }

    public PrivateKey getPrivateKey() {
        return this.privateKey;
    }

    public void setPrivateKey(PrivateKey privateKey) {
        this.privateKey = privateKey;
    }

    public void sign(Map headers, byte[] body, ContentSignatures parent, PrivateKey defaultKey) throws SignatureException {
        PrivateKey key;
        PrivateKey privateKey = key = this.privateKey == null ? defaultKey : this.privateKey;
        if (key == null) {
            throw new SignatureException("private key is null, cannot sign");
        }
        String algorithm = this.getAlgorithm();
        if (algorithm == null) {
            algorithm = DEFAULT_ALGORITHM;
        }
        Signature signature = null;
        try {
            signature = Signature.getInstance(algorithm);
            signature.initSign(key);
        }
        catch (Exception e) {
            throw new SignatureException(e);
        }
        for (String val : this.values) {
            String attr = this.getAttributes().get(val);
            if (attr == null) {
                throw new SignatureException("Unable to find attribute " + attr + " to sign header");
            }
            signature.update(attr.getBytes());
        }
        for (String name : this.headers) {
            this.updateSignatureWithHeader(headers, signature, name);
        }
        for (String id : this.signatureRefs) {
            if (parent == null) {
                throw new SignatureException("ContentSignatures was null so could not look up signature-ref: " + id);
            }
            ContentSignature ref = parent.getFirstBy(ID, id);
            if (ref == null) {
                throw new SignatureException("Could not find ContentSignature with id " + id + " to add as signature-ref");
            }
            String hexSigRef = ref.getHexSignature();
            if (hexSigRef == null) {
                throw new SignatureException("Referenced signature " + id + " is not signed.  Order your signatures correctly.");
            }
            hexSigRef = ref.getHexSignature();
            signature.update(hexSigRef.getBytes());
        }
        signature.update(body);
        byte[] signed = signature.sign();
        this.setSignature(signed);
    }

    private void updateSignatureWithHeader(Map headers, Signature signature, String name) throws SignatureException {
        Object h = headers.get(name);
        if (h == null) {
            throw new SignatureException("Unable to find header " + name + " to sign header with");
        }
        if (h instanceof List) {
            List l = (List)h;
            for (Object obj : l) {
                signature.update(obj.toString().getBytes());
            }
        } else {
            signature.update(h.toString().getBytes());
        }
    }

    public boolean verify(Map headers, byte[] body, PublicKey key) throws SignatureException {
        return this.verify(headers, body, null, key, null, null);
    }

    public boolean verify(Map headers, byte[] body, ContentSignatures parent, PublicKey key, String defaultAlgorithm, Map<String, String> defaultAttributes) throws SignatureException {
        String algorithm = this.getAlgorithm();
        if (algorithm == null) {
            algorithm = defaultAlgorithm == null ? DEFAULT_ALGORITHM : defaultAlgorithm;
        }
        Signature verifier = null;
        try {
            verifier = Signature.getInstance(algorithm);
            verifier.initVerify(key);
        }
        catch (Exception e) {
            throw new SignatureException(e);
        }
        for (String name : this.values) {
            String val = this.getAttributes().get(name);
            if (val == null && defaultAttributes != null) {
                val = defaultAttributes.get(name);
            }
            if (val == null) {
                throw new SignatureException("Could not find attribute value for " + name + " within signature.");
            }
            verifier.update(val.getBytes());
        }
        for (String name : this.headers) {
            this.updateSignatureWithHeader(headers, verifier, name);
        }
        for (String id : this.signatureRefs) {
            if (parent == null) {
                throw new SignatureException("ContentSignatures was null so could not look up signature-ref: " + id);
            }
            ContentSignature ref = parent.getFirstBy(ID, id);
            if (ref == null) {
                throw new SignatureException("Could not find ContentSignature with id " + id + " to add as signature-ref");
            }
            String hexSigRef = ref.getHexSignature();
            if (hexSigRef == null) {
                throw new SignatureException("Signature attribute was null for signature-ref " + id);
            }
            hexSigRef = ref.getHexSignature();
            verifier.update(hexSigRef.getBytes());
        }
        verifier.update(body);
        return verifier.verify(this.getSignature());
    }
}

