/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.resteasy.security.signing;

import java.security.PublicKey;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.jboss.resteasy.security.keys.KeyRepository;
import org.jboss.resteasy.security.signing.ContentSignature;
import org.jboss.resteasy.security.signing.ContentSignatures;
import org.jboss.resteasy.security.signing.Verification;
import org.jboss.resteasy.security.signing.VerificationResult;
import org.jboss.resteasy.security.signing.VerificationResultSet;
import org.jboss.resteasy.security.signing.VerificationResults;

public class Verifier {
    protected KeyRepository repository;
    protected List<Verification> verifications = new ArrayList<Verification>();

    public KeyRepository getRepository() {
        return this.repository;
    }

    public void setRepository(KeyRepository repository) {
        this.repository = repository;
    }

    public Verification addNew() {
        Verification verification = new Verification();
        this.verifications.add(verification);
        return verification;
    }

    public List<Verification> getVerifications() {
        return this.verifications;
    }

    public VerificationResults verify(ContentSignatures signatures, Map headers, byte[] body) {
        VerificationResults results = new VerificationResults();
        results.setVerified(true);
        for (Verification verification : this.verifications) {
            VerificationResultSet resultSet = new VerificationResultSet();
            results.getResults().add(resultSet);
            resultSet.setVerification(verification);
            String id = verification.getId();
            String signer = verification.getSigner();
            ArrayList<ContentSignature> matched = new ArrayList<ContentSignature>();
            matched.addAll(signatures.getSignatures());
            Iterator iterator = matched.iterator();
            while (iterator.hasNext()) {
                ContentSignature sig = (ContentSignature)iterator.next();
                if (id != null && !id.equals(sig.getId())) {
                    iterator.remove();
                    continue;
                }
                if (signer == null || signer.equals(sig.getSigner())) continue;
                iterator.remove();
            }
            if (matched.isEmpty()) {
                results.setVerified(false);
                continue;
            }
            resultSet.setVerified(true);
            for (ContentSignature signature : matched) {
                VerificationResult result = this.verifySignature(signatures, headers, body, verification, signature);
                resultSet.getResults().add(result);
                if (result.isVerified()) continue;
                resultSet.setVerified(false);
                results.setVerified(false);
            }
        }
        return results;
    }

    public VerificationResult verifySignature(ContentSignatures signatures, Map headers, byte[] body, Verification verification, ContentSignature signature) {
        VerificationResult result = new VerificationResult();
        result.setSignature(signature);
        PublicKey key = verification.getKey();
        if (key == null) {
            String keyAlias = null;
            if (verification.getKeyAlias() != null) {
                keyAlias = verification.getKeyAlias();
            } else if (verification.getAttributeAlias() != null) {
                keyAlias = signature.getAttributes().get(verification.getAttributeAlias());
            }
            if (keyAlias == null) {
                result.setFailureReason("Could not find a key alias");
                return result;
            }
            if (verification.getRepository() != null) {
                key = verification.getRepository().getPublicKey(keyAlias);
            } else if (this.repository != null) {
                key = this.repository.getPublicKey(keyAlias);
            }
            if (key == null) {
                result.setFailureReason("Could not find PublicKey for keyAlias " + keyAlias);
                return result;
            }
        }
        boolean verified = false;
        try {
            verified = signature.verify(headers, body, signatures, key, verification.getAlgorithm(), verification.getAttributes());
        }
        catch (Exception e) {
            result.setFailureException(e);
            return result;
        }
        if (!verified) {
            result.setFailureReason("Signature verification failed");
            return result;
        }
        if (!verification.isIgnoreExpiration() && signature.isExpired()) {
            result.setFailureReason("Signature expired");
            return result;
        }
        if (verification.isStaleCheck() && signature.isStale(verification.getStaleSeconds(), verification.getStaleMinutes(), verification.getStaleHours(), verification.getStaleDays(), verification.getStaleMonths(), verification.getStaleYears())) {
            result.setFailureReason("Signature is stale");
            return result;
        }
        result.setVerified(true);
        return result;
    }
}

