/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.resteasy.client.core;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.lang.annotation.Annotation;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.util.List;
import java.util.Map;
import javax.ws.rs.core.MediaType;
import javax.ws.rs.core.MultivaluedMap;
import javax.ws.rs.core.Response;
import javax.ws.rs.ext.MessageBodyReader;
import org.jboss.resteasy.client.ClientExecutor;
import org.jboss.resteasy.client.ClientResponse;
import org.jboss.resteasy.client.ClientResponseFailure;
import org.jboss.resteasy.client.core.ClientMessageBodyReaderContext;
import org.jboss.resteasy.plugins.delegates.LinkHeaderDelegate;
import org.jboss.resteasy.spi.Link;
import org.jboss.resteasy.spi.LinkHeader;
import org.jboss.resteasy.spi.MarshalledEntity;
import org.jboss.resteasy.spi.ReaderException;
import org.jboss.resteasy.spi.ResteasyProviderFactory;
import org.jboss.resteasy.spi.interception.MessageBodyReaderInterceptor;
import org.jboss.resteasy.util.CaseInsensitiveMap;
import org.jboss.resteasy.util.GenericType;
import org.jboss.resteasy.util.InputStreamToByteArray;
import org.jboss.resteasy.util.ReadFromStream;
import org.jboss.resteasy.util.Types;

public class BaseClientResponse<T>
extends ClientResponse<T> {
    protected ResteasyProviderFactory providerFactory;
    protected String attributeExceptionsTo;
    protected MultivaluedMap<String, String> headers;
    protected String alternateMediaType;
    protected Class<?> returnType;
    protected Type genericReturnType;
    protected Annotation[] annotations = new Annotation[0];
    protected int status;
    protected boolean wasReleased = false;
    protected Object unmarshaledEntity;
    protected MessageBodyReaderInterceptor[] messageBodyReaderInterceptors;
    protected Exception exception;
    protected BaseClientResponseStreamFactory streamFactory;
    protected LinkHeader linkHeader;
    protected Link location;
    protected ClientExecutor executor;
    protected Map<String, Object> attributes;

    public BaseClientResponse(BaseClientResponseStreamFactory streamFactory, ClientExecutor executor) {
        this.streamFactory = streamFactory;
        this.executor = executor;
    }

    public BaseClientResponse(BaseClientResponseStreamFactory streamFactory) {
        this.streamFactory = streamFactory;
    }

    public static ClientResponse copyFromError(ClientResponse copy) {
        if (copy instanceof BaseClientResponse) {
            BaseClientResponse base = (BaseClientResponse)copy;
            InputStream is = null;
            if (copy.getHeaders().containsKey((Object)"Content-Type")) {
                try {
                    is = base.streamFactory.getInputStream();
                    byte[] bytes = ReadFromStream.readFromStream(1024, is);
                    is = new ByteArrayInputStream(bytes);
                }
                catch (IOException e) {
                    // empty catch block
                }
            }
            final InputStream theIs = is;
            BaseClientResponse tmp = new BaseClientResponse(new BaseClientResponseStreamFactory(){
                InputStream stream;

                @Override
                public InputStream getInputStream() throws IOException {
                    return theIs;
                }

                @Override
                public void performReleaseConnection() {
                }
            });
            tmp.executor = base.executor;
            tmp.status = base.status;
            tmp.providerFactory = base.providerFactory;
            tmp.headers = new CaseInsensitiveMap<String>();
            tmp.headers.putAll(base.headers);
            tmp.headers.remove((Object)"Content-Encoding");
            return tmp;
        }
        ByteArrayInputStream is = null;
        if (copy.getHeaders().containsKey((Object)"Content-Type")) {
            GenericType<byte[]> gt = new GenericType<byte[]>(){};
            try {
                byte[] bytes = copy.getEntity(gt);
                is = new ByteArrayInputStream(bytes);
            }
            catch (Exception ignore) {
                // empty catch block
            }
        }
        final ByteArrayInputStream theIs = is;
        BaseClientResponse tmp = new BaseClientResponse(new BaseClientResponseStreamFactory(){
            InputStream stream;

            @Override
            public InputStream getInputStream() throws IOException {
                return theIs;
            }

            @Override
            public void performReleaseConnection() {
            }
        });
        tmp.status = copy.getStatus();
        tmp.providerFactory = ResteasyProviderFactory.getInstance();
        tmp.headers = new CaseInsensitiveMap<String>();
        tmp.headers.putAll(copy.getHeaders());
        tmp.headers.remove((Object)"Content-Encoding");
        return tmp;
    }

    @Override
    public Map<String, Object> getAttributes() {
        return this.attributes;
    }

    public void setAttributes(Map<String, Object> attributes) {
        this.attributes = attributes;
    }

    public void setMessageBodyReaderInterceptors(MessageBodyReaderInterceptor[] messageBodyReaderInterceptors) {
        this.messageBodyReaderInterceptors = messageBodyReaderInterceptors;
    }

    public void setStatus(int status) {
        this.status = status;
    }

    public void setHeaders(MultivaluedMap<String, String> headers) {
        this.headers = headers;
    }

    public void setProviderFactory(ResteasyProviderFactory providerFactory) {
        this.providerFactory = providerFactory;
    }

    public void setReturnType(Class<T> returnType) {
        this.returnType = returnType;
    }

    public Class<?> getReturnType() {
        return this.returnType;
    }

    public void setGenericReturnType(Type genericReturnType) {
        this.genericReturnType = genericReturnType;
    }

    public void setAnnotations(Annotation[] annotations) {
        this.annotations = annotations;
    }

    public String getAttributeExceptionsTo() {
        return this.attributeExceptionsTo;
    }

    public void setAttributeExceptionsTo(String attributeExceptionsTo) {
        this.attributeExceptionsTo = attributeExceptionsTo;
    }

    public Exception getException() {
        return this.exception;
    }

    public void setException(Exception exception) {
        this.exception = exception;
    }

    public Annotation[] getAnnotations() {
        return this.annotations;
    }

    public String getResponseHeader(String headerKey) {
        if (this.headers == null) {
            return null;
        }
        return (String)this.headers.getFirst((Object)headerKey);
    }

    @Override
    public LinkHeader getLinkHeader() {
        if (this.linkHeader != null) {
            return this.linkHeader;
        }
        this.linkHeader = new LinkHeader();
        if (!this.headers.containsKey((Object)"Link")) {
            return this.linkHeader;
        }
        List links = (List)this.headers.get((Object)"Link");
        LinkHeaderDelegate delegate = new LinkHeaderDelegate();
        for (String string : links) {
            LinkHeader tmp = delegate.fromString(string);
            this.linkHeader.getLinks().addAll(tmp.getLinks());
            this.linkHeader.getLinksByRelationship().putAll(tmp.getLinksByRelationship());
            this.linkHeader.getLinksByTitle().putAll(tmp.getLinksByTitle());
        }
        for (Link link : this.linkHeader.getLinks()) {
            link.setExecutor(this.executor);
        }
        return this.linkHeader;
    }

    @Override
    public Link getLocation() {
        if (this.location != null) {
            return this.location;
        }
        if (!this.headers.containsKey((Object)"Location")) {
            return null;
        }
        String header = (String)this.headers.getFirst((Object)"Location");
        this.location = new Link();
        this.location.setHref(header);
        this.location.setExecutor(this.executor);
        return this.location;
    }

    @Override
    public Link getHeaderAsLink(String headerName) {
        String value = (String)this.headers.getFirst((Object)headerName);
        if (value == null) {
            return null;
        }
        String type = (String)this.headers.getFirst((Object)(headerName + "-type"));
        Link link = new Link();
        link.setHref(value);
        link.setType(type);
        link.setExecutor(this.executor);
        return link;
    }

    public void setAlternateMediaType(String alternateMediaType) {
        this.alternateMediaType = alternateMediaType;
    }

    public BaseClientResponseStreamFactory getStreamFactory() {
        return this.streamFactory;
    }

    public void setStreamFactory(BaseClientResponseStreamFactory streamFactory) {
        this.streamFactory = streamFactory;
    }

    @Override
    public void resetStream() {
        try {
            this.streamFactory.getInputStream().reset();
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public T getEntity() {
        if (this.returnType == null) {
            throw new RuntimeException("No type information to extract entity with, use other getEntity() methods");
        }
        return (T)this.getEntity(this.returnType, this.genericReturnType, this.annotations);
    }

    @Override
    public <T2> T2 getEntity(Class<T2> type) {
        return this.getEntity(type, null);
    }

    @Override
    public <T2> T2 getEntity(Class<T2> type, Type genericType) {
        return this.getEntity(type, genericType, this.getAnnotations(type, genericType));
    }

    private <T2> Annotation[] getAnnotations(Class<T2> type, Type genericType) {
        return this.returnType == type && this.genericReturnType == genericType ? this.annotations : null;
    }

    @Override
    public <T2> T2 getEntity(Class<T2> type, Type genericType, Annotation[] anns) {
        if (this.exception != null) {
            throw new RuntimeException("Unable to unmarshall response for " + this.attributeExceptionsTo, this.exception);
        }
        if (this.unmarshaledEntity != null && !type.isInstance(this.unmarshaledEntity)) {
            throw new RuntimeException("The entity was already read, and it was of type " + this.unmarshaledEntity.getClass());
        }
        if (this.unmarshaledEntity == null) {
            if (this.status == 204) {
                return null;
            }
            this.unmarshaledEntity = this.readFrom(type, genericType, this.getMediaType(), anns);
            if (this.unmarshaledEntity != null && !InputStream.class.isInstance(this.unmarshaledEntity)) {
                this.releaseConnection();
            }
        }
        return (T2)this.unmarshaledEntity;
    }

    protected MediaType getMediaType() {
        String mediaType = this.getResponseHeader("Content-Type");
        if (mediaType == null) {
            mediaType = this.alternateMediaType;
        }
        return mediaType == null ? MediaType.WILDCARD_TYPE : MediaType.valueOf((String)mediaType);
    }

    protected <T2> Object readFrom(Class<T2> type, Type genericType, MediaType media, Annotation[] annotations) {
        MessageBodyReader<T2> reader1;
        Type useGeneric = genericType == null ? type : genericType;
        Class<Object> useType = type;
        boolean isMarshalledEntity = false;
        if (type.equals(MarshalledEntity.class)) {
            isMarshalledEntity = true;
            ParameterizedType param = (ParameterizedType)useGeneric;
            useGeneric = param.getActualTypeArguments()[0];
            useType = Types.getRawType(useGeneric);
        }
        if ((reader1 = this.providerFactory.getMessageBodyReader(useType, useGeneric, this.annotations, media)) == null) {
            throw this.createResponseFailure(String.format("Unable to find a MessageBodyReader of content-type %s and type %s", media, genericType));
        }
        try {
            InputStream is = this.streamFactory.getInputStream();
            if (is == null) {
                throw new ClientResponseFailure("Input stream was empty, there is no entity", (ClientResponse)this);
            }
            if (isMarshalledEntity) {
                is = new InputStreamToByteArray(is);
            }
            final Object obj = new ClientMessageBodyReaderContext(this.messageBodyReaderInterceptors, reader1, useType, useGeneric, this.annotations, media, this.getHeaders(), is, this.attributes).proceed();
            if (isMarshalledEntity) {
                InputStreamToByteArray isba = (InputStreamToByteArray)is;
                final byte[] bytes = isba.toByteArray();
                return new MarshalledEntity(){

                    @Override
                    public byte[] getMarshalledBytes() {
                        return bytes;
                    }

                    public Object getEntity() {
                        return obj;
                    }
                };
            }
            return obj;
        }
        catch (Exception e) {
            if (e instanceof ReaderException) {
                throw (ReaderException)e;
            }
            throw new ReaderException(e);
        }
    }

    @Override
    public <T2> T2 getEntity(GenericType<T2> genericType) {
        return this.getEntity(genericType.getType(), genericType.getGenericType());
    }

    @Override
    public <T2> T2 getEntity(GenericType<T2> genericType, Annotation[] ann) {
        return this.getEntity(genericType.getType(), genericType.getGenericType(), ann);
    }

    @Override
    public MultivaluedMap<String, String> getHeaders() {
        return this.headers;
    }

    public MultivaluedMap<String, Object> getMetadata() {
        return this.headers;
    }

    public int getStatus() {
        return this.status;
    }

    public void checkFailureStatus() {
        if (this.status > 399 && this.status < 599) {
            throw this.createResponseFailure(String.format("Error status %d %s returned", this.status, this.getResponseStatus()));
        }
    }

    public ClientResponseFailure createResponseFailure(String message) {
        return this.createResponseFailure(message, null);
    }

    public ClientResponseFailure createResponseFailure(String message, Exception e) {
        this.setException(e);
        this.returnType = byte[].class;
        this.genericReturnType = null;
        this.annotations = null;
        return new ClientResponseFailure(message, e, this);
    }

    @Override
    public Response.Status getResponseStatus() {
        return Response.Status.fromStatusCode((int)this.getStatus());
    }

    public boolean wasReleased() {
        return this.wasReleased;
    }

    @Override
    public final void releaseConnection() {
        if (!this.wasReleased) {
            if (this.streamFactory != null) {
                this.streamFactory.performReleaseConnection();
            }
            this.wasReleased = true;
        }
    }

    protected final void finalize() throws Throwable {
        this.releaseConnection();
    }

    public static interface BaseClientResponseStreamFactory {
        public InputStream getInputStream() throws IOException;

        public void performReleaseConnection();
    }
}

