/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.resteasy.core;

import java.lang.annotation.Annotation;
import java.lang.reflect.AccessibleObject;
import java.lang.reflect.Array;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.SortedSet;
import java.util.TreeSet;
import javax.ws.rs.HeaderParam;
import javax.ws.rs.ext.ParamConverter;
import javax.ws.rs.ext.RuntimeDelegate;
import org.jboss.resteasy.annotations.StringParameterUnmarshallerBinder;
import org.jboss.resteasy.spi.BadRequestException;
import org.jboss.resteasy.spi.ResteasyProviderFactory;
import org.jboss.resteasy.spi.StringConverter;
import org.jboss.resteasy.spi.StringParameterUnmarshaller;
import org.jboss.resteasy.util.StringToPrimitive;

public class StringParameterInjector {
    protected Class type;
    protected Class baseType;
    protected Type baseGenericType;
    protected Constructor constructor;
    protected Method valueOf;
    protected String defaultValue;
    protected String paramName;
    protected Class paramType;
    protected boolean isCollection;
    protected Class<? extends Collection> collectionType;
    protected AccessibleObject target;
    protected ParamConverter paramConverter;
    protected StringConverter converter;
    protected StringParameterUnmarshaller unmarshaller;
    protected RuntimeDelegate.HeaderDelegate delegate;

    public StringParameterInjector() {
    }

    public StringParameterInjector(Class type, Type genericType, String paramName, Class paramType, String defaultValue, AccessibleObject target, Annotation[] annotations, ResteasyProviderFactory factory) {
        this.initialize(type, genericType, paramName, paramType, defaultValue, target, annotations, factory);
    }

    public boolean isCollectionOrArray() {
        return this.isCollection || this.type.isArray();
    }

    protected void initialize(Class type, Type genericType, String paramName, Class paramType, String defaultValue, AccessibleObject target, Annotation[] annotations, ResteasyProviderFactory factory) {
        this.type = type;
        this.paramName = paramName;
        this.paramType = paramType;
        this.defaultValue = defaultValue;
        this.target = target;
        this.baseType = type;
        this.baseGenericType = genericType;
        if (type.isArray()) {
            this.baseType = type.getComponentType();
        }
        if (List.class.isAssignableFrom(type)) {
            this.isCollection = true;
            this.collectionType = ArrayList.class;
        } else if (SortedSet.class.isAssignableFrom(type)) {
            this.isCollection = true;
            this.collectionType = TreeSet.class;
        } else if (Set.class.isAssignableFrom(type)) {
            this.isCollection = true;
            this.collectionType = HashSet.class;
        }
        if (this.isCollection) {
            if (genericType != null && genericType instanceof ParameterizedType) {
                ParameterizedType zType = (ParameterizedType)genericType;
                this.baseType = (Class)zType.getActualTypeArguments()[0];
                this.baseGenericType = zType.getActualTypeArguments()[0];
            } else {
                this.baseType = String.class;
                this.baseGenericType = null;
            }
        }
        if (!this.baseType.isPrimitive()) {
            this.paramConverter = factory.getParamConverter(this.baseType, this.baseGenericType, annotations);
            if (this.paramConverter != null) {
                return;
            }
            this.unmarshaller = factory.createStringParameterUnmarshaller(this.baseType);
            if (this.unmarshaller != null) {
                this.unmarshaller.setAnnotations(annotations);
                return;
            }
            for (Annotation annotation : annotations) {
                StringParameterUnmarshallerBinder binder = annotation.annotationType().getAnnotation(StringParameterUnmarshallerBinder.class);
                if (binder == null) continue;
                try {
                    this.unmarshaller = binder.value().newInstance();
                }
                catch (InstantiationException e) {
                    throw new RuntimeException(e.getCause());
                }
                catch (IllegalAccessException e) {
                    throw new RuntimeException(e);
                }
                factory.injectProperties(this.unmarshaller);
                this.unmarshaller.setAnnotations(annotations);
                return;
            }
            this.converter = factory.getStringConverter(this.baseType);
            if (this.converter != null) {
                return;
            }
            if (paramType.equals(HeaderParam.class)) {
                this.delegate = factory.createHeaderDelegate(this.baseType);
                if (this.delegate != null) {
                    return;
                }
            }
            try {
                this.constructor = this.baseType.getConstructor(String.class);
                if (!Modifier.isPublic(this.constructor.getModifiers())) {
                    this.constructor = null;
                }
            }
            catch (NoSuchMethodException ignored) {
                // empty catch block
            }
            if (this.constructor == null) {
                try {
                    Method fromValue = this.baseType.getDeclaredMethod("fromValue", String.class);
                    if (Modifier.isPublic(fromValue.getModifiers())) {
                        for (Annotation ann : this.baseType.getAnnotations()) {
                            if (!ann.annotationType().getName().equals("javax.xml.bind.annotation.XmlEnum")) continue;
                            this.valueOf = fromValue;
                        }
                    }
                }
                catch (NoSuchMethodException e) {
                    // empty catch block
                }
                if (this.valueOf == null) {
                    Method fromString = null;
                    try {
                        fromString = this.baseType.getDeclaredMethod("fromString", String.class);
                        if (!Modifier.isStatic(fromString.getModifiers())) {
                            fromString = null;
                        }
                    }
                    catch (NoSuchMethodException ignored) {
                        // empty catch block
                    }
                    try {
                        this.valueOf = this.baseType.getDeclaredMethod("valueOf", String.class);
                        if (!Modifier.isStatic(this.valueOf.getModifiers())) {
                            this.valueOf = null;
                        }
                    }
                    catch (NoSuchMethodException ignored) {
                        // empty catch block
                    }
                    if (this.baseType.isEnum()) {
                        if (fromString != null) {
                            this.valueOf = fromString;
                        }
                    } else if (this.valueOf == null) {
                        this.valueOf = fromString;
                    }
                    if (this.valueOf == null) {
                        throw new RuntimeException("Unable to find a constructor that takes a String param or a valueOf() or fromString() method for " + this.getParamSignature() + " on " + target + " for basetype: " + this.baseType.getName());
                    }
                }
            }
        }
    }

    public String getParamSignature() {
        return this.paramType.getName() + "(\"" + this.paramName + "\")";
    }

    public Object extractValues(List<String> values) {
        if (values == null && (this.type.isArray() || this.isCollection) && this.defaultValue != null) {
            values = new ArrayList<String>(1);
            values.add(this.defaultValue);
        } else if (values == null) {
            values = Collections.emptyList();
        }
        if (this.type.isArray()) {
            if (values == null) {
                return null;
            }
            Object vals = Array.newInstance(this.type.getComponentType(), values.size());
            for (int i = 0; i < values.size(); ++i) {
                Array.set(vals, i, this.extractValue(values.get(i)));
            }
            return vals;
        }
        if (this.isCollection) {
            if (values == null) {
                return null;
            }
            Collection collection = null;
            try {
                collection = this.collectionType.newInstance();
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
            for (String str : values) {
                collection.add(this.extractValue(str));
            }
            return collection;
        }
        if (values == null) {
            return this.extractValue(null);
        }
        if (values.size() == 0) {
            return this.extractValue(null);
        }
        return this.extractValue(values.get(0));
    }

    public Object extractValue(String strVal) {
        if (strVal == null) {
            if (this.defaultValue == null) {
                if (!this.baseType.isPrimitive()) {
                    return null;
                }
            } else {
                strVal = this.defaultValue;
            }
        }
        if (this.baseType.isPrimitive()) {
            return StringToPrimitive.stringToPrimitiveBoxType(this.baseType, strVal);
        }
        if (this.paramConverter != null) {
            return this.paramConverter.fromString(strVal);
        }
        if (this.converter != null) {
            return this.converter.fromString(strVal);
        }
        if (this.unmarshaller != null) {
            return this.unmarshaller.fromString(strVal);
        }
        if (this.delegate != null) {
            return this.delegate.fromString(strVal);
        }
        if (this.constructor != null) {
            try {
                return this.constructor.newInstance(strVal);
            }
            catch (InstantiationException e) {
                throw new BadRequestException("Unable to extract parameter from http request for " + this.getParamSignature() + " value is '" + strVal + "'" + " for " + this.target, e);
            }
            catch (IllegalAccessException e) {
                throw new BadRequestException("Unable to extract parameter from http request: " + this.getParamSignature() + " value is '" + strVal + "'" + " for " + this.target, e);
            }
            catch (InvocationTargetException e) {
                throw new BadRequestException("Unable to extract parameter from http request: " + this.getParamSignature() + " value is '" + strVal + "'" + " for " + this.target, e);
            }
        }
        if (this.valueOf != null) {
            try {
                return this.valueOf.invoke(null, strVal);
            }
            catch (IllegalAccessException e) {
                throw new BadRequestException("Unable to extract parameter from http request: " + this.getParamSignature() + " value is '" + strVal + "'" + " for " + this.target, e);
            }
            catch (InvocationTargetException e) {
                throw new BadRequestException("Unable to extract parameter from http request: " + this.getParamSignature() + " value is '" + strVal + "'" + " for " + this.target, e.getTargetException());
            }
        }
        return null;
    }
}

