/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.resteasy.plugins.server.resourcefactory;

import org.jboss.resteasy.spi.ConstructorInjector;
import org.jboss.resteasy.spi.HttpRequest;
import org.jboss.resteasy.spi.HttpResponse;
import org.jboss.resteasy.spi.PropertyInjector;
import org.jboss.resteasy.spi.ResourceFactory;
import org.jboss.resteasy.spi.ResteasyProviderFactory;
import org.jboss.resteasy.spi.metadata.ResourceBuilder;
import org.jboss.resteasy.spi.metadata.ResourceClass;
import org.jboss.resteasy.spi.metadata.ResourceConstructor;

public class POJOResourceFactory
implements ResourceFactory {
    private final Class<?> scannableClass;
    private final ResourceClass resourceClass;
    private ConstructorInjector constructorInjector;
    private PropertyInjector propertyInjector;

    public POJOResourceFactory(Class<?> scannableClass) {
        this.scannableClass = scannableClass;
        this.resourceClass = ResourceBuilder.fromAnnotations(scannableClass);
    }

    public POJOResourceFactory(ResourceClass resourceClass) {
        this.scannableClass = resourceClass.getClazz();
        this.resourceClass = resourceClass;
    }

    @Override
    public void registered(ResteasyProviderFactory factory) {
        ResourceConstructor constructor = this.resourceClass.getConstructor();
        if (constructor == null) {
            constructor = ResourceBuilder.constructor(this.resourceClass.getClazz());
        }
        if (constructor == null) {
            throw new RuntimeException("Unable to find a public constructor for class " + this.scannableClass.getName());
        }
        this.constructorInjector = factory.getInjectorFactory().createConstructor(constructor, factory);
        this.propertyInjector = factory.getInjectorFactory().createPropertyInjector(this.resourceClass, factory);
    }

    @Override
    public Object createResource(HttpRequest request, HttpResponse response, ResteasyProviderFactory factory) {
        Object obj = this.constructorInjector.construct(request, response);
        this.propertyInjector.inject(request, response, obj);
        return obj;
    }

    @Override
    public void unregistered() {
    }

    @Override
    public Class<?> getScannableClass() {
        return this.scannableClass;
    }

    @Override
    public void requestFinished(HttpRequest request, HttpResponse response, Object resource) {
    }
}

