/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.resteasy.specimpl;

import java.net.URI;
import javax.ws.rs.core.Link;
import javax.ws.rs.core.UriBuilder;
import javax.ws.rs.core.UriBuilderException;
import org.jboss.resteasy.specimpl.LinkImpl;

public class LinkBuilderImpl
implements Link.Builder {
    protected LinkImpl link = new LinkImpl();
    protected UriBuilder uriBuilder;
    protected URI baseUri = null;

    public Link.Builder link(Link link) {
        this.uriBuilder = UriBuilder.fromUri((URI)link.getUri());
        this.link.map.clear();
        this.link.map.putAll(link.getParams());
        return this;
    }

    public Link.Builder link(String link) {
        Link l = LinkImpl.valueOf((String)link);
        return this.link(l);
    }

    public Link.Builder uriBuilder(UriBuilder uriBuilder) {
        this.uriBuilder = uriBuilder.clone();
        return this;
    }

    public Link.Builder uri(URI uri) {
        this.uriBuilder = UriBuilder.fromUri((URI)uri);
        return this;
    }

    public Link.Builder uri(String uri) throws IllegalArgumentException {
        this.uriBuilder = UriBuilder.fromUri((String)uri);
        return this;
    }

    public Link.Builder rel(String rel) {
        String rels = this.link.map.get("rel");
        this.param("rel", rels == null ? rel : rels + " " + rel);
        return this;
    }

    public Link.Builder title(String title) {
        this.param("title", title);
        return this;
    }

    public Link.Builder type(String type) {
        this.param("type", type);
        return this;
    }

    public Link.Builder param(String name, String value) throws IllegalArgumentException {
        if (name == null || value == null) {
            throw new IllegalArgumentException("Link parameter name or value is null");
        }
        this.link.map.put(name, value);
        return this;
    }

    public Link build(Object ... values) throws UriBuilderException {
        this.link.uri = this.uriBuilder.build(values);
        return this.link;
    }

    public Link buildRelativized(URI uri, Object ... values) {
        URI built;
        URI with = built = this.uriBuilder.build(values);
        if (this.baseUri != null) {
            with = this.baseUri.resolve(built);
        }
        this.link.uri = uri.relativize(with);
        return this.link;
    }

    public Link.Builder baseUri(URI uri) {
        this.baseUri = uri;
        return this;
    }

    public Link.Builder baseUri(String uri) {
        this.baseUri = URI.create(uri);
        return this;
    }
}

