/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.resteasy.plugins.providers.sse;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.lang.annotation.Annotation;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import java.util.function.BiConsumer;
import javax.ws.rs.ProcessingException;
import javax.ws.rs.core.GenericType;
import javax.ws.rs.core.Response;
import javax.ws.rs.ext.MessageBodyWriter;
import javax.ws.rs.sse.OutboundSseEvent;
import javax.ws.rs.sse.SseEventSink;
import org.jboss.resteasy.core.ServerResponseWriter;
import org.jboss.resteasy.plugins.providers.sse.SseConstants;
import org.jboss.resteasy.resteasy_jaxrs.i18n.LogMessages;
import org.jboss.resteasy.resteasy_jaxrs.i18n.Messages;
import org.jboss.resteasy.specimpl.BuiltResponse;
import org.jboss.resteasy.spi.HttpRequest;
import org.jboss.resteasy.spi.HttpResponse;
import org.jboss.resteasy.spi.ResteasyAsynchronousContext;
import org.jboss.resteasy.spi.ResteasyProviderFactory;

public class SseEventOutputImpl
extends GenericType<OutboundSseEvent>
implements SseEventSink {
    private final MessageBodyWriter<OutboundSseEvent> writer;
    private final ResteasyAsynchronousContext asyncContext;
    private final HttpResponse response;
    private final HttpRequest request;
    private volatile boolean closed;
    private final Map<Class<?>, Object> contextDataMap;
    private boolean responseFlushed = false;

    public SseEventOutputImpl(MessageBodyWriter<OutboundSseEvent> writer) {
        this.writer = writer;
        this.contextDataMap = ResteasyProviderFactory.getContextDataMap();
        this.request = ResteasyProviderFactory.getContextData(HttpRequest.class);
        this.asyncContext = this.request.getAsyncContext();
        if (!this.asyncContext.isSuspended()) {
            try {
                this.asyncContext.suspend();
            }
            catch (IllegalStateException ex) {
                LogMessages.LOGGER.failedToSetRequestAsync();
            }
        }
        this.response = ResteasyProviderFactory.getContextData(HttpResponse.class);
    }

    public synchronized void close() {
        this.closed = true;
        if (this.asyncContext.isSuspended() && this.asyncContext.getAsyncResponse() != null && this.asyncContext.isSuspended()) {
            this.asyncContext.getAsyncResponse().resume(Response.noContent().build());
        }
    }

    protected synchronized void flushResponseToClient() {
        if (!this.responseFlushed) {
            BuiltResponse jaxrsResponse = (BuiltResponse)Response.ok().type("text/event-stream").build();
            try {
                ServerResponseWriter.writeNomapResponse(jaxrsResponse, this.request, this.response, ResteasyProviderFactory.getInstance(), t -> {}, true);
                this.response.getOutputStream().write(SseConstants.EOL);
                this.response.getOutputStream().write(SseConstants.EOL);
                this.response.flushBuffer();
                this.responseFlushed = true;
            }
            catch (IOException e) {
                this.close();
                throw new ProcessingException(Messages.MESSAGES.failedToCreateSseEventOutput(), (Throwable)e);
            }
        }
    }

    public boolean isClosed() {
        return this.closed;
    }

    public CompletionStage<?> send(OutboundSseEvent event) {
        return this.send(event, (a, b) -> {});
    }

    public CompletionStage<?> send(OutboundSseEvent event, BiConsumer<SseEventSink, Throwable> errorConsumer) {
        if (this.closed) {
            throw new IllegalStateException(Messages.MESSAGES.sseEventSinkIsClosed());
        }
        this.flushResponseToClient();
        try {
            this.writeEvent(event);
        }
        catch (Exception ex) {
            errorConsumer.accept(this, ex);
            return CompletableFuture.completedFuture(ex);
        }
        return CompletableFuture.completedFuture(event);
    }

    protected synchronized void writeEvent(OutboundSseEvent event) throws IOException {
        ResteasyProviderFactory.pushContextDataMap(this.contextDataMap);
        try {
            if (event != null) {
                ByteArrayOutputStream bout = new ByteArrayOutputStream();
                this.writer.writeTo((Object)event, event.getClass(), null, new Annotation[0], event.getMediaType(), null, (OutputStream)bout);
                this.response.getOutputStream().write(bout.toByteArray());
                this.response.flushBuffer();
            }
        }
        catch (IOException e) {
            this.close();
            LogMessages.LOGGER.failedToWriteSseEvent(event.toString(), e);
            throw e;
        }
        catch (Exception e) {
            LogMessages.LOGGER.failedToWriteSseEvent(event.toString(), e);
            throw new ProcessingException((Throwable)e);
        }
        finally {
            ResteasyProviderFactory.removeContextDataLevel();
        }
    }
}

