/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.resteasy.plugins.providers.sse;

import java.io.IOException;
import javax.annotation.Priority;
import javax.ws.rs.container.ContainerRequestContext;
import javax.ws.rs.container.ContainerRequestFilter;
import javax.ws.rs.core.MediaType;
import javax.ws.rs.ext.Provider;
import javax.ws.rs.sse.SseEventSink;
import org.jboss.resteasy.core.interception.jaxrs.PostMatchContainerRequestContext;
import org.jboss.resteasy.plugins.providers.sse.SseEventOutputImpl;
import org.jboss.resteasy.plugins.providers.sse.SseEventProvider;
import org.jboss.resteasy.plugins.server.servlet.Cleanable;
import org.jboss.resteasy.plugins.server.servlet.Cleanables;
import org.jboss.resteasy.spi.ResteasyProviderFactory;

@Provider
@Priority(value=0x7FFFFFFF)
public class SseEventSinkInterceptor
implements ContainerRequestFilter {
    public void filter(ContainerRequestContext requestContext) throws IOException {
        if (requestContext.getAcceptableMediaTypes().contains(MediaType.SERVER_SENT_EVENTS_TYPE)) {
            this.enableSse(requestContext);
            return;
        }
        if (requestContext instanceof PostMatchContainerRequestContext) {
            PostMatchContainerRequestContext postContext = (PostMatchContainerRequestContext)requestContext;
            for (MediaType produce : postContext.getResourceMethod().getProduces()) {
                if (!produce.equals((Object)MediaType.SERVER_SENT_EVENTS_TYPE)) continue;
                this.enableSse(requestContext);
                return;
            }
        }
    }

    private void enableSse(ContainerRequestContext requestContext) {
        final SseEventOutputImpl sink = new SseEventOutputImpl(new SseEventProvider());
        if (requestContext instanceof PostMatchContainerRequestContext) {
            ((PostMatchContainerRequestContext)requestContext).getResourceMethod().markMethodAsAsync();
        }
        ResteasyProviderFactory.getContextDataMap().put(SseEventSink.class, (Object)sink);
        ResteasyProviderFactory.getContextData(Cleanables.class).addCleanable(new Cleanable(){

            @Override
            public void clean() throws Exception {
                sink.flushResponseToClient();
            }
        });
    }
}

