package org.jboss.resteasy.plugins.delegates;

import static javax.ws.rs.core.MediaType.MEDIA_TYPE_WILDCARD;

import javax.ws.rs.core.MediaType;

import org.jboss.resteasy.resteasy_jaxrs.i18n.Messages;

public class SimpleMediaType
{
   private String type;
   private String subtype;

   public SimpleMediaType(String type, String subtype) {
       this.type = type == null ? MEDIA_TYPE_WILDCARD : type;
       this.subtype = subtype == null ? MEDIA_TYPE_WILDCARD : subtype;
   }

   public SimpleMediaType() {
       this(MEDIA_TYPE_WILDCARD, MEDIA_TYPE_WILDCARD);
   }

   public String getType()
   {
      return type;
   }

   public boolean isWildcardType()
   {
      return this.getType().equals(MEDIA_TYPE_WILDCARD);
   }

   public String getSubtype()
   {
      return subtype;
   }

   public boolean isWildcardSubtype()
   {
      return this.getSubtype().equals(MEDIA_TYPE_WILDCARD);
   }

   /**
    * Check if this media type is compatible with another media type. E.g.
    * image/* is compatible with image/jpeg, image/png, etc. Media type
    * parameters are ignored. The function is commutative.
    *
    * @param other the media type to compare with.
    * @return true if the types are compatible, false otherwise.
    */
   public boolean isCompatible(MediaType other)
   {
      return other != null && // return false if other is null, else
            (type.equals(MEDIA_TYPE_WILDCARD) || other.getType().equals(MEDIA_TYPE_WILDCARD) || // both are wildcard types, or
                  (type.equalsIgnoreCase(other.getType())
                        && (subtype.equals(MEDIA_TYPE_WILDCARD) || other.getSubtype().equals(MEDIA_TYPE_WILDCARD)))
                  || // same types, wildcard sub-types, or
                  (type.equalsIgnoreCase(other.getType()) && this.subtype.equalsIgnoreCase(other.getSubtype()))); // same types & sub-types
   }

   @Override
   public boolean equals(Object obj)
   {
      if (!(obj instanceof SimpleMediaType))
      {
         return false;
      }

      SimpleMediaType other = (SimpleMediaType) obj;
      return (this.type.equalsIgnoreCase(other.type) && this.subtype.equalsIgnoreCase(other.subtype));
   }

   @Override
   public int hashCode()
   {
      return (this.type.toLowerCase() + this.subtype.toLowerCase()).hashCode();
   }
   
   public static SimpleMediaType valueOf(String type)
   {
      int typeIndex = type.indexOf('/');
      int paramIndex = type.indexOf(';');
      String major = null;
      String subtype = null;
      if (typeIndex < 0) // possible "*"
      {
         major = type;
         if (paramIndex > -1)
         {
            major = major.substring(0, paramIndex);
         }
         if (!MediaType.MEDIA_TYPE_WILDCARD.equals(major))
         {
            throw new IllegalArgumentException(Messages.MESSAGES.failureParsingMediaType(type));
         }
         subtype = MediaType.MEDIA_TYPE_WILDCARD;
      }
      else
      {
         major = type.substring(0, typeIndex);
         if (paramIndex > -1)
         {
            subtype = type.substring(typeIndex + 1, paramIndex);
         }
         else
         {
            subtype = type.substring(typeIndex + 1);
         }
      }
      if (major.length() < 1 || subtype.length() < 1)
      {
         throw new IllegalArgumentException(Messages.MESSAGES.failureParsingMediaType(type));
      }
      if (!MediaTypeHeaderDelegate.isValid(major) || !MediaTypeHeaderDelegate.isValid(subtype))
      {
         throw new IllegalArgumentException(Messages.MESSAGES.failureParsingMediaType(type));
      }
      return new SimpleMediaType(type, subtype);
   }

}
