/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.resteasy.tracing;

import java.util.ArrayList;
import java.util.List;
import org.jboss.resteasy.tracing.RESTEasyTracingMessage;

public class RESTEasyTracingInfo {
    private final List<RESTEasyTracingMessage> messageList = new ArrayList<RESTEasyTracingMessage>();

    public void addMessage(RESTEasyTracingMessage message) {
        this.messageList.add(message);
    }

    public static String formatDuration(long duration) {
        if (duration == 0L) {
            return " ----";
        }
        return String.format("%5.2f", (double)duration / 1000000.0);
    }

    public static String formatDuration(long fromTimestamp, long toTimestamp) {
        return RESTEasyTracingInfo.formatDuration(toTimestamp - fromTimestamp);
    }

    public static String formatPercent(long value, long top) {
        if (value == 0L) {
            return "  ----";
        }
        return String.format("%6.2f", 100.0 * (double)value / (double)top);
    }

    public String[] getMessages() {
        long fromTimestamp = this.messageList.get(0).getTimestamp() - this.messageList.get(0).getDuration();
        long toTimestamp = this.messageList.get(this.messageList.size() - 1).getTimestamp();
        String[] messages = new String[this.messageList.size()];
        for (int i = 0; i < messages.length; ++i) {
            RESTEasyTracingMessage message = this.messageList.get(i);
            StringBuilder text = new StringBuilder();
            text.append(String.format("%-11s ", message.getEvent().category()));
            text.append('[').append(RESTEasyTracingInfo.formatDuration(message.getDuration())).append(" / ").append(RESTEasyTracingInfo.formatDuration(fromTimestamp, message.getTimestamp())).append(" ms |").append(RESTEasyTracingInfo.formatPercent(message.getDuration(), toTimestamp - fromTimestamp)).append(" %] ");
            text.append(message.toString());
            messages[i] = text.toString();
        }
        return messages;
    }
}

