/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.resteasy.plugins.providers.multipart;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.SequenceInputStream;
import java.io.UnsupportedEncodingException;
import java.lang.annotation.Annotation;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.lang.reflect.Type;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Stack;
import javax.ws.rs.core.GenericType;
import javax.ws.rs.core.MediaType;
import javax.ws.rs.core.MultivaluedMap;
import javax.ws.rs.ext.MessageBodyReader;
import javax.ws.rs.ext.Providers;
import org.apache.james.mime4j.MimeException;
import org.apache.james.mime4j.MimeIOException;
import org.apache.james.mime4j.codec.Base64InputStream;
import org.apache.james.mime4j.codec.QuotedPrintableInputStream;
import org.apache.james.mime4j.descriptor.BodyDescriptor;
import org.apache.james.mime4j.field.ContentTypeField;
import org.apache.james.mime4j.message.BinaryBody;
import org.apache.james.mime4j.message.Body;
import org.apache.james.mime4j.message.BodyFactory;
import org.apache.james.mime4j.message.BodyPart;
import org.apache.james.mime4j.message.Entity;
import org.apache.james.mime4j.message.Message;
import org.apache.james.mime4j.message.MessageBuilder;
import org.apache.james.mime4j.message.Multipart;
import org.apache.james.mime4j.message.TextBody;
import org.apache.james.mime4j.parser.ContentHandler;
import org.apache.james.mime4j.parser.MimeStreamParser;
import org.apache.james.mime4j.storage.DefaultStorageProvider;
import org.apache.james.mime4j.storage.StorageProvider;
import org.jboss.resteasy.core.ProvidersContextRetainer;
import org.jboss.resteasy.plugins.providers.multipart.InputPart;
import org.jboss.resteasy.plugins.providers.multipart.MultipartConstants;
import org.jboss.resteasy.plugins.providers.multipart.MultipartInput;
import org.jboss.resteasy.plugins.providers.multipart.i18n.Messages;
import org.jboss.resteasy.resteasy_jaxrs.i18n.LogMessages;
import org.jboss.resteasy.spi.HttpRequest;
import org.jboss.resteasy.spi.ResteasyProviderFactory;
import org.jboss.resteasy.util.CaseInsensitiveMap;

public class MultipartInputImpl
implements MultipartInput,
ProvidersContextRetainer {
    protected MediaType contentType;
    protected Providers workers;
    protected Message mimeMessage;
    protected List<InputPart> parts = new ArrayList<InputPart>();
    protected static final Annotation[] empty = new Annotation[0];
    protected MediaType defaultPartContentType = MultipartConstants.TEXT_PLAIN_WITH_CHARSET_US_ASCII_TYPE;
    protected String defaultPartCharset = null;
    protected Providers savedProviders;

    public MultipartInputImpl(MediaType contentType, Providers workers) {
        this.contentType = contentType;
        this.workers = workers;
        HttpRequest httpRequest = (HttpRequest)ResteasyProviderFactory.getContextData(HttpRequest.class);
        if (httpRequest != null) {
            String defaultContentType = (String)httpRequest.getAttribute("resteasy.provider.multipart.inputpart.defaultContentType");
            if (defaultContentType != null) {
                this.defaultPartContentType = MediaType.valueOf((String)defaultContentType);
            }
            this.defaultPartCharset = (String)httpRequest.getAttribute("resteasy.provider.multipart.inputpart.defaultCharset");
            if (this.defaultPartCharset != null) {
                this.defaultPartContentType = this.getMediaTypeWithDefaultCharset(this.defaultPartContentType);
            }
        }
    }

    public MultipartInputImpl(MediaType contentType, Providers workers, MediaType defaultPartContentType, String defaultPartCharset) {
        this.contentType = contentType;
        this.workers = workers;
        if (defaultPartContentType != null) {
            this.defaultPartContentType = defaultPartContentType;
        }
        this.defaultPartCharset = defaultPartCharset;
        if (defaultPartCharset != null) {
            this.defaultPartContentType = this.getMediaTypeWithDefaultCharset(this.defaultPartContentType);
        }
    }

    public MultipartInputImpl(Multipart multipart, Providers workers) throws IOException {
        for (BodyPart bodyPart : multipart.getBodyParts()) {
            this.parts.add(this.extractPart(bodyPart));
        }
        this.workers = workers;
    }

    public void parse(InputStream is) throws IOException {
        this.mimeMessage = new BinaryMessage(this.addHeaderToHeadlessStream(is));
        this.extractParts();
    }

    protected InputStream addHeaderToHeadlessStream(InputStream is) throws UnsupportedEncodingException {
        return new SequenceInputStream(this.createHeaderInputStream(), is);
    }

    protected InputStream createHeaderInputStream() throws UnsupportedEncodingException {
        String header = "Content-Type: " + this.contentType + "\r\n\r\n";
        return new ByteArrayInputStream(header.getBytes(StandardCharsets.UTF_8));
    }

    @Override
    public String getPreamble() {
        return ((Multipart)this.mimeMessage.getBody()).getPreamble();
    }

    @Override
    public List<InputPart> getParts() {
        return this.parts;
    }

    protected void extractParts() throws IOException {
        Multipart multipart = (Multipart)this.mimeMessage.getBody();
        for (BodyPart bodyPart : multipart.getBodyParts()) {
            this.parts.add(this.extractPart(bodyPart));
        }
    }

    protected InputPart extractPart(BodyPart bodyPart) throws IOException {
        return new PartImpl(bodyPart);
    }

    public static void main(String[] args) throws Exception {
        String input = "URLSTR: file:/Users/billburke/jboss/resteasy-jaxrs/resteasy-jaxrs/src/test/test-data/data.txt\r\n--B98hgCmKsQ-B5AUFnm2FnDRCgHPDE3\r\nContent-Disposition: form-data; name=\"part1\"\r\nContent-Type: text/plain; charset=US-ASCII\r\nContent-Transfer-Encoding: 8bit\r\n\r\nThis is Value 1\r\n--B98hgCmKsQ-B5AUFnm2FnDRCgHPDE3\r\nContent-Disposition: form-data; name=\"part2\"\r\nContent-Type: text/plain; charset=US-ASCII\r\nContent-Transfer-Encoding: 8bit\r\n\r\nThis is Value 2\r\n--B98hgCmKsQ-B5AUFnm2FnDRCgHPDE3\r\nContent-Disposition: form-data; name=\"data.txt\"; filename=\"data.txt\"\r\nContent-Type: application/octet-stream; charset=ISO-8859-1\r\nContent-Transfer-Encoding: binary\r\n\r\nhello world\r\n--B98hgCmKsQ-B5AUFnm2FnDRCgHPDE3--";
        ByteArrayInputStream bais = new ByteArrayInputStream(input.getBytes());
        LinkedHashMap<String, String> parameters = new LinkedHashMap<String, String>();
        parameters.put("boundary", "B98hgCmKsQ-B5AUFnm2FnDRCgHPDE3");
        MediaType contentType = new MediaType("multipart", "form-data", parameters);
        MultipartInputImpl multipart = new MultipartInputImpl(contentType, null);
        multipart.parse(bais);
        System.out.println(multipart.getPreamble());
        System.out.println("**********");
        for (InputPart part : multipart.getParts()) {
            System.out.println("--");
            System.out.println("\"" + part.getBodyAsString() + "\"");
        }
        System.out.println("done");
    }

    @Override
    public void close() {
        if (this.mimeMessage != null) {
            try {
                this.mimeMessage.dispose();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    protected void finalize() throws Throwable {
        this.close();
    }

    protected String getCharset(MediaType mediaType) {
        for (String key : mediaType.getParameters().keySet()) {
            if (!"charset".equalsIgnoreCase(key)) continue;
            return (String)mediaType.getParameters().get(key);
        }
        return null;
    }

    private MediaType getMediaTypeWithDefaultCharset(MediaType mediaType) {
        String charset = this.defaultPartCharset;
        return this.getMediaTypeWithCharset(mediaType, charset);
    }

    private MediaType getMediaTypeWithCharset(MediaType mediaType, String charset) {
        Map params = mediaType.getParameters();
        LinkedHashMap<String, String> newParams = new LinkedHashMap<String, String>();
        newParams.put("charset", charset);
        for (String key : params.keySet()) {
            if ("charset".equalsIgnoreCase(key)) continue;
            newParams.put(key, (String)params.get(key));
        }
        return new MediaType(mediaType.getType(), mediaType.getSubtype(), newParams);
    }

    public void setProviders(Providers providers) {
        this.savedProviders = providers;
    }

    public class PartImpl
    implements InputPart {
        private BodyPart bodyPart;
        private MediaType contentType;
        private MultivaluedMap<String, String> headers = new CaseInsensitiveMap();
        private boolean contentTypeFromMessage;

        public PartImpl(BodyPart bodyPart) {
            this.bodyPart = bodyPart;
            for (org.apache.james.mime4j.parser.Field field : bodyPart.getHeader()) {
                this.headers.add((Object)field.getName(), (Object)field.getBody());
                if (!(field instanceof ContentTypeField)) continue;
                this.contentType = MediaType.valueOf((String)field.getBody());
                this.contentTypeFromMessage = true;
            }
            if (this.contentType == null) {
                this.contentType = MultipartInputImpl.this.defaultPartContentType;
            }
            if (MultipartInputImpl.this.getCharset(this.contentType) == null) {
                if (MultipartInputImpl.this.defaultPartCharset != null) {
                    this.contentType = MultipartInputImpl.this.getMediaTypeWithDefaultCharset(this.contentType);
                } else if (this.contentType.getType().equalsIgnoreCase("text")) {
                    this.contentType = MultipartInputImpl.this.getMediaTypeWithCharset(this.contentType, "us-ascii");
                }
            }
        }

        @Override
        public void setMediaType(MediaType mediaType) {
            this.contentType = mediaType;
            this.contentTypeFromMessage = false;
            this.headers.putSingle((Object)"Content-Type", (Object)mediaType.toString());
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public <T> T getBody(Class<T> type, Type genericType) throws IOException {
            if (MultipartInput.class.equals(type) && this.bodyPart.getBody() instanceof Multipart) {
                return (T)new MultipartInputImpl((Multipart)Multipart.class.cast(this.bodyPart.getBody()), MultipartInputImpl.this.workers);
            }
            try {
                MessageBodyReader reader;
                if (MultipartInputImpl.this.savedProviders != null) {
                    ResteasyProviderFactory.pushContext(Providers.class, (Object)MultipartInputImpl.this.savedProviders);
                }
                if ((reader = MultipartInputImpl.this.workers.getMessageBodyReader(type, genericType, empty, this.contentType)) == null) {
                    throw new RuntimeException(Messages.MESSAGES.unableToFindMessageBodyReader(this.contentType, type.getName()));
                }
                LogMessages.LOGGER.debugf("MessageBodyReader: %s", (Object)reader.getClass().getName());
                Object object = reader.readFrom(type, genericType, empty, this.contentType, this.headers, this.getBody());
                return (T)object;
            }
            finally {
                if (MultipartInputImpl.this.savedProviders != null) {
                    ResteasyProviderFactory.popContextData(Providers.class);
                }
            }
        }

        @Override
        public <T> T getBody(GenericType<T> type) throws IOException {
            return this.getBody(type.getRawType(), type.getType());
        }

        public InputStream getBody() throws IOException {
            Body body = this.bodyPart.getBody();
            InputStream result = null;
            if (body instanceof TextBody) {
                throw new UnsupportedOperationException();
            }
            if (body instanceof BinaryBody) {
                return ((BinaryBody)body).getInputStream();
            }
            return result;
        }

        @Override
        public String getBodyAsString() throws IOException {
            return this.getBody(String.class, null);
        }

        @Override
        public MultivaluedMap<String, String> getHeaders() {
            return this.headers;
        }

        @Override
        public MediaType getMediaType() {
            return this.contentType;
        }

        @Override
        public boolean isContentTypeFromMessage() {
            return this.contentTypeFromMessage;
        }
    }

    private static class BinaryMessage
    extends Message {
        private BinaryMessage(InputStream is) throws IOException, MimeIOException {
            try {
                MimeStreamParser parser = new MimeStreamParser(null);
                parser.setContentHandler((ContentHandler)new BinaryOnlyMessageBuilder((Entity)this, DefaultStorageProvider.getInstance()));
                parser.parse(is);
            }
            catch (MimeException e) {
                throw new MimeIOException(e);
            }
        }
    }

    private static class BinaryOnlyMessageBuilder
    extends MessageBuilder {
        private Method expectMethod;
        private Field bodyFactoryField;
        private Field stackField;

        private void init() {
            try {
                this.expectMethod = MessageBuilder.class.getDeclaredMethod("expect", Class.class);
                this.expectMethod.setAccessible(true);
                this.bodyFactoryField = MessageBuilder.class.getDeclaredField("bodyFactory");
                this.bodyFactoryField.setAccessible(true);
                this.stackField = MessageBuilder.class.getDeclaredField("stack");
                this.stackField.setAccessible(true);
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        }

        private BinaryOnlyMessageBuilder(Entity entity) {
            super(entity);
            this.init();
        }

        private BinaryOnlyMessageBuilder(Entity entity, StorageProvider storageProvider) {
            super(entity, storageProvider);
            this.init();
        }

        public void body(BodyDescriptor bd, InputStream is) throws MimeException, IOException {
            Stack st;
            BodyFactory factory;
            try {
                this.expectMethod.invoke((Object)this, Entity.class);
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
            String enc = bd.getTransferEncoding();
            Object decodedStream = "base64".equals(enc) ? new Base64InputStream(is) : ("quoted-printable".equals(enc) ? new QuotedPrintableInputStream(is) : is);
            try {
                factory = (BodyFactory)this.bodyFactoryField.get((Object)this);
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
            BinaryBody body = factory.binaryBody((InputStream)decodedStream);
            try {
                st = (Stack)this.stackField.get((Object)this);
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
            Entity entity = (Entity)st.peek();
            entity.setBody((Body)body);
        }
    }
}

