/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.resteasy.plugins.providers;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.lang.annotation.Annotation;
import java.lang.reflect.Type;
import javax.ws.rs.Consumes;
import javax.ws.rs.Produces;
import javax.ws.rs.WebApplicationException;
import javax.ws.rs.core.HttpHeaders;
import javax.ws.rs.core.MediaType;
import javax.ws.rs.core.MultivaluedMap;
import javax.ws.rs.ext.MessageBodyReader;
import javax.ws.rs.ext.MessageBodyWriter;
import javax.ws.rs.ext.Provider;
import org.jboss.resteasy.plugins.providers.FileRangeException;
import org.jboss.resteasy.plugins.providers.ProviderHelper;
import org.jboss.resteasy.resteasy_jaxrs.i18n.LogMessages;
import org.jboss.resteasy.spi.ResteasyProviderFactory;
import org.jboss.resteasy.util.NoContent;

@Provider
@Produces(value={"*/*"})
@Consumes(value={"*/*"})
public class FileProvider
implements MessageBodyReader<File>,
MessageBodyWriter<File> {
    private static final String PREFIX = "pfx";
    private static final String SUFFIX = "sfx";
    private String _downloadDirectory = null;

    public boolean isReadable(Class<?> type, Type genericType, Annotation[] annotations, MediaType mediaType) {
        return File.class == type;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public File readFrom(Class<File> type, Type genericType, Annotation[] annotations, MediaType mediaType, MultivaluedMap<String, String> httpHeaders, InputStream entityStream) throws IOException {
        LogMessages.LOGGER.debugf("Provider : %s,  Method : readFrom", this.getClass().getName());
        File downloadedFile = null;
        if (this._downloadDirectory != null) {
            try {
                downloadedFile = File.createTempFile(PREFIX, SUFFIX, new File(this._downloadDirectory));
            }
            catch (IOException ex) {
                LogMessages.LOGGER.couldNotBindToDirectory(this._downloadDirectory);
            }
        }
        if (downloadedFile == null) {
            downloadedFile = File.createTempFile(PREFIX, SUFFIX);
        }
        if (NoContent.isContentLengthZero(httpHeaders)) {
            return downloadedFile;
        }
        try (BufferedOutputStream output = new BufferedOutputStream(new FileOutputStream(downloadedFile));){
            ProviderHelper.writeTo(entityStream, output);
        }
        return downloadedFile;
    }

    public boolean isWriteable(Class<?> type, Type genericType, Annotation[] annotations, MediaType mediaType) {
        return File.class.isAssignableFrom(type);
    }

    public long getSize(File o, Class<?> type, Type genericType, Annotation[] annotations, MediaType mediaType) {
        return o.length();
    }

    public void writeTo(File uploadFile, Class<?> type, Type genericType, Annotation[] annotations, MediaType mediaType, MultivaluedMap<String, Object> httpHeaders, OutputStream entityStream) throws IOException {
        LogMessages.LOGGER.debugf("Provider : %s,  Method : readFrom", this.getClass().getName());
        HttpHeaders headers = ResteasyProviderFactory.getContextData(HttpHeaders.class);
        if (headers == null) {
            this.writeIt(uploadFile, entityStream);
            return;
        }
        String range = (String)headers.getRequestHeaders().getFirst((Object)"Range");
        if (range == null) {
            this.writeIt(uploadFile, entityStream);
            return;
        }
        int byteUnit = (range = range.trim()).indexOf("bytes=");
        if (byteUnit < 0) {
            this.writeIt(uploadFile, entityStream);
            return;
        }
        if ((range = range.substring("bytes=".length())).indexOf(44) > -1) {
            this.writeIt(uploadFile, entityStream);
            return;
        }
        int separator = range.indexOf(45);
        if (separator < 0) {
            this.writeIt(uploadFile, entityStream);
            return;
        }
        if (separator == 0) {
            long begin;
            long fileSize = uploadFile.length();
            if (fileSize + (begin = Long.parseLong(range)) < 1L) {
                this.writeIt(uploadFile, entityStream);
                return;
            }
            throw new FileRangeException(mediaType, uploadFile, fileSize + begin, fileSize - 1L);
        }
        try {
            long end;
            long fileSize = uploadFile.length();
            long begin = Long.parseLong(range.substring(0, separator));
            if (begin >= fileSize) {
                throw new WebApplicationException(416);
            }
            if (range.endsWith("-")) {
                end = fileSize - 1L;
            } else {
                String substring = range.substring(separator + 1);
                end = Long.parseLong(substring);
            }
            throw new FileRangeException(mediaType, uploadFile, begin, end);
        }
        catch (NumberFormatException e) {
            this.writeIt(uploadFile, entityStream);
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void writeIt(File uploadFile, OutputStream entityStream) throws IOException {
        try (BufferedInputStream inputStream = new BufferedInputStream(new FileInputStream(uploadFile));){
            ProviderHelper.writeTo(inputStream, entityStream);
        }
    }
}

