/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.resteasy.plugins.providers;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.lang.annotation.Annotation;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.math.BigDecimal;
import java.security.AccessController;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.regex.Pattern;
import javax.ws.rs.Consumes;
import javax.ws.rs.Produces;
import javax.ws.rs.WebApplicationException;
import javax.ws.rs.core.MediaType;
import javax.ws.rs.core.MultivaluedMap;
import javax.ws.rs.core.StreamingOutput;
import javax.ws.rs.ext.Provider;
import org.jboss.resteasy.plugins.providers.AbstractEntityProvider;
import org.jboss.resteasy.plugins.providers.yaml.i18n.LogMessages;
import org.jboss.resteasy.plugins.providers.yaml.i18n.Messages;
import org.jboss.resteasy.spi.ReaderException;
import org.jboss.resteasy.spi.ResteasyConfiguration;
import org.jboss.resteasy.spi.ResteasyProviderFactory;
import org.jboss.resteasy.spi.WriterException;
import org.yaml.snakeyaml.Yaml;
import org.yaml.snakeyaml.constructor.BaseConstructor;
import org.yaml.snakeyaml.constructor.CustomClassLoaderConstructor;
import org.yaml.snakeyaml.nodes.Node;

@Provider
@Consumes(value={"text/yaml", "text/x-yaml", "application/x-yaml"})
@Produces(value={"text/yaml", "text/x-yaml", "application/x-yaml"})
@Deprecated
public class YamlProvider
extends AbstractEntityProvider<Object> {
    private static final String ALLOWED_LIST = "resteasy.yaml.deserialization.allowed.list.allowIfBaseType";
    private static final String DISABLE_TYPE_CHECK = "resteasy.yaml.deserialization.disable.type.check";
    private static final Collection<String> DEFAULT_ALLOWED_TYPES = Arrays.asList(YamlProvider.toPattern(BigDecimal.class), YamlProvider.toPattern(Boolean.class), YamlProvider.toPattern(Byte.class), YamlProvider.toPattern(Character.class), YamlProvider.toPattern(Double.class), YamlProvider.toPattern(Float.class), YamlProvider.toPattern(Integer.class), YamlProvider.toPattern(List.class), YamlProvider.toPattern(Long.class), YamlProvider.toPattern(Map.class), YamlProvider.toPattern(Set.class), YamlProvider.toPattern(Short.class), YamlProvider.toPattern(String.class));
    private final Pattern allowedPattern = YamlProvider.createAllowPattern();

    public boolean isReadable(Class<?> type, Type genericType, Annotation[] annotations, MediaType mediaType) {
        return true;
    }

    public Object readFrom(Class<Object> type, Type genericType, Annotation[] annotations, MediaType mediaType, MultivaluedMap<String, String> httpHeaders, InputStream entityStream) throws IOException, WebApplicationException {
        try {
            LogMessages.LOGGER.debugf("Provider : %s,  Method : readFrom", ((Object)((Object)this)).getClass().getName());
            if (this.isValidInternalType(type)) {
                if (YamlProvider.isTypeCheckDisabled()) {
                    return new Yaml().loadAs(entityStream, type);
                }
                TypeSafeConstructor constructor = genericType instanceof ParameterizedType ? new TypeSafeConstructor((ParameterizedType)genericType, YamlProvider.getClassLoader(type), this.allowedPattern) : new TypeSafeConstructor(type, YamlProvider.getClassLoader(type), this.allowedPattern);
                return new Yaml((BaseConstructor)constructor).loadAs(entityStream, type);
            }
            CustomClassLoaderConstructor customClassLoaderConstructor = new CustomClassLoaderConstructor(type, YamlProvider.getClassLoader(type));
            return new Yaml((BaseConstructor)customClassLoaderConstructor).loadAs(entityStream, type);
        }
        catch (Exception e) {
            LogMessages.LOGGER.debug(Messages.MESSAGES.failedToDecodeYamlMessage(e.getMessage()));
            throw new ReaderException(Messages.MESSAGES.failedToDecodeYaml(), (Throwable)e);
        }
    }

    protected boolean isValidInternalType(Class type) {
        return List.class.isAssignableFrom(type) || Set.class.isAssignableFrom(type) || Map.class.isAssignableFrom(type) || type.isArray();
    }

    protected boolean isValidType(Class type) {
        if (this.isValidInternalType(type)) {
            return true;
        }
        if (StreamingOutput.class.isAssignableFrom(type)) {
            return false;
        }
        String className = type.getName();
        if (className.startsWith("java.")) {
            return false;
        }
        if (className.startsWith("javax.")) {
            return false;
        }
        return !type.isPrimitive();
    }

    public boolean isWriteable(Class<?> type, Type genericType, Annotation[] annotations, MediaType mediaType) {
        return this.isValidType(type);
    }

    public void writeTo(Object t, Class<?> type, Type genericType, Annotation[] annotations, MediaType mediaType, MultivaluedMap<String, Object> httpHeaders, OutputStream entityStream) throws IOException, WebApplicationException {
        try {
            LogMessages.LOGGER.debugf("Provider : %s,  Method : writeTo", ((Object)((Object)this)).getClass().getName());
            entityStream.write(new Yaml().dump(t).getBytes());
        }
        catch (Exception e) {
            LogMessages.LOGGER.debug(Messages.MESSAGES.failedToEncodeYaml(t.toString()));
            throw new WriterException((Throwable)e);
        }
    }

    private static ClassLoader getClassLoader(Class<?> type) {
        if (System.getSecurityManager() == null) {
            ClassLoader result = Thread.currentThread().getContextClassLoader();
            if (result == null) {
                result = type.getClassLoader();
            }
            return result;
        }
        return AccessController.doPrivileged(() -> {
            ClassLoader result = Thread.currentThread().getContextClassLoader();
            if (result == null) {
                result = type.getClassLoader();
            }
            return result;
        });
    }

    private static Pattern createAllowPattern() {
        String value = YamlProvider.getProperty(ALLOWED_LIST);
        ArrayList<String> allowed = new ArrayList<String>(DEFAULT_ALLOWED_TYPES);
        if (value != null) {
            Collections.addAll(allowed, value.split(","));
        }
        return Pattern.compile(String.join((CharSequence)"|", allowed));
    }

    private static boolean isTypeCheckDisabled() {
        String value = YamlProvider.getProperty(DISABLE_TYPE_CHECK);
        return value != null && (value.isEmpty() || value.equalsIgnoreCase("true"));
    }

    private static String getProperty(String key) {
        ResteasyConfiguration configuration = (ResteasyConfiguration)ResteasyProviderFactory.getContextData(ResteasyConfiguration.class);
        if (System.getSecurityManager() == null) {
            String value = null;
            if (configuration != null && (value = configuration.getParameter(key)) == null) {
                value = configuration.getInitParameter(key);
            }
            if (value == null) {
                System.getProperty(key);
            }
            return value;
        }
        return AccessController.doPrivileged(() -> {
            String value = null;
            if (configuration != null && (value = configuration.getParameter(key)) == null) {
                value = configuration.getInitParameter(key);
            }
            if (value == null) {
                System.getProperty(key);
            }
            return value;
        });
    }

    private static String toPattern(Class<?> type) {
        return Pattern.quote(type.getName());
    }

    private static class TypeSafeConstructor
    extends CustomClassLoaderConstructor {
        private final Set<Class<?>> types;
        private final Pattern allowedPattern;

        private TypeSafeConstructor(ParameterizedType parameterizedType, ClassLoader classLoader, Pattern allowedPattern) {
            super(classLoader);
            this.allowedPattern = allowedPattern;
            HashSet genericTypes = new HashSet();
            for (Type typeArg : parameterizedType.getActualTypeArguments()) {
                try {
                    genericTypes.add(classLoader.loadClass(typeArg.getTypeName()));
                }
                catch (ClassNotFoundException e) {
                    LogMessages.LOGGER.failedToLoadType(typeArg.getTypeName());
                }
            }
            this.types = genericTypes;
        }

        private TypeSafeConstructor(Class<?> type, ClassLoader classLoader, Pattern allowedPattern) {
            super(classLoader);
            this.types = Collections.singleton(type);
            this.allowedPattern = allowedPattern;
        }

        protected Object newInstance(Class<?> ancestor, Node node, boolean tryDefault) {
            if (this.denied(node.getType())) {
                throw Messages.MESSAGES.typeNotAllowed(node.getType());
            }
            return super.newInstance(ancestor, node, tryDefault);
        }

        private boolean denied(Class<?> type) {
            String name;
            if (type == null) {
                return false;
            }
            if (type.isPrimitive()) {
                return false;
            }
            boolean denied = true;
            for (Class<?> allowed : this.types) {
                if (!allowed.isAssignableFrom(type)) continue;
                denied = false;
                break;
            }
            if (denied && this.allowedPattern.matcher(name = type.getName()).matches()) {
                return false;
            }
            return denied;
        }
    }
}

