/*
 * Decompiled with CFR 0.152.
 */
package javax.ws.rs.ext;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;
import java.util.Iterator;
import java.util.Properties;
import java.util.ServiceConfigurationError;
import java.util.ServiceLoader;
import java.util.logging.Level;
import java.util.logging.Logger;

final class FactoryFinder {
    private static final Logger LOGGER = Logger.getLogger(FactoryFinder.class.getName());
    private static final String RESTEASY_JAXRS_API_MODULE = "org.jboss.resteasy.resteasy-jaxrs-api";

    private FactoryFinder() {
    }

    static ClassLoader getContextClassLoader() {
        return AccessController.doPrivileged(new PrivilegedAction<ClassLoader>(){

            @Override
            public ClassLoader run() {
                ClassLoader cl = null;
                try {
                    cl = Thread.currentThread().getContextClassLoader();
                }
                catch (SecurityException ex) {
                    LOGGER.log(Level.WARNING, "Unable to get context classloader instance.", ex);
                }
                return cl;
            }
        });
    }

    private static Object newInstance(String className, ClassLoader classLoader) throws ClassNotFoundException {
        try {
            Class<?> spiClass;
            if (classLoader == null) {
                spiClass = Class.forName(className);
            } else {
                try {
                    spiClass = Class.forName(className, false, classLoader);
                }
                catch (ClassNotFoundException ex) {
                    LOGGER.log(Level.FINE, "Unable to load provider class " + className + " using custom classloader " + classLoader.getClass().getName() + " trying again with current classloader.", ex);
                    spiClass = Class.forName(className);
                }
            }
            return spiClass.newInstance();
        }
        catch (ClassNotFoundException x) {
            throw x;
        }
        catch (Exception x) {
            throw new ClassNotFoundException("Provider " + className + " could not be instantiated: " + x, x);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    static <T> Object find(String factoryId, String fallbackClassName, Class<T> service) throws ClassNotFoundException {
        ClassLoader classLoader;
        block45: {
            Iterator<T> iterator;
            classLoader = FactoryFinder.getContextClassLoader();
            try {
                iterator = ServiceLoader.load(service, FactoryFinder.getContextClassLoader()).iterator();
                if (iterator.hasNext()) {
                    return iterator.next();
                }
            }
            catch (Exception | ServiceConfigurationError ex) {
                LOGGER.log(Level.FINER, "Failed to load service " + factoryId + ".", ex);
            }
            try {
                iterator = ServiceLoader.load(service, FactoryFinder.class.getClassLoader()).iterator();
                if (iterator.hasNext()) {
                    return iterator.next();
                }
            }
            catch (Exception | ServiceConfigurationError ex) {
                LOGGER.log(Level.FINER, "Failed to load service " + factoryId + ".", ex);
            }
            try {
                String javah = System.getProperty("java.home");
                String configFile = javah + File.separator + "lib" + File.separator + "jaxrs.properties";
                File f = new File(configFile);
                if (f.exists()) {
                    Properties props = new Properties();
                    props.load(new FileInputStream(f));
                    String factoryClassName = props.getProperty(factoryId);
                    return FactoryFinder.newInstance(factoryClassName, classLoader);
                }
            }
            catch (Exception ex) {
                LOGGER.log(Level.FINER, "Failed to load service " + factoryId + " from $java.home/lib/jaxrs.properties", ex);
            }
            try {
                String systemProp = System.getProperty(factoryId);
                if (systemProp != null) {
                    return FactoryFinder.newInstance(systemProp, classLoader);
                }
            }
            catch (SecurityException se) {
                LOGGER.log(Level.FINER, "Failed to load service " + factoryId + " from a system property", se);
            }
            ClassLoader moduleClassLoader = FactoryFinder.getModuleClassLoader();
            if (moduleClassLoader != null) {
                String serviceId = "META-INF/services/" + factoryId;
                try (InputStream is = moduleClassLoader.getResourceAsStream(serviceId);){
                    if (is == null) break block45;
                    try (BufferedReader rd = new BufferedReader(new InputStreamReader(is, "UTF-8"));){
                        String factoryClassName = rd.readLine();
                        if (factoryClassName != null && !"".equals(factoryClassName)) {
                            Object object = FactoryFinder.newInstance(factoryClassName, moduleClassLoader);
                            return object;
                        }
                    }
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        }
        if (fallbackClassName != null) return FactoryFinder.newInstance(fallbackClassName, classLoader);
        throw new ClassNotFoundException("Provider for " + factoryId + " cannot be found", null);
    }

    private static ClassLoader getModuleClassLoader() {
        try {
            Object moduleLoader;
            final Class<?> moduleClass = Class.forName("org.jboss.modules.Module");
            Class<?> moduleIdentifierClass = Class.forName("org.jboss.modules.ModuleIdentifier");
            Class<?> moduleLoaderClass = Class.forName("org.jboss.modules.ModuleLoader");
            SecurityManager sm = System.getSecurityManager();
            if (sm == null) {
                moduleLoader = moduleClass.getMethod("getBootModuleLoader", new Class[0]).invoke(null, new Object[0]);
            } else {
                try {
                    moduleLoader = AccessController.doPrivileged(new PrivilegedExceptionAction<Object>(){

                        @Override
                        public Object run() throws Exception {
                            return moduleClass.getMethod("getBootModuleLoader", new Class[0]).invoke(null, new Object[0]);
                        }
                    });
                }
                catch (PrivilegedActionException pae) {
                    throw pae.getException();
                }
            }
            Object moduleIdentifier = moduleIdentifierClass.getMethod("create", String.class).invoke(null, RESTEASY_JAXRS_API_MODULE);
            Object module = moduleLoaderClass.getMethod("loadModule", moduleIdentifierClass).invoke(moduleLoader, moduleIdentifier);
            return (ClassLoader)moduleClass.getMethod("getClassLoader", new Class[0]).invoke(module, new Object[0]);
        }
        catch (ClassNotFoundException e) {
            return null;
        }
        catch (RuntimeException e) {
            throw e;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }
}

