/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.resteasy.spi;

import java.io.UnsupportedEncodingException;
import java.net.URI;
import java.net.URLDecoder;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import javax.ws.rs.core.MultivaluedMap;
import javax.ws.rs.core.PathSegment;
import javax.ws.rs.core.UriBuilder;
import javax.ws.rs.core.UriInfo;
import javax.ws.rs.ext.RuntimeDelegate;
import org.jboss.resteasy.specimpl.MultivaluedMapImpl;
import org.jboss.resteasy.specimpl.PathSegmentImpl;
import org.jboss.resteasy.specimpl.ResteasyUriBuilder;
import org.jboss.resteasy.specimpl.UnmodifiableMultivaluedMap;
import org.jboss.resteasy.util.Encode;
import org.jboss.resteasy.util.PathHelper;

public class ResteasyUriInfo
implements UriInfo {
    private String path;
    private String encodedPath;
    private String matchingPath;
    private MultivaluedMap<String, String> queryParameters = new MultivaluedMapImpl<String, String>();
    private MultivaluedMap<String, String> encodedQueryParameters = new MultivaluedMapImpl<String, String>();
    private MultivaluedMap<String, String> pathParameters;
    private MultivaluedMap<String, String> encodedPathParameters;
    private MultivaluedMap<String, PathSegment[]> pathParameterPathSegments;
    private MultivaluedMap<String, PathSegment[]> encodedPathParameterPathSegments;
    private List<PathSegment> pathSegments;
    private List<PathSegment> encodedPathSegments;
    private URI absolutePath;
    private URI requestURI;
    private URI baseURI;
    private List<String> matchedUris;
    private List<String> encodedMatchedUris;
    private List<String> encodedMatchedPaths = new LinkedList<String>();
    private List<Object> ancestors;
    private String queryString;
    private String contextPath;

    public ResteasyUriInfo(CharSequence absoluteUri, String queryString, String contextPath) {
        this.initialize(absoluteUri, queryString, contextPath);
    }

    protected void initialize(CharSequence absoluteUri, String queryString, String contextPath) {
        ResteasyUriBuilder absoluteBuilder = (ResteasyUriBuilder)((ResteasyUriBuilder)RuntimeDelegate.getInstance().createUriBuilder()).uriFromCharSequence(absoluteUri);
        this.absolutePath = absoluteBuilder.build(new Object[0]);
        this.requestURI = absoluteBuilder.replaceQuery(queryString).build(new Object[0]);
        this.encodedPath = PathHelper.getEncodedPathInfo(this.absolutePath.getRawPath(), contextPath);
        this.baseURI = this.absolutePath;
        if (!this.encodedPath.trim().equals("")) {
            String tmpContextPath = contextPath;
            if (!tmpContextPath.endsWith("/")) {
                tmpContextPath = tmpContextPath + "/";
            }
            this.baseURI = absoluteBuilder.clone().replacePath(tmpContextPath).replaceQuery(null).build(new Object[0]);
        }
        if (this.encodedPath.length() == 0 || this.encodedPath.charAt(0) != '/') {
            this.encodedPath = "/" + this.encodedPath;
        }
        this.path = UriBuilder.fromPath((String)this.encodedPath).build(new Object[0]).getPath();
        this.processPath();
    }

    public ResteasyUriInfo(URI base, URI relative) {
        String r;
        String b = base.toString();
        if (!b.endsWith("/")) {
            b = b + "/";
        }
        if ((r = relative.getRawPath()).startsWith("/")) {
            this.encodedPath = r;
            this.path = relative.getPath();
        } else {
            this.encodedPath = "/" + r;
            this.path = "/" + relative.getPath();
        }
        UriBuilder requestUriBuilder = UriBuilder.fromUri((URI)base).path(relative.getRawPath()).replaceQuery(relative.getRawQuery());
        this.requestURI = requestUriBuilder.build(new Object[0]);
        this.absolutePath = requestUriBuilder.replaceQuery(null).build(new Object[0]);
        this.baseURI = base;
        this.processPath();
    }

    public void setUri(URI base, URI relative) {
        this.clearQueryParameters(true);
        this.clearQueryParameters(false);
        URI rel = base.resolve(relative);
        String absoluteUri = UriBuilder.fromUri((URI)rel).replaceQuery(null).toTemplate();
        this.initialize(absoluteUri, rel.getRawQuery(), base.getRawPath());
    }

    protected void processPath() {
        PathSegmentImpl.SegmentParse parse = PathSegmentImpl.parseSegmentsOptimization(this.encodedPath, false);
        this.encodedPathSegments = parse.segments;
        this.pathSegments = new ArrayList<PathSegment>(this.encodedPathSegments.size());
        for (PathSegment segment : this.encodedPathSegments) {
            this.pathSegments.add(new PathSegmentImpl(((PathSegmentImpl)segment).getOriginal(), true));
        }
        this.extractParameters(this.requestURI.getRawQuery());
        if (parse.hasMatrixParams) {
            this.extractMatchingPath(this.encodedPathSegments);
        } else {
            this.matchingPath = this.encodedPath;
            if (this.matchingPath.length() > 1 && this.matchingPath.endsWith("/")) {
                this.matchingPath = this.matchingPath.substring(0, this.matchingPath.length() - 1);
            }
        }
    }

    public ResteasyUriInfo(URI requestURI) {
        this.initializeFromRequest(requestURI);
    }

    public void initializeFromRequest(URI requestURI) {
        String r = requestURI.getRawPath();
        if (r.startsWith("/")) {
            this.encodedPath = r;
            this.path = requestURI.getPath();
        } else {
            this.encodedPath = "/" + r;
            this.path = "/" + requestURI.getPath();
        }
        this.requestURI = requestURI;
        this.baseURI = UriBuilder.fromUri((URI)requestURI).replacePath("").build(new Object[0]);
        this.absolutePath = UriBuilder.fromUri((URI)requestURI).replaceQuery(null).build(new Object[0]);
        this.processPath();
    }

    protected void extractMatchingPath(List<PathSegment> encodedPathSegments) {
        StringBuilder preprocessedPath = new StringBuilder();
        for (PathSegment pathSegment : encodedPathSegments) {
            preprocessedPath.append("/").append(pathSegment.getPath());
        }
        this.matchingPath = preprocessedPath.toString();
    }

    public String getMatchingPath() {
        return this.matchingPath;
    }

    public void setRequestUri(URI relative) {
        this.setUri(this.baseURI, relative);
    }

    public String getPath() {
        return this.path;
    }

    public String getPath(boolean decode) {
        if (decode) {
            return this.getPath();
        }
        return this.encodedPath;
    }

    public List<PathSegment> getPathSegments() {
        return this.pathSegments;
    }

    public List<PathSegment> getPathSegments(boolean decode) {
        if (decode) {
            return this.getPathSegments();
        }
        return this.encodedPathSegments;
    }

    public URI getRequestUri() {
        return this.requestURI;
    }

    public UriBuilder getRequestUriBuilder() {
        return UriBuilder.fromUri((URI)this.requestURI);
    }

    public URI getAbsolutePath() {
        return this.absolutePath;
    }

    public UriBuilder getAbsolutePathBuilder() {
        return UriBuilder.fromUri((URI)this.absolutePath);
    }

    public URI getBaseUri() {
        return this.baseURI;
    }

    public UriBuilder getBaseUriBuilder() {
        return UriBuilder.fromUri((URI)this.baseURI);
    }

    public MultivaluedMap<String, String> getPathParameters() {
        if (this.pathParameters == null) {
            this.pathParameters = new MultivaluedMapImpl<String, String>();
        }
        return this.pathParameters;
    }

    public void addEncodedPathParameter(String name, String value) {
        this.getEncodedPathParameters().add((Object)name, (Object)value);
        String value1 = Encode.decodePath(value);
        this.getPathParameters().add((Object)name, (Object)value1);
    }

    private MultivaluedMap<String, String> getEncodedPathParameters() {
        if (this.encodedPathParameters == null) {
            this.encodedPathParameters = new MultivaluedMapImpl<String, String>();
        }
        return this.encodedPathParameters;
    }

    public MultivaluedMap<String, PathSegment[]> getEncodedPathParameterPathSegments() {
        if (this.encodedPathParameterPathSegments == null) {
            this.encodedPathParameterPathSegments = new MultivaluedMapImpl<String, PathSegment[]>();
        }
        return this.encodedPathParameterPathSegments;
    }

    public MultivaluedMap<String, PathSegment[]> getPathParameterPathSegments() {
        if (this.pathParameterPathSegments == null) {
            this.pathParameterPathSegments = new MultivaluedMapImpl<String, PathSegment[]>();
        }
        return this.pathParameterPathSegments;
    }

    public MultivaluedMap<String, String> getPathParameters(boolean decode) {
        if (decode) {
            return this.getPathParameters();
        }
        return this.getEncodedPathParameters();
    }

    public MultivaluedMap<String, String> getQueryParameters() {
        return new UnmodifiableMultivaluedMap<String, String>(this.queryParameters);
    }

    protected MultivaluedMap<String, String> getEncodedQueryParameters() {
        return new UnmodifiableMultivaluedMap<String, String>(this.encodedQueryParameters);
    }

    public MultivaluedMap<String, String> getQueryParameters(boolean decode) {
        if (decode) {
            return this.getQueryParameters();
        }
        return this.getEncodedQueryParameters();
    }

    public void clearQueryParameters(boolean decode) {
        if (decode) {
            this.clearQueryParameters();
        } else {
            this.clearEncodedQueryParameters();
        }
    }

    private void clearQueryParameters() {
        if (this.queryParameters != null) {
            this.queryParameters.clear();
        }
    }

    private void clearEncodedQueryParameters() {
        if (this.encodedQueryParameters != null) {
            this.encodedQueryParameters.clear();
        }
    }

    protected void extractParameters(String queryString) {
        String[] params;
        if (queryString == null || queryString.equals("")) {
            return;
        }
        for (String param : params = queryString.split("&")) {
            if (param.indexOf(61) >= 0) {
                String[] nv = param.split("=", 2);
                try {
                    String name = URLDecoder.decode(nv[0], StandardCharsets.UTF_8.name());
                    String val = nv.length > 1 ? nv[1] : "";
                    this.encodedQueryParameters.add((Object)name, (Object)val);
                    this.queryParameters.add((Object)name, (Object)URLDecoder.decode(val, StandardCharsets.UTF_8.name()));
                    continue;
                }
                catch (UnsupportedEncodingException e) {
                    throw new RuntimeException(e);
                }
            }
            try {
                String name = URLDecoder.decode(param, StandardCharsets.UTF_8.name());
                this.encodedQueryParameters.add((Object)name, (Object)"");
                this.queryParameters.add((Object)name, (Object)"");
            }
            catch (UnsupportedEncodingException e) {
                throw new RuntimeException(e);
            }
        }
    }

    public List<String> getMatchedURIs(boolean decode) {
        if (decode) {
            if (this.matchedUris == null) {
                this.matchedUris = new LinkedList<String>();
            }
            return this.matchedUris;
        }
        if (this.encodedMatchedUris == null) {
            this.encodedMatchedUris = new LinkedList<String>();
        }
        return this.encodedMatchedUris;
    }

    public List<String> getMatchedURIs() {
        return this.getMatchedURIs(true);
    }

    public List<Object> getMatchedResources() {
        if (this.ancestors == null) {
            this.ancestors = new LinkedList<Object>();
        }
        return this.ancestors;
    }

    public void pushCurrentResource(Object resource) {
        if (this.ancestors == null) {
            this.ancestors = new LinkedList<Object>();
        }
        this.ancestors.add(0, resource);
    }

    public void pushMatchedPath(String encoded) {
        this.encodedMatchedPaths.add(0, encoded);
    }

    public List<String> getEncodedMatchedPaths() {
        return this.encodedMatchedPaths;
    }

    public void popMatchedPath() {
        this.encodedMatchedPaths.remove(0);
    }

    public void pushMatchedURI(String encoded) {
        int start = encoded.startsWith("/") ? 1 : 0;
        int end = encoded.endsWith("/") ? encoded.length() - 1 : encoded.length();
        encoded = start < end ? encoded.substring(start, end) : "";
        String decoded = Encode.decode(encoded);
        if (this.encodedMatchedUris == null) {
            this.encodedMatchedUris = new LinkedList<String>();
        }
        this.encodedMatchedUris.add(0, encoded);
        if (this.matchedUris == null) {
            this.matchedUris = new LinkedList<String>();
        }
        this.matchedUris.add(0, decoded);
    }

    public URI resolve(URI uri) {
        return this.getBaseUri().resolve(uri);
    }

    public URI relativize(URI uri) {
        URI from = this.getRequestUri();
        URI to = uri;
        if (uri.getScheme() == null && uri.getHost() == null) {
            to = this.getBaseUriBuilder().replaceQuery(null).path(uri.getPath()).replaceQuery(uri.getQuery()).fragment(uri.getFragment()).build(new Object[0]);
        }
        return ResteasyUriBuilder.relativize(from, to);
    }
}

