/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.resteasy.plugins.providers.jackson;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.github.fge.jsonpatch.JsonPatch;
import com.github.fge.jsonpatch.JsonPatchException;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import javax.annotation.Priority;
import javax.ws.rs.ProcessingException;
import javax.ws.rs.container.ContainerRequestContext;
import javax.ws.rs.container.ContainerRequestFilter;
import javax.ws.rs.core.MediaType;
import javax.ws.rs.core.MultivaluedMap;
import javax.ws.rs.ext.MessageBodyWriter;
import javax.ws.rs.ext.Provider;
import org.jboss.resteasy.core.ResourceInvoker;
import org.jboss.resteasy.core.ResourceMethodInvoker;
import org.jboss.resteasy.specimpl.MultivaluedTreeMap;
import org.jboss.resteasy.spi.HttpRequest;
import org.jboss.resteasy.spi.HttpResponse;
import org.jboss.resteasy.spi.Registry;
import org.jboss.resteasy.spi.ResteasyProviderFactory;

@Provider
@Priority(value=0x7FFFFFFF)
public class PatchMethodFilter
implements ContainerRequestFilter {
    public void filter(ContainerRequestContext requestContext) throws IOException {
        if (requestContext.getMethod().equals("PATCH") && MediaType.APPLICATION_JSON_PATCH_JSON_TYPE.equals((Object)requestContext.getMediaType())) {
            HttpRequest request = (HttpRequest)ResteasyProviderFactory.getContextData(HttpRequest.class);
            HttpResponse response = (HttpResponse)ResteasyProviderFactory.getContextData(HttpResponse.class);
            request.setHttpMethod("GET");
            Registry methodRegistry = (Registry)ResteasyProviderFactory.getContextData(Registry.class);
            ResourceInvoker resourceInovker = methodRegistry.getResourceInvoker(request);
            if (resourceInovker == null) {
                throw new ProcessingException("Get method not found and patch method failed");
            }
            ResourceMethodInvoker methodInvoker = (ResourceMethodInvoker)resourceInovker;
            Object object = methodInvoker.invokeDryRun(request, response);
            ByteArrayOutputStream tmpOutputStream = new ByteArrayOutputStream();
            MessageBodyWriter msgBodyWriter = ResteasyProviderFactory.getInstance().getMessageBodyWriter(object.getClass(), object.getClass(), methodInvoker.getMethodAnnotations(), MediaType.APPLICATION_JSON_TYPE);
            msgBodyWriter.writeTo(object, object.getClass(), object.getClass(), methodInvoker.getMethodAnnotations(), MediaType.APPLICATION_JSON_TYPE, (MultivaluedMap)new MultivaluedTreeMap(), (OutputStream)tmpOutputStream);
            ObjectMapper mapper = new ObjectMapper();
            JsonNode targetJson = (JsonNode)mapper.readValue(tmpOutputStream.toByteArray(), JsonNode.class);
            JsonPatch patch = JsonPatch.fromJson((JsonNode)((JsonNode)mapper.readValue(request.getInputStream(), JsonNode.class)));
            JsonNode result = null;
            try {
                result = patch.apply(targetJson);
            }
            catch (JsonPatchException e) {
                throw new ProcessingException((Throwable)e);
            }
            ByteArrayOutputStream targetOutputStream = new ByteArrayOutputStream();
            mapper.writeValue((OutputStream)targetOutputStream, (Object)result);
            request.setInputStream((InputStream)new ByteArrayInputStream(targetOutputStream.toByteArray()));
            request.setHttpMethod("PATCH");
        }
    }
}

