/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.resteasy.spi.metadata;

import java.lang.reflect.Method;
import java.lang.reflect.Type;
import org.jboss.resteasy.spi.metadata.MethodParameter;
import org.jboss.resteasy.spi.metadata.ResourceClass;
import org.jboss.resteasy.spi.metadata.ResourceLocator;
import org.jboss.resteasy.util.Types;

public class DefaultResourceLocator
implements ResourceLocator {
    protected ResourceClass resourceClass;
    protected Class<?> returnType;
    protected Type genericReturnType;
    protected Method method;
    protected Method annotatedMethod;
    protected MethodParameter[] params = new MethodParameter[0];
    protected String fullpath;
    protected String path;

    public DefaultResourceLocator(ResourceClass resourceClass, Method method, Method annotatedMethod) {
        this.resourceClass = resourceClass;
        this.annotatedMethod = annotatedMethod;
        this.method = method;
        this.genericReturnType = Types.resolveTypeVariables(resourceClass.getClazz(), method.getGenericReturnType());
        this.returnType = Types.getRawType(this.genericReturnType);
        this.params = new MethodParameter[method.getParameterTypes().length];
        for (int i = 0; i < method.getParameterTypes().length; ++i) {
            this.params[i] = new MethodParameter(this, method.getParameterTypes()[i], method.getGenericParameterTypes()[i], annotatedMethod.getParameterAnnotations()[i]);
        }
    }

    @Override
    public ResourceClass getResourceClass() {
        return this.resourceClass;
    }

    @Override
    public Class<?> getReturnType() {
        return this.returnType;
    }

    @Override
    public Type getGenericReturnType() {
        return this.genericReturnType;
    }

    @Override
    public Method getMethod() {
        return this.method;
    }

    @Override
    public Method getAnnotatedMethod() {
        return this.annotatedMethod;
    }

    @Override
    public MethodParameter[] getParams() {
        return this.params;
    }

    @Override
    public String getFullpath() {
        return this.fullpath;
    }

    @Override
    public String getPath() {
        return this.path;
    }

    public String toString() {
        return this.method.toString();
    }
}

