/*
 * Decompiled with CFR 0.152.
 */
package com.github.fge.jsonpatch;

import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonSubTypes;
import com.fasterxml.jackson.annotation.JsonTypeInfo;
import com.fasterxml.jackson.databind.JsonNode;
import com.github.fge.jackson.jsonpointer.JsonPointer;
import com.github.fge.jackson.jsonpointer.TokenResolver;
import com.github.fge.jsonpatch.AddOperation;
import com.github.fge.jsonpatch.CopyOperation;
import com.github.fge.jsonpatch.JsonPatchException;
import com.github.fge.jsonpatch.MoveOperation;
import com.github.fge.jsonpatch.RemoveOperation;
import com.github.fge.jsonpatch.ReplaceOperation;
import com.github.fge.jsonpatch.TestOperation;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.List;

@JsonTypeInfo(use=JsonTypeInfo.Id.NAME, include=JsonTypeInfo.As.PROPERTY, property="op")
@JsonSubTypes(value={@JsonSubTypes.Type(name="add", value=AddOperation.class), @JsonSubTypes.Type(name="copy", value=CopyOperation.class), @JsonSubTypes.Type(name="move", value=MoveOperation.class), @JsonSubTypes.Type(name="remove", value=RemoveOperation.class), @JsonSubTypes.Type(name="replace", value=ReplaceOperation.class), @JsonSubTypes.Type(name="test", value=TestOperation.class)})
@JsonIgnoreProperties(ignoreUnknown=true)
public abstract class JsonPatchOperation {
    protected final JsonPointer path;

    protected JsonPatchOperation(JsonPointer path) {
        this.path = path;
    }

    public abstract JsonNode apply(JsonNode var1) throws JsonPatchException;

    public String toString() {
        return "path = \"" + this.path + '\"';
    }

    protected static final class SplitPointer {
        final JsonPointer parent;
        final TokenResolver<JsonNode> lastToken;

        SplitPointer(JsonPointer pointer) {
            ArrayList tokens = Lists.newArrayList((Iterable)pointer);
            this.lastToken = (TokenResolver)tokens.remove(tokens.size() - 1);
            this.parent = new JsonPointer((List)tokens);
        }
    }
}

