/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.resteasy.plugins.providers.jaxb.json;

import java.lang.annotation.Annotation;
import java.util.concurrent.ConcurrentHashMap;
import javax.ws.rs.Produces;
import javax.ws.rs.core.MediaType;
import javax.ws.rs.ext.ContextResolver;
import javax.ws.rs.ext.Provider;
import javax.xml.bind.JAXBContext;
import javax.xml.bind.JAXBException;
import org.jboss.resteasy.annotations.providers.jaxb.json.BadgerFish;
import org.jboss.resteasy.annotations.providers.jaxb.json.Mapped;
import org.jboss.resteasy.plugins.providers.jaxb.AbstractJAXBContextFinder;
import org.jboss.resteasy.plugins.providers.jaxb.JAXBContextFinder;
import org.jboss.resteasy.plugins.providers.jaxb.json.BadgerContext;
import org.jboss.resteasy.plugins.providers.jaxb.json.JettisonMappedContext;
import org.jboss.resteasy.spi.util.FindAnnotation;

@Provider
@Produces(value={"application/json", "application/*+json"})
public class JsonJAXBContextFinder
extends AbstractJAXBContextFinder
implements ContextResolver<JAXBContextFinder> {
    private ConcurrentHashMap<Class<?>, JAXBContext> mappedCache = new ConcurrentHashMap();
    private ConcurrentHashMap<Class<?>, JAXBContext> badgerCache = new ConcurrentHashMap();
    private ConcurrentHashMap<AbstractJAXBContextFinder.CacheKey, JAXBContext> mappedCollectionCache = new ConcurrentHashMap();
    private ConcurrentHashMap<AbstractJAXBContextFinder.CacheKey, JAXBContext> mappedXmlTypeCollectionCache = new ConcurrentHashMap();
    private ConcurrentHashMap<AbstractJAXBContextFinder.CacheKey, JAXBContext> badgerCollectionCache = new ConcurrentHashMap();
    private ConcurrentHashMap<AbstractJAXBContextFinder.CacheKey, JAXBContext> badgerXmlTypeCollectionCache = new ConcurrentHashMap();

    protected JAXBContext createContextObject(Annotation[] annotations, Class ... classes) throws JAXBException {
        Mapped mapped = (Mapped)FindAnnotation.findAnnotation((Annotation[])annotations, Mapped.class);
        BadgerFish badger = (BadgerFish)FindAnnotation.findAnnotation((Annotation[])annotations, BadgerFish.class);
        if (badger != null) {
            return new BadgerContext(classes);
        }
        return new JettisonMappedContext(mapped, classes);
    }

    protected JAXBContext createContextObject(Annotation[] annotations, String contextPath) throws JAXBException {
        Mapped mapped = (Mapped)FindAnnotation.findAnnotation((Annotation[])annotations, Mapped.class);
        BadgerFish badger = (BadgerFish)FindAnnotation.findAnnotation((Annotation[])annotations, BadgerFish.class);
        if (badger != null) {
            return new BadgerContext(contextPath);
        }
        return new JettisonMappedContext(mapped, contextPath);
    }

    public JAXBContext findCacheXmlTypeContext(MediaType mediaType, Annotation[] annotations, Class ... classes) throws JAXBException {
        AbstractJAXBContextFinder.CacheKey key = new AbstractJAXBContextFinder.CacheKey(classes);
        Mapped mapped = (Mapped)FindAnnotation.findAnnotation((Annotation[])annotations, Mapped.class);
        BadgerFish badger = (BadgerFish)FindAnnotation.findAnnotation((Annotation[])annotations, BadgerFish.class);
        if (badger != null) {
            JAXBContext ctx = this.badgerXmlTypeCollectionCache.get(key);
            if (ctx != null) {
                return ctx;
            }
            ctx = this.createXmlTypeContext(annotations, classes);
            this.badgerXmlTypeCollectionCache.put(key, ctx);
            return ctx;
        }
        JAXBContext ctx = this.mappedXmlTypeCollectionCache.get(key);
        if (ctx != null) {
            return ctx;
        }
        ctx = this.createXmlTypeContext(annotations, classes);
        this.mappedXmlTypeCollectionCache.put(key, ctx);
        return ctx;
    }

    public JAXBContext findCachedContext(Class type, MediaType mediaType, Annotation[] annotations) throws JAXBException {
        Mapped mapped = (Mapped)FindAnnotation.findAnnotation((Class)type, (Annotation[])annotations, Mapped.class);
        BadgerFish badger = (BadgerFish)FindAnnotation.findAnnotation((Class)type, (Annotation[])annotations, BadgerFish.class);
        if (badger != null) {
            return this.find(type, mediaType, this.badgerCache, mapped, badger);
        }
        return this.find(type, mediaType, this.mappedCache, mapped, badger);
    }

    public JAXBContext findCacheContext(MediaType mediaType, Annotation[] annotations, Class ... classes) throws JAXBException {
        AbstractJAXBContextFinder.CacheKey key = new AbstractJAXBContextFinder.CacheKey(classes);
        Mapped mapped = (Mapped)FindAnnotation.findAnnotation((Annotation[])annotations, Mapped.class);
        BadgerFish badger = (BadgerFish)FindAnnotation.findAnnotation((Annotation[])annotations, BadgerFish.class);
        if (badger != null) {
            JAXBContext ctx = this.badgerCollectionCache.get(key);
            if (ctx != null) {
                return ctx;
            }
            ctx = new BadgerContext(classes);
            this.badgerCollectionCache.put(key, ctx);
            return ctx;
        }
        JAXBContext ctx = this.mappedCollectionCache.get(key);
        if (ctx != null) {
            return ctx;
        }
        ctx = new JettisonMappedContext(mapped, classes);
        this.mappedCollectionCache.put(key, ctx);
        return ctx;
    }

    protected JAXBContext find(Class<?> type, MediaType mediaType, ConcurrentHashMap<Class<?>, JAXBContext> cache, Mapped mapped, BadgerFish badger) throws JAXBException {
        JAXBContext jaxb = cache.get(type);
        if (jaxb != null) {
            return jaxb;
        }
        jaxb = this.findProvidedJAXBContext(type, mediaType);
        if (jaxb == null) {
            jaxb = badger != null ? new BadgerContext(type) : (mapped != null ? new JettisonMappedContext(mapped, type) : new JettisonMappedContext(type));
        }
        cache.putIfAbsent(type, jaxb);
        return jaxb;
    }
}

