/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.resteasy.core;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.concurrent.CompletionStage;
import java.util.concurrent.ConcurrentHashMap;
import javax.ws.rs.NotFoundException;
import org.jboss.resteasy.core.LocatorRegistry;
import org.jboss.resteasy.core.ResourceMethodInvoker;
import org.jboss.resteasy.core.SynchronousDispatcher;
import org.jboss.resteasy.resteasy_jaxrs.i18n.Messages;
import org.jboss.resteasy.specimpl.BuiltResponse;
import org.jboss.resteasy.specimpl.ResteasyUriInfo;
import org.jboss.resteasy.spi.ApplicationException;
import org.jboss.resteasy.spi.HttpRequest;
import org.jboss.resteasy.spi.HttpResponse;
import org.jboss.resteasy.spi.InjectorFactory;
import org.jboss.resteasy.spi.InternalServerErrorException;
import org.jboss.resteasy.spi.MethodInjector;
import org.jboss.resteasy.spi.ResourceFactory;
import org.jboss.resteasy.spi.ResourceInvoker;
import org.jboss.resteasy.spi.ResteasyProviderFactory;
import org.jboss.resteasy.spi.metadata.ResourceLocator;
import org.jboss.resteasy.util.GetRestful;

public class ResourceLocatorInvoker
implements ResourceInvoker {
    protected InjectorFactory injector;
    protected MethodInjector methodInjector;
    protected ResourceFactory resource;
    protected ResteasyProviderFactory providerFactory;
    protected ResourceLocator method;
    protected ConcurrentHashMap<Class<?>, LocatorRegistry> cachedSubresources = new ConcurrentHashMap();

    public ResourceLocatorInvoker(ResourceFactory resource, InjectorFactory injector, ResteasyProviderFactory providerFactory, ResourceLocator locator) {
        this.resource = resource;
        this.injector = injector;
        this.providerFactory = providerFactory;
        this.method = locator;
        this.methodInjector = injector.createMethodInjector(locator, providerFactory);
    }

    protected CompletionStage<Object> createResource(HttpRequest request, HttpResponse response) {
        return this.resource.createResource(request, response, this.providerFactory).thenCompose(resource -> this.createResource(request, response, resource));
    }

    protected CompletionStage<Object> createResource(HttpRequest request, HttpResponse response, Object locator) {
        ResteasyUriInfo uriInfo = (ResteasyUriInfo)request.getUri();
        RuntimeException lastException = (RuntimeException)request.getAttribute("registry.matching.exception");
        return this.methodInjector.injectArguments(request, response).exceptionally(t -> {
            if (t.getCause() instanceof NotFoundException && lastException != null) {
                throw lastException;
            }
            SynchronousDispatcher.rethrow(t);
            return null;
        }).thenApply(args -> {
            try {
                uriInfo.pushCurrentResource(locator);
                Object subResource = this.method.getMethod().invoke(locator, args);
                if (subResource instanceof Class) {
                    subResource = this.providerFactory.injectedInstance((Class)subResource);
                }
                return subResource;
            }
            catch (IllegalAccessException e) {
                throw new InternalServerErrorException((Throwable)e);
            }
            catch (InvocationTargetException e) {
                throw new ApplicationException(e.getCause());
            }
            catch (SecurityException e) {
                throw new ApplicationException(e.getCause());
            }
        });
    }

    public Method getMethod() {
        return this.method.getMethod();
    }

    public CompletionStage<BuiltResponse> invoke(HttpRequest request, HttpResponse response) {
        return this.createResource(request, response).thenCompose(target -> this.invokeOnTargetObject(request, response, target));
    }

    public CompletionStage<BuiltResponse> invoke(HttpRequest request, HttpResponse response, Object locator) {
        return this.createResource(request, response, locator).thenCompose(target -> this.invokeOnTargetObject(request, response, target));
    }

    protected CompletionStage<BuiltResponse> invokeOnTargetObject(HttpRequest request, HttpResponse response, Object target) {
        ResourceInvoker invoker;
        if (target == null) {
            NotFoundException notFound = new NotFoundException(Messages.MESSAGES.nullSubresource(request.getUri().getAbsolutePath()));
            throw notFound;
        }
        Class<?> clazz = target.getClass();
        LocatorRegistry registry = this.cachedSubresources.get(clazz);
        if (registry == null) {
            if (!GetRestful.isSubResourceClass(clazz)) {
                String msg = Messages.MESSAGES.subresourceHasNoJaxRsAnnotations(clazz.getName());
                throw new InternalServerErrorException(msg);
            }
            registry = new LocatorRegistry(clazz, this.providerFactory);
            this.cachedSubresources.putIfAbsent(clazz, registry);
        }
        if ((invoker = registry.getResourceInvoker(request)) instanceof ResourceLocatorInvoker) {
            ResourceLocatorInvoker locator = (ResourceLocatorInvoker)invoker;
            return locator.invoke(request, response, target);
        }
        ResourceMethodInvoker method = (ResourceMethodInvoker)invoker;
        return method.invoke(request, response, target);
    }
}

