/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.resteasy.core;

import java.io.IOException;
import java.io.OutputStream;
import java.lang.annotation.Annotation;
import java.lang.reflect.Type;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.function.Consumer;
import javax.ws.rs.NotAcceptableException;
import javax.ws.rs.Produces;
import javax.ws.rs.container.ContainerResponseFilter;
import javax.ws.rs.core.MediaType;
import javax.ws.rs.core.NewCookie;
import javax.ws.rs.core.Response;
import javax.ws.rs.ext.MessageBodyWriter;
import javax.ws.rs.ext.WriterInterceptor;
import org.jboss.resteasy.core.NoMessageBodyWriterFoundFailure;
import org.jboss.resteasy.core.ResourceMethodInvoker;
import org.jboss.resteasy.core.ResteasyContext;
import org.jboss.resteasy.core.SynchronousDispatcher;
import org.jboss.resteasy.core.interception.jaxrs.ContainerResponseContextImpl;
import org.jboss.resteasy.core.interception.jaxrs.ResponseContainerRequestContext;
import org.jboss.resteasy.core.interception.jaxrs.ServerWriterInterceptorContext;
import org.jboss.resteasy.resteasy_jaxrs.i18n.LogMessages;
import org.jboss.resteasy.specimpl.BuiltResponse;
import org.jboss.resteasy.spi.HttpRequest;
import org.jboss.resteasy.spi.HttpResponse;
import org.jboss.resteasy.spi.ResteasyDeployment;
import org.jboss.resteasy.spi.ResteasyProviderFactory;
import org.jboss.resteasy.tracing.RESTEasyTracingLogger;
import org.jboss.resteasy.util.CommitHeaderOutputStream;
import org.jboss.resteasy.util.MediaTypeHelper;

public class ServerResponseWriter {
    public static void writeNomapResponse(BuiltResponse jaxrsResponse, HttpRequest request, HttpResponse response, ResteasyProviderFactory providerFactory, Consumer<Throwable> onComplete) throws IOException {
        ServerResponseWriter.writeNomapResponse(jaxrsResponse, request, response, providerFactory, onComplete, true);
    }

    @Deprecated
    public static void writeNomapResponse(BuiltResponse jaxrsResponse, HttpRequest request, HttpResponse response, ResteasyProviderFactory providerFactory) throws IOException {
        ServerResponseWriter.writeNomapResponse(jaxrsResponse, request, response, providerFactory, t -> {}, true);
    }

    @Deprecated
    public static void writeNomapResponse(BuiltResponse jaxrsResponse, HttpRequest request, HttpResponse response, ResteasyProviderFactory providerFactory, boolean sendHeaders) throws IOException {
        ServerResponseWriter.writeNomapResponse(jaxrsResponse, request, response, providerFactory, t -> {}, sendHeaders);
    }

    public static void writeNomapResponse(BuiltResponse jaxrsResponse, HttpRequest request, final HttpResponse response, ResteasyProviderFactory providerFactory, Consumer<Throwable> onComplete, boolean sendHeaders) throws IOException {
        ResourceMethodInvoker method = (ResourceMethodInvoker)request.getAttribute(ResourceMethodInvoker.class.getName());
        ServerResponseWriter.setResponseMediaType(jaxrsResponse, request, response, providerFactory, method);
        ServerResponseWriter.executeFilters(jaxrsResponse, request, response, providerFactory, method, onComplete, () -> {
            MediaType mt;
            Annotation[] annotations;
            if (jaxrsResponse.getEntity() == null || response.getOutputStream() == null) {
                response.setStatus(jaxrsResponse.getStatus());
                ServerResponseWriter.commitHeaders(jaxrsResponse, response);
                return;
            }
            Class type = jaxrsResponse.getEntityClass();
            Object ent = jaxrsResponse.getEntity();
            Type generic = jaxrsResponse.getGenericType();
            MessageBodyWriter writer = providerFactory.getMessageBodyWriter(type, generic, annotations = jaxrsResponse.getAnnotations(), mt = jaxrsResponse.getMediaType());
            if (writer != null) {
                LogMessages.LOGGER.debugf("MessageBodyWriter: %s", (Object)writer.getClass().getName());
            }
            if (writer == null) {
                throw new NoMessageBodyWriterFoundFailure(type, mt);
            }
            if (sendHeaders) {
                response.setStatus(jaxrsResponse.getStatus());
            }
            final BuiltResponse built = jaxrsResponse;
            CommitHeaderOutputStream.CommitCallback callback = new CommitHeaderOutputStream.CommitCallback(){
                private boolean committed;

                @Override
                public void commit() {
                    if (this.committed) {
                        return;
                    }
                    this.committed = true;
                    ServerResponseWriter.commitHeaders(built, response);
                }
            };
            OutputStream os = sendHeaders ? new CommitHeaderOutputStream(response.getOutputStream(), callback) : response.getOutputStream();
            WriterInterceptor[] writerInterceptors = null;
            writerInterceptors = method != null ? method.getWriterInterceptors() : (WriterInterceptor[])providerFactory.getServerWriterInterceptorRegistry().postMatch(null, null);
            ServerWriterInterceptorContext writerContext = new ServerWriterInterceptorContext(writerInterceptors, providerFactory, ent, type, generic, annotations, mt, jaxrsResponse.getMetadata(), os, request);
            RESTEasyTracingLogger tracingLogger = RESTEasyTracingLogger.getInstance(request);
            long timestamp = tracingLogger.timestamp("WI_SUMMARY");
            try {
                writerContext.proceed();
            }
            catch (Throwable throwable) {
                tracingLogger.logDuration("WI_SUMMARY", timestamp, writerContext.getProcessedInterceptorCount());
                throw throwable;
            }
            tracingLogger.logDuration("WI_SUMMARY", timestamp, writerContext.getProcessedInterceptorCount());
            if (sendHeaders) {
                response.setOutputStream(writerContext.getOutputStream());
                callback.commit();
            }
        });
    }

    public static void setResponseMediaType(BuiltResponse jaxrsResponse, HttpRequest request, HttpResponse response, ResteasyProviderFactory providerFactory, ResourceMethodInvoker method) {
        MediaType mt = ServerResponseWriter.getResponseMediaType(jaxrsResponse, request, response, providerFactory, method);
        if (mt != null) {
            jaxrsResponse.getHeaders().putSingle((Object)"Content-Type", (Object)mt.toString());
        }
    }

    public static MediaType getResponseMediaType(BuiltResponse jaxrsResponse, HttpRequest request, HttpResponse response, ResteasyProviderFactory providerFactory, ResourceMethodInvoker method) {
        MediaType mt = null;
        if (jaxrsResponse.getEntity() != null) {
            mt = jaxrsResponse.getMediaType();
            if (mt == null) {
                mt = ServerResponseWriter.getDefaultContentType(request, jaxrsResponse, providerFactory, method);
            }
            boolean addCharset = true;
            ResteasyDeployment deployment = ResteasyContext.getContextData(ResteasyDeployment.class);
            if (deployment != null) {
                addCharset = deployment.isAddCharset();
            }
            if (addCharset && !mt.getParameters().containsKey("charset") && MediaTypeHelper.isTextLike(mt)) {
                mt = mt.withCharset(StandardCharsets.UTF_8.toString());
            }
        }
        return mt;
    }

    private static void executeFilters(BuiltResponse jaxrsResponse, HttpRequest request, HttpResponse response, ResteasyProviderFactory providerFactory, ResourceMethodInvoker method, Consumer<Throwable> onComplete, RunnableWithIOException continuation) throws IOException {
        ContainerResponseFilter[] responseFilters = null;
        responseFilters = method != null ? method.getResponseFilters() : (ContainerResponseFilter[])providerFactory.getContainerResponseFilterRegistry().postMatch(null, null);
        if (responseFilters != null) {
            ResponseContainerRequestContext requestContext = new ResponseContainerRequestContext(request);
            ContainerResponseContextImpl responseContext = new ContainerResponseContextImpl(request, response, jaxrsResponse, requestContext, responseFilters, onComplete, continuation);
            RESTEasyTracingLogger logger = RESTEasyTracingLogger.getInstance(request);
            long timestamp = logger.timestamp("RESPONSE_FILTER_SUMMARY");
            responseContext.filter();
            logger.logDuration("RESPONSE_FILTER_SUMMARY", timestamp, responseFilters.length);
        } else {
            try {
                continuation.run();
                onComplete.accept(null);
            }
            catch (Throwable t) {
                onComplete.accept(t);
                SynchronousDispatcher.rethrow(t);
            }
        }
    }

    protected static void setDefaultContentType(HttpRequest request, BuiltResponse jaxrsResponse, ResteasyProviderFactory providerFactory, ResourceMethodInvoker method) {
        MediaType chosen = ServerResponseWriter.getDefaultContentType(request, jaxrsResponse, providerFactory, method);
        jaxrsResponse.getHeaders().putSingle((Object)"Content-Type", (Object)chosen);
    }

    protected static MediaType getDefaultContentType(HttpRequest request, BuiltResponse jaxrsResponse, ResteasyProviderFactory providerFactory, ResourceMethodInvoker method) {
        MediaType chosen = (MediaType)request.getAttribute("RESTEASY_CHOSEN_ACCEPT");
        boolean hasProduces = chosen != null && Boolean.valueOf((String)chosen.getParameters().get("RESTEASY-SERVER-HAS-PRODUCES")) != false;
        hasProduces |= method != null && method.getProduces() != null && method.getProduces().length > 0;
        if (hasProduces |= method != null && method.getMethod().getClass().getAnnotation(Produces.class) != null) {
            if (!ServerResponseWriter.isConcrete(chosen)) {
                MediaType[] produces = null;
                if (method != null) {
                    if (method.getProduces().length > 0) {
                        produces = method.getProduces();
                    } else {
                        String[] producesValues = method.getMethod().getClass().getAnnotation(Produces.class).value();
                        produces = new MediaType[producesValues.length];
                        for (int i = 0; i < producesValues.length; ++i) {
                            produces[i] = MediaType.valueOf((String)producesValues[i]);
                        }
                    }
                }
                if (produces == null) {
                    produces = new MediaType[]{MediaType.WILDCARD_TYPE};
                }
                List accepts = request.getHttpHeaders().getAcceptableMediaTypes();
                ArrayList<SortableMediaType> M = new ArrayList<SortableMediaType>();
                boolean hasStarStar = false;
                boolean hasApplicationStar = false;
                for (MediaType accept : accepts) {
                    for (MediaType produce : produces) {
                        SortableMediaType ms = ServerResponseWriter.mostSpecific(produce, null, accept, null);
                        if (ms.isWildcardSubtype()) {
                            hasStarStar |= ms.isWildcardType();
                            hasApplicationStar |= ms.getType().equals("application");
                        }
                        M.add(ms);
                    }
                }
                chosen = ServerResponseWriter.chooseFromM(chosen, M, hasStarStar, hasApplicationStar);
            }
        } else {
            Annotation[] annotations;
            chosen = MediaType.WILDCARD_TYPE;
            Class type = jaxrsResponse.getEntityClass();
            Object ent = jaxrsResponse.getEntity();
            Type generic = jaxrsResponse.getGenericType();
            if (generic == null) {
                generic = method != null && !Response.class.isAssignableFrom(method.getMethod().getReturnType()) ? method.getGenericReturnType() : type;
            }
            if ((annotations = jaxrsResponse.getAnnotations()) == null && method != null) {
                annotations = method.getMethodAnnotations();
            }
            List accepts = request.getHttpHeaders().getAcceptableMediaTypes();
            ArrayList<SortableMediaType> M = new ArrayList<SortableMediaType>();
            boolean hasStarStar = false;
            boolean hasApplicationStar = false;
            boolean pFound = false;
            for (MediaType accept : accepts) {
                Map mbws = providerFactory.getPossibleMessageBodyWritersMap(type, generic, annotations, accept);
                for (Map.Entry e : mbws.entrySet()) {
                    MessageBodyWriter mbw = (MessageBodyWriter)e.getKey();
                    Class wt = (Class)e.getValue();
                    Produces produces = mbw.getClass().getAnnotation(Produces.class);
                    if (produces == null) continue;
                    for (String produceValue : produces.value()) {
                        pFound = true;
                        MediaType produce = MediaType.valueOf((String)produceValue);
                        if (!produce.isCompatible(accept)) continue;
                        SortableMediaType ms = ServerResponseWriter.mostSpecific(produce, wt, accept, null);
                        if (ms.isWildcardSubtype()) {
                            hasStarStar |= ms.isWildcardType();
                            hasApplicationStar |= ms.getType().equals("application");
                        }
                        M.add(ms);
                    }
                }
            }
            if (!pFound) {
                Iterator iterator = accepts.iterator();
                while (iterator.hasNext()) {
                    MediaType accept;
                    MediaType produce = MediaType.WILDCARD_TYPE;
                    accept = (MediaType)iterator.next();
                    if (!produce.isCompatible(accept)) continue;
                    SortableMediaType ms = ServerResponseWriter.mostSpecific(produce, null, accept, null);
                    if (ms.isWildcardSubtype()) {
                        hasStarStar |= ms.isWildcardType();
                        hasApplicationStar |= ms.getType().equals("application");
                    }
                    M.add(ms);
                }
            }
            chosen = ServerResponseWriter.chooseFromM(chosen, M, hasStarStar, hasApplicationStar);
        }
        if (chosen.getParameters().containsKey("RESTEASY-SERVER-HAS-PRODUCES")) {
            HashMap map = new HashMap(chosen.getParameters());
            map.remove("RESTEASY-SERVER-HAS-PRODUCES");
            map.remove("RESTEASY-SERVER-HAS-PRODUCES".toLowerCase());
            chosen = new MediaType(chosen.getType(), chosen.getSubtype(), map);
        }
        boolean hasQ = chosen.getParameters().containsKey("q");
        boolean hasQs = chosen.getParameters().containsKey("qs");
        if (hasQ || hasQs) {
            HashMap map = new HashMap(chosen.getParameters());
            if (hasQ) {
                map.remove("q");
            }
            if (hasQs) {
                map.remove("qs");
            }
            chosen = new MediaType(chosen.getType(), chosen.getSubtype(), map);
        }
        return chosen;
    }

    private static MediaType chooseFromM(MediaType currentChoice, List<SortableMediaType> M, boolean hasStarStar, boolean hasApplicationStar) {
        if (M.isEmpty()) {
            throw new NotAcceptableException();
        }
        Collections.sort(M);
        for (SortableMediaType m : M) {
            if (!ServerResponseWriter.isConcrete(m)) continue;
            currentChoice = m;
            break;
        }
        if (!ServerResponseWriter.isConcrete(currentChoice)) {
            if (hasStarStar || hasApplicationStar) {
                currentChoice = MediaType.APPLICATION_OCTET_STREAM_TYPE;
            } else {
                throw new NotAcceptableException();
            }
        }
        return currentChoice;
    }

    private static boolean isConcrete(MediaType m) {
        return m != null && !m.isWildcardType() && !m.isWildcardSubtype();
    }

    public static MediaType resolveContentType(BuiltResponse response) {
        MediaType responseContentType = null;
        Object type = response.getMetadata().getFirst((Object)"Content-Type");
        if (type == null) {
            return MediaType.WILDCARD_TYPE;
        }
        responseContentType = type instanceof MediaType ? (MediaType)type : MediaType.valueOf((String)type.toString());
        return responseContentType;
    }

    public static void commitHeaders(BuiltResponse jaxrsResponse, HttpResponse response) {
        List cookies;
        if (jaxrsResponse.getMetadata() != null && (cookies = (List)jaxrsResponse.getMetadata().get((Object)"Set-Cookie")) != null) {
            Iterator it = cookies.iterator();
            while (it.hasNext()) {
                Object next = it.next();
                if (next instanceof NewCookie) {
                    NewCookie cookie = (NewCookie)next;
                    response.addNewCookie(cookie);
                    it.remove();
                    continue;
                }
                response.getOutputHeaders().add((Object)"Set-Cookie", next);
                it.remove();
            }
            jaxrsResponse.getMetadata().remove((Object)"Set-Cookie");
        }
        if (jaxrsResponse.getMetadata() != null && jaxrsResponse.getMetadata().size() > 0) {
            response.getOutputHeaders().putAll(jaxrsResponse.getMetadata());
        }
    }

    private static SortableMediaType selectMostSpecific(SortableMediaType m1, SortableMediaType m2) {
        if (m1.getType().equals("*")) {
            if (m2.getType().equals("*")) {
                if (m1.getSubtype().equals("*")) {
                    return m2;
                }
                return m1;
            }
            return m2;
        }
        if (m2.getType().equals("*")) {
            return m1;
        }
        if (m1.getSubtype().equals("*")) {
            return m2;
        }
        return m1;
    }

    private static SortableMediaType mostSpecific(MediaType p, Class<?> wtp, MediaType a, Class<?> wta) {
        if (p.getType().equals("*")) {
            if (a.getType().equals("*")) {
                if (p.getSubtype().equals("*")) {
                    return ServerResponseWriter.mixAddingQS(a, wta, p);
                }
                return ServerResponseWriter.mixAddingQ(p, wtp, a);
            }
            return ServerResponseWriter.mixAddingQS(a, wta, p);
        }
        if (a.getType().equals("*")) {
            return ServerResponseWriter.mixAddingQ(p, wtp, a);
        }
        if (p.getSubtype().equals("*")) {
            return ServerResponseWriter.mixAddingQS(a, wta, p);
        }
        return ServerResponseWriter.mixAddingQ(p, wtp, a);
    }

    private static SortableMediaType mixAddingQ(MediaType p, Class<?> wtp, MediaType a) {
        HashMap<String, String> pars = p.getParameters();
        String q = (String)a.getParameters().get("q");
        if (q != null) {
            pars = new HashMap<String, String>(pars);
            pars.put("q", q);
        }
        return new SortableMediaType(p.getType(), p.getSubtype(), pars, wtp);
    }

    private static SortableMediaType mixAddingQS(MediaType a, Class<?> wta, MediaType p) {
        HashMap<String, String> pars = a.getParameters();
        String qs = (String)p.getParameters().get("qs");
        if (qs != null) {
            pars = new HashMap<String, String>(pars);
            pars.put("qs", qs);
        }
        return new SortableMediaType(a.getType(), a.getSubtype(), pars, wta);
    }

    private static class SortableMediaType
    extends MediaType
    implements Comparable<SortableMediaType> {
        double q = 1.0;
        double qs = 1.0;
        Class<?> writerType = null;

        SortableMediaType(String type, String subtype, Map<String, String> parameters, Class<?> writerType) {
            super(type, subtype, parameters);
            String qsString;
            this.writerType = writerType;
            String qString = parameters.get("q");
            if (qString != null) {
                try {
                    this.q = Double.valueOf(qString);
                }
                catch (NumberFormatException numberFormatException) {
                    // empty catch block
                }
            }
            if ((qsString = parameters.get("qs")) != null) {
                try {
                    this.qs = Double.valueOf(qsString);
                }
                catch (NumberFormatException numberFormatException) {
                    // empty catch block
                }
            }
        }

        @Override
        public int compareTo(SortableMediaType o) {
            if (o.isCompatible(this)) {
                if (o.equals(this)) {
                    return 0;
                }
                return o.equals(ServerResponseWriter.selectMostSpecific(o, this)) ? 1 : -1;
            }
            if (o.q < this.q) {
                return -1;
            }
            if (o.q > this.q) {
                return 1;
            }
            if (o.qs < this.qs) {
                return -1;
            }
            if (o.qs > this.qs) {
                return 1;
            }
            if (o.writerType == this.writerType) {
                return 0;
            }
            if (o.writerType == null) {
                return -1;
            }
            if (this.writerType == null) {
                return 1;
            }
            if (o.writerType.isAssignableFrom(this.writerType)) {
                return -1;
            }
            if (this.writerType.isAssignableFrom(o.writerType)) {
                return 1;
            }
            return 0;
        }
    }

    @FunctionalInterface
    public static interface RunnableWithIOException {
        public void run() throws IOException;
    }
}

