/*
 * Decompiled with CFR 0.152.
 */
package io.reactiverse.reactivecontexts.core;

import io.reactiverse.reactivecontexts.core.Context;
import io.reactiverse.reactivecontexts.core.ContextState;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Executor;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.function.BiConsumer;
import java.util.function.BiFunction;
import java.util.function.Consumer;
import java.util.function.Function;

final class CompletableFutureWrapper<T>
extends CompletableFuture<T> {
    private final ContextState state;
    private final CompletableFuture<T> f;

    CompletableFutureWrapper(ContextState state, CompletableFuture<T> f) {
        this.state = state;
        this.f = f;
    }

    @Override
    public boolean complete(T value) {
        return this.f.complete(value);
    }

    @Override
    public boolean completeExceptionally(Throwable ex) {
        return this.f.completeExceptionally(ex);
    }

    @Override
    public boolean cancel(boolean mayInterruptIfRunning) {
        return this.f.cancel(mayInterruptIfRunning);
    }

    @Override
    public boolean isCancelled() {
        return this.f.isCancelled();
    }

    @Override
    public boolean isCompletedExceptionally() {
        return this.f.isCompletedExceptionally();
    }

    @Override
    public void obtrudeValue(T value) {
        this.f.obtrudeValue(value);
    }

    @Override
    public void obtrudeException(Throwable ex) {
        this.f.obtrudeException(ex);
    }

    @Override
    public int getNumberOfDependents() {
        return this.f.getNumberOfDependents();
    }

    @Override
    public boolean isDone() {
        return this.f.isDone();
    }

    @Override
    public T get() throws InterruptedException, ExecutionException {
        return this.f.get();
    }

    @Override
    public T get(long timeout, TimeUnit unit) throws InterruptedException, ExecutionException, TimeoutException {
        return this.f.get(timeout, unit);
    }

    @Override
    public T join() {
        return this.f.join();
    }

    @Override
    public T getNow(T valueIfAbsent) {
        return this.f.getNow(valueIfAbsent);
    }

    @Override
    public CompletableFuture<T> toCompletableFuture() {
        return this;
    }

    @Override
    public CompletableFuture<T> exceptionally(Function<Throwable, ? extends T> fn) {
        return Context.wrap(this.state, this.f.exceptionally(Context.wrap(this.state, fn)));
    }

    @Override
    public <U> CompletableFuture<U> handle(BiFunction<? super T, Throwable, ? extends U> fn) {
        return Context.wrap(this.state, this.f.handle(Context.wrap(this.state, fn)));
    }

    @Override
    public <U> CompletableFuture<U> handleAsync(BiFunction<? super T, Throwable, ? extends U> fn) {
        return Context.wrap(this.state, this.f.handleAsync(Context.wrap(this.state, fn)));
    }

    @Override
    public <U> CompletableFuture<U> handleAsync(BiFunction<? super T, Throwable, ? extends U> fn, Executor executor) {
        return Context.wrap(this.state, this.f.handleAsync(Context.wrap(this.state, fn), executor));
    }

    @Override
    public <U> CompletableFuture<U> thenApply(Function<? super T, ? extends U> fn) {
        return Context.wrap(this.state, this.f.thenApply(Context.wrap(this.state, fn)));
    }

    @Override
    public <U> CompletableFuture<U> thenApplyAsync(Function<? super T, ? extends U> fn) {
        return Context.wrap(this.state, this.f.thenApplyAsync(Context.wrap(this.state, fn)));
    }

    @Override
    public <U> CompletableFuture<U> thenApplyAsync(Function<? super T, ? extends U> fn, Executor executor) {
        return Context.wrap(this.state, this.f.thenApplyAsync(Context.wrap(this.state, fn), executor));
    }

    @Override
    public CompletableFuture<Void> thenAccept(Consumer<? super T> action) {
        return Context.wrap(this.state, this.f.thenAccept((Consumer)Context.wrap(this.state, action)));
    }

    @Override
    public CompletableFuture<Void> thenAcceptAsync(Consumer<? super T> action) {
        return Context.wrap(this.state, this.f.thenAcceptAsync((Consumer)Context.wrap(this.state, action)));
    }

    @Override
    public CompletableFuture<Void> thenAcceptAsync(Consumer<? super T> action, Executor executor) {
        return Context.wrap(this.state, this.f.thenAcceptAsync((Consumer)Context.wrap(this.state, action), executor));
    }

    @Override
    public CompletableFuture<Void> thenRun(Runnable action) {
        return Context.wrap(this.state, this.f.thenRun(Context.wrap(this.state, action)));
    }

    @Override
    public CompletableFuture<Void> thenRunAsync(Runnable action) {
        return Context.wrap(this.state, this.f.thenRunAsync(Context.wrap(this.state, action)));
    }

    @Override
    public CompletableFuture<Void> thenRunAsync(Runnable action, Executor executor) {
        return Context.wrap(this.state, this.f.thenRunAsync(Context.wrap(this.state, action), executor));
    }

    @Override
    public <U, V> CompletableFuture<V> thenCombine(CompletionStage<? extends U> other, BiFunction<? super T, ? super U, ? extends V> fn) {
        return Context.wrap(this.state, this.f.thenCombine(other, Context.wrap(this.state, fn)));
    }

    @Override
    public <U, V> CompletableFuture<V> thenCombineAsync(CompletionStage<? extends U> other, BiFunction<? super T, ? super U, ? extends V> fn) {
        return Context.wrap(this.state, this.f.thenCombineAsync(other, Context.wrap(this.state, fn)));
    }

    @Override
    public <U, V> CompletableFuture<V> thenCombineAsync(CompletionStage<? extends U> other, BiFunction<? super T, ? super U, ? extends V> fn, Executor executor) {
        return Context.wrap(this.state, this.f.thenCombineAsync(other, Context.wrap(this.state, fn), executor));
    }

    @Override
    public <U> CompletableFuture<Void> thenAcceptBoth(CompletionStage<? extends U> other, BiConsumer<? super T, ? super U> action) {
        return Context.wrap(this.state, this.f.thenAcceptBoth(other, (BiConsumer)Context.wrap(this.state, action)));
    }

    @Override
    public <U> CompletableFuture<Void> thenAcceptBothAsync(CompletionStage<? extends U> other, BiConsumer<? super T, ? super U> action) {
        return Context.wrap(this.state, this.f.thenAcceptBothAsync(other, (BiConsumer)Context.wrap(this.state, action)));
    }

    @Override
    public <U> CompletableFuture<Void> thenAcceptBothAsync(CompletionStage<? extends U> other, BiConsumer<? super T, ? super U> action, Executor executor) {
        return Context.wrap(this.state, this.f.thenAcceptBothAsync(other, (BiConsumer)Context.wrap(this.state, action), executor));
    }

    @Override
    public CompletableFuture<Void> runAfterBoth(CompletionStage<?> other, Runnable action) {
        return Context.wrap(this.state, this.f.runAfterBoth((CompletionStage)other, Context.wrap(this.state, action)));
    }

    @Override
    public CompletableFuture<Void> runAfterBothAsync(CompletionStage<?> other, Runnable action) {
        return Context.wrap(this.state, this.f.runAfterBothAsync((CompletionStage)other, Context.wrap(this.state, action)));
    }

    @Override
    public CompletableFuture<Void> runAfterBothAsync(CompletionStage<?> other, Runnable action, Executor executor) {
        return Context.wrap(this.state, this.f.runAfterBothAsync((CompletionStage)other, Context.wrap(this.state, action), executor));
    }

    @Override
    public <U> CompletableFuture<U> applyToEither(CompletionStage<? extends T> other, Function<? super T, U> fn) {
        return Context.wrap(this.state, this.f.applyToEither((CompletionStage)other, Context.wrap(this.state, fn)));
    }

    @Override
    public <U> CompletableFuture<U> applyToEitherAsync(CompletionStage<? extends T> other, Function<? super T, U> fn) {
        return Context.wrap(this.state, this.f.applyToEitherAsync((CompletionStage)other, Context.wrap(this.state, fn)));
    }

    @Override
    public <U> CompletableFuture<U> applyToEitherAsync(CompletionStage<? extends T> other, Function<? super T, U> fn, Executor executor) {
        return Context.wrap(this.state, this.f.applyToEitherAsync((CompletionStage)other, Context.wrap(this.state, fn), executor));
    }

    @Override
    public CompletableFuture<Void> acceptEither(CompletionStage<? extends T> other, Consumer<? super T> action) {
        return Context.wrap(this.state, this.f.acceptEither((CompletionStage)other, (Consumer)Context.wrap(this.state, action)));
    }

    @Override
    public CompletableFuture<Void> acceptEitherAsync(CompletionStage<? extends T> other, Consumer<? super T> action) {
        return Context.wrap(this.state, this.f.acceptEitherAsync((CompletionStage)other, (Consumer)Context.wrap(this.state, action)));
    }

    @Override
    public CompletableFuture<Void> acceptEitherAsync(CompletionStage<? extends T> other, Consumer<? super T> action, Executor executor) {
        return Context.wrap(this.state, this.f.acceptEitherAsync((CompletionStage)other, (Consumer)Context.wrap(this.state, action), executor));
    }

    @Override
    public CompletableFuture<Void> runAfterEither(CompletionStage<?> other, Runnable action) {
        return Context.wrap(this.state, this.f.runAfterEither((CompletionStage)other, Context.wrap(this.state, action)));
    }

    @Override
    public CompletableFuture<Void> runAfterEitherAsync(CompletionStage<?> other, Runnable action) {
        return Context.wrap(this.state, this.f.runAfterEitherAsync((CompletionStage)other, Context.wrap(this.state, action)));
    }

    @Override
    public CompletableFuture<Void> runAfterEitherAsync(CompletionStage<?> other, Runnable action, Executor executor) {
        return Context.wrap(this.state, this.f.runAfterEitherAsync((CompletionStage)other, Context.wrap(this.state, action), executor));
    }

    @Override
    public <U> CompletableFuture<U> thenCompose(Function<? super T, ? extends CompletionStage<U>> fn) {
        return Context.wrap(this.state, this.f.thenCompose(Context.wrap(this.state, fn)));
    }

    @Override
    public <U> CompletableFuture<U> thenComposeAsync(Function<? super T, ? extends CompletionStage<U>> fn) {
        return Context.wrap(this.state, this.f.thenComposeAsync(Context.wrap(this.state, fn)));
    }

    @Override
    public <U> CompletableFuture<U> thenComposeAsync(Function<? super T, ? extends CompletionStage<U>> fn, Executor executor) {
        return Context.wrap(this.state, this.f.thenComposeAsync(Context.wrap(this.state, fn), executor));
    }

    @Override
    public CompletableFuture<T> whenComplete(BiConsumer<? super T, ? super Throwable> action) {
        return Context.wrap(this.state, this.f.whenComplete(Context.wrap(this.state, action)));
    }

    @Override
    public CompletableFuture<T> whenCompleteAsync(BiConsumer<? super T, ? super Throwable> action) {
        return Context.wrap(this.state, this.f.whenCompleteAsync(Context.wrap(this.state, action)));
    }

    @Override
    public CompletableFuture<T> whenCompleteAsync(BiConsumer<? super T, ? super Throwable> action, Executor executor) {
        return Context.wrap(this.state, this.f.whenCompleteAsync(Context.wrap(this.state, action), executor));
    }

    @Override
    public String toString() {
        return this.f.toString();
    }

    public int hashCode() {
        return this.f.hashCode();
    }

    public boolean equals(Object obj) {
        return this.f.equals(obj);
    }
}

