/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.resteasy.spi;

import java.net.URI;
import java.util.List;
import java.util.regex.Pattern;
import javax.ws.rs.core.UriBuilder;
import javax.ws.rs.ext.RuntimeDelegate;

public abstract class ResteasyUriBuilder
extends UriBuilder {
    public static final Pattern opaqueUri = Pattern.compile("^([^:/?#{]+):([^/].*)");
    public static final Pattern hierarchicalUri = Pattern.compile("^(([^:/?#{]+):)?(//([^/?#]*))?([^?#]*)(\\?([^#]*))?(#(.*))?");

    public abstract UriBuilder clone();

    public static boolean compare(String s1, String s2) {
        if (s1 == s2) {
            return true;
        }
        if (s1 == null || s2 == null) {
            return false;
        }
        return s1.equals(s2);
    }

    public static URI relativize(URI from, URI to) {
        int i;
        if (!ResteasyUriBuilder.compare(from.getScheme(), to.getScheme())) {
            return to;
        }
        if (!ResteasyUriBuilder.compare(from.getHost(), to.getHost())) {
            return to;
        }
        if (from.getPort() != to.getPort()) {
            return to;
        }
        if (from.getPath() == null && to.getPath() == null) {
            return URI.create("");
        }
        if (from.getPath() == null) {
            return URI.create(to.getPath());
        }
        if (to.getPath() == null) {
            return to;
        }
        String fromPath = from.getPath();
        if (fromPath.startsWith("/")) {
            fromPath = fromPath.substring(1);
        }
        String[] fsplit = fromPath.split("/");
        String toPath = to.getPath();
        if (toPath.startsWith("/")) {
            toPath = toPath.substring(1);
        }
        String[] tsplit = toPath.split("/");
        for (int f = 0; f < fsplit.length && f < tsplit.length && fsplit[f].equals(tsplit[f]); ++f) {
        }
        UriBuilder builder = UriBuilder.fromPath((String)"");
        for (i = f; i < fsplit.length; ++i) {
            builder.path("..");
        }
        for (i = f; i < tsplit.length; ++i) {
            builder.path(tsplit[i]);
        }
        return builder.build(new Object[0]);
    }

    public static ResteasyUriBuilder fromTemplate(String uriTemplate) {
        ResteasyUriBuilder impl = (ResteasyUriBuilder)RuntimeDelegate.getInstance().createUriBuilder();
        impl.uriTemplate(uriTemplate);
        return impl;
    }

    public abstract UriBuilder uriTemplate(CharSequence var1);

    public abstract UriBuilder uriFromCharSequence(CharSequence var1) throws IllegalArgumentException;

    public abstract UriBuilder substitutePathParam(String var1, Object var2, boolean var3);

    public abstract List<String> getPathParamNamesInDeclarationOrder();

    public abstract UriBuilder clientQueryParam(String var1, Object var2) throws IllegalArgumentException;

    public abstract String getHost();

    public abstract String getScheme();

    public abstract int getPort();

    public abstract String getUserInfo();

    public abstract String getPath();

    public abstract String getQuery();

    public abstract String getFragment();
}

