/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.resteasy.spi.metadata;

import java.lang.annotation.Annotation;
import java.lang.reflect.AccessibleObject;
import java.lang.reflect.Type;
import org.jboss.resteasy.spi.metadata.ResourceClass;
import org.jboss.resteasy.spi.util.Types;

public abstract class Parameter {
    protected ResourceClass resourceClass;
    protected Class<?> type;
    protected Type genericType;
    protected ParamType paramType = ParamType.UNKNOWN;
    protected String paramName;
    protected boolean encoded;
    protected String defaultValue;

    protected Parameter(ResourceClass resourceClass, Class<?> type, Type genericType) {
        this.resourceClass = resourceClass;
        this.genericType = Types.resolveTypeVariables(resourceClass.getClazz(), genericType);
        this.type = Types.getRawType(this.genericType);
    }

    public ResourceClass getResourceClass() {
        return this.resourceClass;
    }

    public Class<?> getType() {
        return this.type;
    }

    public Type getGenericType() {
        return this.genericType;
    }

    public ParamType getParamType() {
        return this.paramType;
    }

    public String getParamName() {
        return this.paramName;
    }

    public boolean isEncoded() {
        return this.encoded;
    }

    public String getDefaultValue() {
        return this.defaultValue;
    }

    public abstract AccessibleObject getAccessibleObject();

    public abstract Annotation[] getAnnotations();

    public static enum ParamType {
        BEAN_PARAM,
        CONTEXT,
        COOKIE_PARAM,
        FORM_PARAM,
        HEADER_PARAM,
        MATRIX_PARAM,
        MESSAGE_BODY,
        PATH_PARAM,
        QUERY_PARAM,
        SUSPENDED,
        UNKNOWN,
        FORM,
        QUERY;

    }
}

