/*
 * Decompiled with CFR 0.152.
 */
package io.reactiverse.reactivecontexts.propagators.rxjava2;

import io.reactiverse.reactivecontexts.core.Context;
import io.reactiverse.reactivecontexts.core.ContextState;
import io.reactivex.Completable;
import io.reactivex.CompletableObserver;
import io.reactivex.disposables.Disposable;
import io.reactivex.functions.BiFunction;

public class ContextPropagatorOnCompletableCreateAction
implements BiFunction<Completable, CompletableObserver, CompletableObserver> {
    public CompletableObserver apply(Completable completable, CompletableObserver observer) throws Exception {
        return new ContextCapturerCompletable(completable, observer);
    }

    static final class ContextCapturerCompletable
    implements CompletableObserver {
        private final CompletableObserver source;
        private final ContextState states;

        public ContextCapturerCompletable(Completable s, CompletableObserver o) {
            this.source = o;
            this.states = Context.capture();
        }

        public void onError(Throwable t) {
            ContextState previousStates = this.states.install();
            try {
                this.source.onError(t);
            }
            finally {
                previousStates.restore();
            }
        }

        public void onSubscribe(Disposable d) {
            ContextState previousStates = this.states.install();
            try {
                this.source.onSubscribe(d);
            }
            finally {
                previousStates.restore();
            }
        }

        public void onComplete() {
            ContextState previousStates = this.states.install();
            try {
                this.source.onComplete();
            }
            finally {
                previousStates.restore();
            }
        }
    }
}

