/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.resteasy.core.request;

import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Locale;
import java.util.Map;
import javax.ws.rs.core.MediaType;
import org.jboss.resteasy.core.request.QualityValue;
import org.jboss.resteasy.resteasy_jaxrs.i18n.LogMessages;
import org.jboss.resteasy.resteasy_jaxrs.i18n.Messages;
import org.jboss.resteasy.spi.BadRequestException;

public class AcceptHeaders {
    public static Map<String, QualityValue> getStringQualityValues(String header) {
        if (header == null) {
            return null;
        }
        if ((header = header.trim()).length() == 0) {
            return null;
        }
        LinkedHashMap<String, QualityValue> result = new LinkedHashMap<String, QualityValue>();
        int offset = 0;
        while (true) {
            int endIndex;
            String content = (endIndex = header.indexOf(44, offset)) < 0 ? header.substring(offset) : header.substring(offset, endIndex);
            QualityValue qualityValue = QualityValue.DEFAULT;
            int qualityIndex = content.indexOf(59);
            if (qualityIndex >= 0) {
                String parameter = content.substring(qualityIndex + 1);
                content = content.substring(0, qualityIndex);
                int equalsIndex = parameter.indexOf(61);
                if (equalsIndex < 0) {
                    throw new BadRequestException(Messages.MESSAGES.malformedParameter(parameter));
                }
                String name = parameter.substring(0, equalsIndex).trim();
                if (!"q".equals(name)) {
                    throw new BadRequestException(Messages.MESSAGES.unsupportedParameter(name));
                }
                String value = parameter.substring(equalsIndex + 1).trim();
                qualityValue = QualityValue.valueOf(value);
            }
            if ((content = content.trim()).length() == 0) {
                throw new BadRequestException(Messages.MESSAGES.emptyFieldInHeader(header));
            }
            if (content.equals("*")) {
                result.put(null, qualityValue);
            } else {
                result.put(content, qualityValue);
            }
            if (endIndex < 0) break;
            offset = endIndex + 1;
        }
        LogMessages.LOGGER.debug((Object)((Object)result).toString());
        return result;
    }

    public static Map<Locale, QualityValue> getLocaleQualityValues(String header) {
        Map<String, QualityValue> stringResult = AcceptHeaders.getStringQualityValues(header);
        if (stringResult == null) {
            return null;
        }
        LinkedHashMap<Locale, QualityValue> result = new LinkedHashMap<Locale, QualityValue>(stringResult.size() * 2);
        for (Map.Entry<String, QualityValue> entry : stringResult.entrySet()) {
            QualityValue quality = entry.getValue();
            Locale locale = null;
            String value = entry.getKey();
            if (value != null) {
                int length = value.length();
                if (length == 2) {
                    locale = new Locale(value);
                } else if (length == 5 && value.charAt(2) == '-') {
                    String language = value.substring(0, 2);
                    String country = value.substring(3, 5);
                    locale = new Locale(language, country);
                } else {
                    LogMessages.LOGGER.ignoringUnsupportedLocale(value);
                    continue;
                }
            }
            result.put(locale, quality);
        }
        LogMessages.LOGGER.debug((Object)((Object)result).toString());
        return result;
    }

    public static Map<MediaType, QualityValue> getMediaTypeQualityValues(String header) {
        if (header == null) {
            return null;
        }
        if ((header = header.trim()).length() == 0) {
            return null;
        }
        LinkedHashMap<MediaType, QualityValue> result = new LinkedHashMap<MediaType, QualityValue>();
        int offset = 0;
        while (offset >= 0) {
            String subtype;
            int itemEndIndex;
            int slashIndex = header.indexOf(47, offset);
            if (slashIndex < 0) {
                throw new BadRequestException(Messages.MESSAGES.malformedMediaType(header));
            }
            String type = header.substring(offset, slashIndex);
            LinkedHashMap<String, String> parameters = null;
            QualityValue qualityValue = QualityValue.DEFAULT;
            offset = slashIndex + 1;
            int parameterStartIndex = header.indexOf(59, offset);
            if (parameterStartIndex == (itemEndIndex = header.indexOf(44, offset))) {
                assert (itemEndIndex == -1);
                subtype = header.substring(offset);
                offset = -1;
            } else if (itemEndIndex < 0 || parameterStartIndex >= 0 && parameterStartIndex < itemEndIndex) {
                subtype = header.substring(offset, parameterStartIndex);
                offset = parameterStartIndex + 1;
                parameters = new LinkedHashMap<String, String>();
                offset = AcceptHeaders.parseParameters(parameters, header, offset);
                qualityValue = AcceptHeaders.evaluateAcceptParameters(parameters);
            } else {
                subtype = header.substring(offset, itemEndIndex);
                offset = itemEndIndex + 1;
            }
            result.put(new MediaType(type.trim(), subtype.trim(), parameters), qualityValue);
        }
        LogMessages.LOGGER.debug((Object)((Object)result).toString());
        return result;
    }

    private static int parseParameters(Map<String, String> parameters, String header, int offset) {
        while (true) {
            int itemEndIndex;
            int equalsIndex;
            if ((equalsIndex = header.indexOf(61, offset)) < 0) {
                throw new BadRequestException(Messages.MESSAGES.malformedParameters(header));
            }
            String name = header.substring(offset, equalsIndex).trim();
            offset = equalsIndex + 1;
            if (header.charAt(offset) == '\"') {
                int end = offset++;
                do {
                    ++end;
                    if ((end = header.indexOf(34, end)) >= 0) continue;
                    throw new BadRequestException(Messages.MESSAGES.quotedStringIsNotClosed(header));
                } while (header.charAt(end - 1) == '\\');
                String value = header.substring(offset, end);
                parameters.put(name, value);
                offset = end + 1;
                int parameterEndIndex = header.indexOf(59, offset);
                int itemEndIndex2 = header.indexOf(44, offset);
                if (parameterEndIndex == itemEndIndex2) {
                    assert (itemEndIndex2 == -1);
                    if (header.substring(offset).trim().length() != 0) {
                        throw new BadRequestException(Messages.MESSAGES.tailingGarbage(header));
                    }
                    return -1;
                }
                if (parameterEndIndex < 0 || itemEndIndex2 >= 0 && itemEndIndex2 < parameterEndIndex) {
                    if (header.substring(offset, itemEndIndex2).trim().length() != 0) {
                        throw new BadRequestException(Messages.MESSAGES.garbageAfterQuotedString(header));
                    }
                    return itemEndIndex2 + 1;
                }
                if (header.substring(offset, parameterEndIndex).trim().length() != 0) {
                    throw new BadRequestException(Messages.MESSAGES.garbageAfterQuotedString(header));
                }
                offset = parameterEndIndex + 1;
                continue;
            }
            int parameterEndIndex = header.indexOf(59, offset);
            if (parameterEndIndex == (itemEndIndex = header.indexOf(44, offset))) {
                assert (itemEndIndex == -1);
                String value = header.substring(offset).trim();
                parameters.put(name, value);
                return -1;
            }
            if (parameterEndIndex < 0 || itemEndIndex >= 0 && itemEndIndex < parameterEndIndex) {
                String value = header.substring(offset, itemEndIndex).trim();
                parameters.put(name, value);
                return itemEndIndex + 1;
            }
            String value = header.substring(offset, parameterEndIndex).trim();
            parameters.put(name, value);
            offset = parameterEndIndex + 1;
        }
    }

    private static QualityValue evaluateAcceptParameters(Map<String, String> parameters) {
        Iterator<String> i = parameters.keySet().iterator();
        while (i.hasNext()) {
            String name = i.next();
            if (!"q".equals(name)) continue;
            if (i.hasNext()) {
                LogMessages.LOGGER.acceptExtensionsNotSupported();
                i.remove();
                do {
                    i.next();
                    i.remove();
                } while (i.hasNext());
                return QualityValue.NOT_ACCEPTABLE;
            }
            String value = parameters.get(name);
            i.remove();
            return QualityValue.valueOf(value);
        }
        return QualityValue.DEFAULT;
    }
}

