/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.resteasy.core;

import java.util.HashMap;
import java.util.Map;
import javax.ws.rs.core.UriInfo;
import org.jboss.resteasy.resteasy_jaxrs.i18n.Messages;
import org.jboss.resteasy.spi.BadRequestException;
import org.jboss.resteasy.util.ThreadLocalStack;

public final class ResteasyContext {
    private static final ThreadLocalStack<Map<Class<?>, Object>> contextualData = new ThreadLocalStack();
    private static final int maxForwards = 20;

    public static <T> void pushContext(Class<T> type, T data) {
        ResteasyContext.getContextDataMap().put(type, data);
    }

    public static void pushContextDataMap(Map<Class<?>, Object> map) {
        contextualData.push(map);
    }

    public static Map<Class<?>, Object> getContextDataMap() {
        return ResteasyContext.getContextDataMap(true);
    }

    public static <T> T getContextData(Class<T> type) {
        return (T)ResteasyContext.getContextDataMap().get(type);
    }

    public static <T> T popContextData(Class<T> type) {
        return (T)ResteasyContext.getContextDataMap().remove(type);
    }

    public static void clearContextData() {
        contextualData.clear();
    }

    private static Map<Class<?>, Object> getContextDataMap(boolean create) {
        Map<Class<?>, Object> map = contextualData.get();
        if (map == null) {
            map = new HashMap();
            contextualData.setLast(map);
        }
        return map;
    }

    public static Map<Class<?>, Object> addContextDataLevel() {
        if (ResteasyContext.getContextDataLevelCount() == 20) {
            throw new BadRequestException(Messages.MESSAGES.excededMaximumForwards(ResteasyContext.getContextData(UriInfo.class).getPath()));
        }
        HashMap map = new HashMap();
        contextualData.push(map);
        return map;
    }

    public static int getContextDataLevelCount() {
        return contextualData.size();
    }

    public static void removeContextDataLevel() {
        contextualData.pop();
    }
}

