/*
 * Decompiled with CFR 0.152.
 */
package io.reactiverse.reactivecontexts.propagators.rxjava2;

import io.reactiverse.reactivecontexts.core.Context;
import io.reactiverse.reactivecontexts.core.ContextState;
import io.reactivex.Flowable;
import io.reactivex.functions.BiFunction;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;

public class ContextPropagatorOnFlowableCreateAction
implements BiFunction<Flowable, Subscriber, Subscriber> {
    public Subscriber apply(Flowable flowable, Subscriber observer) throws Exception {
        return new ContextCapturerFlowable(flowable, observer);
    }

    public class ContextCapturerFlowable<T>
    implements Subscriber<T> {
        private final Subscriber<T> source;
        private final ContextState states;

        public ContextCapturerFlowable(Flowable<T> observable, Subscriber<T> observer) {
            this.source = observer;
            this.states = Context.capture();
        }

        public void onComplete() {
            ContextState previousStates = this.states.install();
            try {
                this.source.onComplete();
            }
            finally {
                previousStates.restore();
            }
        }

        public void onError(Throwable t) {
            ContextState previousStates = this.states.install();
            try {
                this.source.onError(t);
            }
            finally {
                previousStates.restore();
            }
        }

        public void onNext(T v) {
            ContextState previousStates = this.states.install();
            try {
                this.source.onNext(v);
            }
            finally {
                previousStates.restore();
            }
        }

        public void onSubscribe(Subscription s) {
            ContextState previousStates = this.states.install();
            try {
                this.source.onSubscribe(s);
            }
            finally {
                previousStates.restore();
            }
        }
    }
}

