/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.resteasy.core.providerfactory;

import java.lang.reflect.Type;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.CopyOnWriteArraySet;
import javax.ws.rs.ConstrainedTo;
import javax.ws.rs.Consumes;
import javax.ws.rs.Produces;
import javax.ws.rs.RuntimeType;
import javax.ws.rs.client.ClientRequestFilter;
import javax.ws.rs.client.ClientResponseFilter;
import javax.ws.rs.client.RxInvoker;
import javax.ws.rs.client.RxInvokerProvider;
import javax.ws.rs.container.DynamicFeature;
import javax.ws.rs.core.MediaType;
import javax.ws.rs.ext.MessageBodyReader;
import javax.ws.rs.ext.MessageBodyWriter;
import javax.ws.rs.ext.ReaderInterceptor;
import javax.ws.rs.ext.WriterInterceptor;
import org.jboss.resteasy.core.MediaTypeMap;
import org.jboss.resteasy.core.interception.jaxrs.ClientRequestFilterRegistryImpl;
import org.jboss.resteasy.core.interception.jaxrs.ClientResponseFilterRegistryImpl;
import org.jboss.resteasy.core.interception.jaxrs.ReaderInterceptorRegistryImpl;
import org.jboss.resteasy.core.interception.jaxrs.WriterInterceptorRegistryImpl;
import org.jboss.resteasy.core.providerfactory.ResteasyProviderFactoryImpl;
import org.jboss.resteasy.core.providerfactory.SortedKey;
import org.jboss.resteasy.core.providerfactory.Utils;
import org.jboss.resteasy.resteasy_jaxrs.i18n.Messages;
import org.jboss.resteasy.spi.AsyncClientResponseProvider;
import org.jboss.resteasy.spi.ResteasyProviderFactory;
import org.jboss.resteasy.spi.interception.JaxrsInterceptorRegistry;
import org.jboss.resteasy.spi.util.Types;

public class ClientHelper {
    private final ResteasyProviderFactoryImpl rpf;
    private MediaTypeMap<SortedKey<MessageBodyReader>> clientMessageBodyReaders;
    private MediaTypeMap<SortedKey<MessageBodyWriter>> clientMessageBodyWriters;
    private JaxrsInterceptorRegistry<ClientRequestFilter> clientRequestFilterRegistry;
    private JaxrsInterceptorRegistry<ClientResponseFilter> clientResponseFilters;
    private JaxrsInterceptorRegistry<ReaderInterceptor> clientReaderInterceptorRegistry;
    private JaxrsInterceptorRegistry<WriterInterceptor> clientWriterInterceptorRegistry;
    private Set<DynamicFeature> clientDynamicFeatures;
    private Map<Class<?>, AsyncClientResponseProvider> asyncClientResponseProviders;
    private Map<Class<?>, Class<? extends RxInvokerProvider<?>>> reactiveClasses;

    public ClientHelper(ResteasyProviderFactoryImpl rpf) {
        this.rpf = rpf;
    }

    protected void initializeDefault() {
        this.reactiveClasses = new ConcurrentHashMap();
    }

    protected void initialize(ResteasyProviderFactoryImpl parent) {
        this.clientMessageBodyReaders = parent == null ? new MediaTypeMap() : parent.getClientMessageBodyReaders().clone();
        this.clientMessageBodyWriters = parent == null ? new MediaTypeMap() : parent.getClientMessageBodyWriters().clone();
        this.clientRequestFilterRegistry = parent == null ? new ClientRequestFilterRegistryImpl(this.rpf) : parent.getClientRequestFilterRegistry().clone((ResteasyProviderFactory)this.rpf);
        this.clientResponseFilters = parent == null ? new ClientResponseFilterRegistryImpl(this.rpf) : parent.getClientResponseFilters().clone((ResteasyProviderFactory)this.rpf);
        this.clientReaderInterceptorRegistry = parent == null ? new ReaderInterceptorRegistryImpl(this.rpf) : parent.getClientReaderInterceptorRegistry().clone((ResteasyProviderFactory)this.rpf);
        this.clientWriterInterceptorRegistry = parent == null ? new WriterInterceptorRegistryImpl(this.rpf) : parent.getClientWriterInterceptorRegistry().clone((ResteasyProviderFactory)this.rpf);
        this.clientDynamicFeatures = parent == null ? new CopyOnWriteArraySet<DynamicFeature>() : new CopyOnWriteArraySet<DynamicFeature>(parent.getClientDynamicFeatures());
        this.asyncClientResponseProviders = parent == null ? new ConcurrentHashMap(1) : new ConcurrentHashMap(parent.getAsyncClientResponseProviders());
        this.reactiveClasses = parent == null ? new ConcurrentHashMap(8) : new ConcurrentHashMap(parent.clientHelper.reactiveClasses);
    }

    protected void initializeClientProviders(ResteasyProviderFactory factory) {
        this.clientRequestFilterRegistry = factory == null ? new ClientRequestFilterRegistryImpl(this.rpf) : factory.getClientRequestFilterRegistry().clone((ResteasyProviderFactory)this.rpf);
        this.clientResponseFilters = factory == null ? new ClientResponseFilterRegistryImpl(this.rpf) : factory.getClientResponseFilters().clone((ResteasyProviderFactory)this.rpf);
    }

    protected JaxrsInterceptorRegistry<ReaderInterceptor> getClientReaderInterceptorRegistry(ResteasyProviderFactory parent) {
        if (this.clientReaderInterceptorRegistry == null && parent != null) {
            return parent.getClientReaderInterceptorRegistry();
        }
        return this.clientReaderInterceptorRegistry;
    }

    protected JaxrsInterceptorRegistry<WriterInterceptor> getClientWriterInterceptorRegistry(ResteasyProviderFactory parent) {
        if (this.clientWriterInterceptorRegistry == null && parent != null) {
            return parent.getClientWriterInterceptorRegistry();
        }
        return this.clientWriterInterceptorRegistry;
    }

    protected JaxrsInterceptorRegistry<ClientRequestFilter> getClientRequestFilterRegistry(ResteasyProviderFactory parent) {
        if (this.clientRequestFilterRegistry == null && parent != null) {
            return parent.getClientRequestFilterRegistry();
        }
        return this.clientRequestFilterRegistry;
    }

    protected JaxrsInterceptorRegistry<ClientResponseFilter> getClientResponseFilters(ResteasyProviderFactory parent) {
        if (this.clientResponseFilters == null && parent != null) {
            return parent.getClientResponseFilters();
        }
        return this.clientResponseFilters;
    }

    protected Set<DynamicFeature> getClientDynamicFeatures(ResteasyProviderFactory parent) {
        if (this.clientDynamicFeatures == null && parent != null) {
            return parent.getClientDynamicFeatures();
        }
        return this.clientDynamicFeatures;
    }

    protected Map<Class<?>, AsyncClientResponseProvider> getAsyncClientResponseProviders(ResteasyProviderFactory parent) {
        if (this.asyncClientResponseProviders == null && parent != null) {
            return parent.getAsyncClientResponseProviders();
        }
        return this.asyncClientResponseProviders;
    }

    protected RxInvokerProvider<?> getRxInvokerProviderFromReactiveClass(Class<?> clazz) {
        Class<? extends RxInvokerProvider<?>> rxInvokerProviderClass = this.reactiveClasses.get(clazz);
        if (rxInvokerProviderClass != null) {
            return this.rpf.createProviderInstance(rxInvokerProviderClass);
        }
        return null;
    }

    protected boolean isReactive(Class<?> clazz) {
        return this.reactiveClasses.keySet().contains(clazz);
    }

    protected void processProviderContracts(Class provider, Integer priorityOverride, boolean isBuiltin, Map<Class<?>, Integer> contracts, Map<Class<?>, Integer> newContracts, ResteasyProviderFactoryImpl parent) {
        int priority;
        int priority2;
        if (Utils.isA(provider, MessageBodyReader.class, contracts)) {
            try {
                priority2 = Utils.getPriority(priorityOverride, contracts, MessageBodyReader.class, provider);
                this.addMessageBodyReader((MessageBodyReader)Utils.createProviderInstance(this.rpf, provider), provider, priority2, isBuiltin, parent);
                newContracts.put(MessageBodyReader.class, priority2);
            }
            catch (Exception e) {
                throw new RuntimeException(Messages.MESSAGES.unableToInstantiateMessageBodyReader(), e);
            }
        }
        if (Utils.isA(provider, MessageBodyWriter.class, contracts)) {
            try {
                priority2 = Utils.getPriority(priorityOverride, contracts, MessageBodyWriter.class, provider);
                this.addMessageBodyWriter((MessageBodyWriter)Utils.createProviderInstance(this.rpf, provider), provider, priority2, isBuiltin, parent);
                newContracts.put(MessageBodyWriter.class, priority2);
            }
            catch (Exception e) {
                throw new RuntimeException(Messages.MESSAGES.unableToInstantiateMessageBodyWriter(), e);
            }
        }
        if (Utils.isA(provider, ClientRequestFilter.class, contracts)) {
            if (this.clientRequestFilterRegistry == null) {
                this.clientRequestFilterRegistry = parent.getClientRequestFilterRegistry().clone((ResteasyProviderFactory)this.rpf);
            }
            priority2 = Utils.getPriority(priorityOverride, contracts, ClientRequestFilter.class, provider);
            this.clientRequestFilterRegistry.registerClass(provider, priority2);
            newContracts.put(ClientRequestFilter.class, priority2);
        }
        if (Utils.isA(provider, ClientResponseFilter.class, contracts)) {
            if (this.clientResponseFilters == null) {
                this.clientResponseFilters = parent.getClientResponseFilters().clone((ResteasyProviderFactory)this.rpf);
            }
            priority2 = Utils.getPriority(priorityOverride, contracts, ClientResponseFilter.class, provider);
            this.clientResponseFilters.registerClass(provider, priority2);
            newContracts.put(ClientResponseFilter.class, priority2);
        }
        if (Utils.isA(provider, ReaderInterceptor.class, contracts)) {
            ConstrainedTo constrainedTo = provider.getAnnotation(ConstrainedTo.class);
            priority = Utils.getPriority(priorityOverride, contracts, ReaderInterceptor.class, provider);
            if (constrainedTo != null && constrainedTo.value() == RuntimeType.CLIENT) {
                if (this.clientReaderInterceptorRegistry == null) {
                    this.clientReaderInterceptorRegistry = parent.getClientReaderInterceptorRegistry().clone((ResteasyProviderFactory)this.rpf);
                }
                this.clientReaderInterceptorRegistry.registerClass(provider, priority);
            }
            if (constrainedTo == null) {
                if (this.clientReaderInterceptorRegistry == null) {
                    this.clientReaderInterceptorRegistry = parent.getClientReaderInterceptorRegistry().clone((ResteasyProviderFactory)this.rpf);
                }
                this.clientReaderInterceptorRegistry.registerClass(provider, priority);
            }
            newContracts.put(ReaderInterceptor.class, priority);
        }
        if (Utils.isA(provider, WriterInterceptor.class, contracts)) {
            ConstrainedTo constrainedTo = provider.getAnnotation(ConstrainedTo.class);
            priority = Utils.getPriority(priorityOverride, contracts, WriterInterceptor.class, provider);
            if (constrainedTo != null && constrainedTo.value() == RuntimeType.CLIENT) {
                if (this.clientWriterInterceptorRegistry == null) {
                    this.clientWriterInterceptorRegistry = parent.getClientWriterInterceptorRegistry().clone((ResteasyProviderFactory)this.rpf);
                }
                this.clientWriterInterceptorRegistry.registerClass(provider, priority);
            }
            if (constrainedTo == null) {
                if (this.clientWriterInterceptorRegistry == null) {
                    this.clientWriterInterceptorRegistry = parent.getClientWriterInterceptorRegistry().clone((ResteasyProviderFactory)this.rpf);
                }
                this.clientWriterInterceptorRegistry.registerClass(provider, priority);
            }
            newContracts.put(WriterInterceptor.class, priority);
        }
        if (Utils.isA(provider, DynamicFeature.class, contracts)) {
            ConstrainedTo constrainedTo = provider.getAnnotation(ConstrainedTo.class);
            priority = Utils.getPriority(priorityOverride, contracts, DynamicFeature.class, provider);
            if (constrainedTo != null && constrainedTo.value() == RuntimeType.CLIENT) {
                if (this.clientDynamicFeatures == null) {
                    this.clientDynamicFeatures = new CopyOnWriteArraySet<DynamicFeature>(parent.getClientDynamicFeatures());
                }
                this.clientDynamicFeatures.add((DynamicFeature)this.rpf.injectedInstance(provider));
            }
            if (constrainedTo == null) {
                if (this.clientDynamicFeatures == null) {
                    this.clientDynamicFeatures = new CopyOnWriteArraySet<DynamicFeature>(parent.getClientDynamicFeatures());
                }
                this.clientDynamicFeatures.add((DynamicFeature)this.rpf.injectedInstance(provider));
            }
            newContracts.put(DynamicFeature.class, priority);
        }
        if (Utils.isA(provider, AsyncClientResponseProvider.class, contracts)) {
            try {
                this.addAsyncClientResponseProvider((AsyncClientResponseProvider)this.rpf.createProviderInstance(provider), provider, parent);
                newContracts.put(AsyncClientResponseProvider.class, Utils.getPriority(priorityOverride, contracts, AsyncClientResponseProvider.class, provider));
            }
            catch (Exception e) {
                throw new RuntimeException(Messages.MESSAGES.unableToInstantiateAsyncClientResponseProvider(), e);
            }
        }
        if (Utils.isA(provider, RxInvokerProvider.class, contracts)) {
            int priority3 = Utils.getPriority(priorityOverride, contracts, RxInvokerProvider.class, provider);
            newContracts.put(RxInvokerProvider.class, priority3);
            Class clazz = Types.getTemplateParameterOfInterface((Class)provider, RxInvokerProvider.class);
            clazz = Types.getTemplateParameterOfInterface((Class)clazz, RxInvoker.class);
            if (clazz != null) {
                this.reactiveClasses.put(clazz, provider);
            }
        }
    }

    protected void processProviderInstanceContracts(Object provider, Map<Class<?>, Integer> contracts, Integer priorityOverride, boolean builtIn, Map<Class<?>, Integer> newContracts, ResteasyProviderFactoryImpl parent) {
        int priority;
        int priority2;
        if (Utils.isA(provider, MessageBodyReader.class, contracts)) {
            try {
                priority2 = Utils.getPriority(priorityOverride, contracts, MessageBodyReader.class, provider.getClass());
                this.addMessageBodyReader((MessageBodyReader)provider, provider.getClass(), priority2, builtIn, parent);
                newContracts.put(MessageBodyReader.class, priority2);
            }
            catch (Exception e) {
                throw new RuntimeException(Messages.MESSAGES.unableToInstantiateMessageBodyReader(), e);
            }
        }
        if (Utils.isA(provider, MessageBodyWriter.class, contracts)) {
            try {
                priority2 = Utils.getPriority(priorityOverride, contracts, MessageBodyWriter.class, provider.getClass());
                this.addMessageBodyWriter((MessageBodyWriter)provider, provider.getClass(), priority2, builtIn, parent);
                newContracts.put(MessageBodyWriter.class, priority2);
            }
            catch (Exception e) {
                throw new RuntimeException(Messages.MESSAGES.unableToInstantiateMessageBodyWriter(), e);
            }
        }
        if (Utils.isA(provider, ClientRequestFilter.class, contracts)) {
            if (this.clientRequestFilterRegistry == null) {
                this.clientRequestFilterRegistry = parent.getClientRequestFilterRegistry().clone((ResteasyProviderFactory)this.rpf);
            }
            priority2 = Utils.getPriority(priorityOverride, contracts, ClientRequestFilter.class, provider.getClass());
            this.clientRequestFilterRegistry.registerSingleton((Object)((ClientRequestFilter)provider), priority2);
            newContracts.put(ClientRequestFilter.class, priority2);
        }
        if (Utils.isA(provider, ClientResponseFilter.class, contracts)) {
            if (this.clientResponseFilters == null) {
                this.clientResponseFilters = parent.getClientResponseFilters().clone((ResteasyProviderFactory)this.rpf);
            }
            priority2 = Utils.getPriority(priorityOverride, contracts, ClientResponseFilter.class, provider.getClass());
            this.clientResponseFilters.registerSingleton((Object)((ClientResponseFilter)provider), priority2);
            newContracts.put(ClientResponseFilter.class, priority2);
        }
        if (Utils.isA(provider, ReaderInterceptor.class, contracts)) {
            ConstrainedTo constrainedTo = provider.getClass().getAnnotation(ConstrainedTo.class);
            priority = Utils.getPriority(priorityOverride, contracts, ReaderInterceptor.class, provider.getClass());
            if (constrainedTo != null && constrainedTo.value() == RuntimeType.CLIENT) {
                if (this.clientReaderInterceptorRegistry == null) {
                    this.clientReaderInterceptorRegistry = parent.getClientReaderInterceptorRegistry().clone((ResteasyProviderFactory)this.rpf);
                }
                this.clientReaderInterceptorRegistry.registerSingleton((Object)((ReaderInterceptor)provider), priority);
            }
            if (constrainedTo == null) {
                if (this.clientReaderInterceptorRegistry == null) {
                    this.clientReaderInterceptorRegistry = parent.getClientReaderInterceptorRegistry().clone((ResteasyProviderFactory)this.rpf);
                }
                this.clientReaderInterceptorRegistry.registerSingleton((Object)((ReaderInterceptor)provider), priority);
            }
            newContracts.put(ReaderInterceptor.class, priority);
        }
        if (Utils.isA(provider, WriterInterceptor.class, contracts)) {
            ConstrainedTo constrainedTo = provider.getClass().getAnnotation(ConstrainedTo.class);
            priority = Utils.getPriority(priorityOverride, contracts, WriterInterceptor.class, provider.getClass());
            if (constrainedTo != null && constrainedTo.value() == RuntimeType.CLIENT) {
                if (this.clientWriterInterceptorRegistry == null) {
                    this.clientWriterInterceptorRegistry = parent.getClientWriterInterceptorRegistry().clone((ResteasyProviderFactory)this.rpf);
                }
                this.clientWriterInterceptorRegistry.registerSingleton((Object)((WriterInterceptor)provider), priority);
            }
            if (constrainedTo == null) {
                if (this.clientWriterInterceptorRegistry == null) {
                    this.clientWriterInterceptorRegistry = parent.getClientWriterInterceptorRegistry().clone((ResteasyProviderFactory)this.rpf);
                }
                this.clientWriterInterceptorRegistry.registerSingleton((Object)((WriterInterceptor)provider), priority);
            }
            newContracts.put(WriterInterceptor.class, priority);
        }
        if (Utils.isA(provider, DynamicFeature.class, contracts)) {
            ConstrainedTo constrainedTo = provider.getClass().getAnnotation(ConstrainedTo.class);
            priority = Utils.getPriority(priorityOverride, contracts, DynamicFeature.class, provider.getClass());
            if (constrainedTo != null && constrainedTo.value() == RuntimeType.CLIENT) {
                if (this.clientDynamicFeatures == null) {
                    this.clientDynamicFeatures = new CopyOnWriteArraySet<DynamicFeature>(parent.getClientDynamicFeatures());
                }
                this.clientDynamicFeatures.add((DynamicFeature)provider);
            }
            if (constrainedTo == null) {
                if (this.clientDynamicFeatures == null) {
                    this.clientDynamicFeatures = new CopyOnWriteArraySet<DynamicFeature>(parent.getClientDynamicFeatures());
                }
                this.clientDynamicFeatures.add((DynamicFeature)provider);
            }
            newContracts.put(DynamicFeature.class, priority);
        }
        if (Utils.isA(provider, AsyncClientResponseProvider.class, contracts)) {
            try {
                this.addAsyncClientResponseProvider((AsyncClientResponseProvider)provider, provider.getClass(), parent);
                int priority3 = Utils.getPriority(priorityOverride, contracts, AsyncClientResponseProvider.class, provider.getClass());
                newContracts.put(AsyncClientResponseProvider.class, priority3);
            }
            catch (Exception e) {
                throw new RuntimeException(Messages.MESSAGES.unableToInstantiateAsyncClientResponseProvider(), e);
            }
        }
    }

    protected MediaTypeMap<SortedKey<MessageBodyReader>> getClientMessageBodyReaders(ResteasyProviderFactoryImpl parent) {
        if (this.clientMessageBodyReaders == null && parent != null) {
            return parent.getClientMessageBodyReaders();
        }
        return this.clientMessageBodyReaders;
    }

    protected MediaTypeMap<SortedKey<MessageBodyWriter>> getClientMessageBodyWriters(ResteasyProviderFactoryImpl parent) {
        if (this.clientMessageBodyWriters == null && parent != null) {
            return parent.getClientMessageBodyWriters();
        }
        return this.clientMessageBodyWriters;
    }

    protected void addMessageBodyReader(MessageBodyReader provider, Class<?> providerClass, int priority, boolean isBuiltin, ResteasyProviderFactoryImpl parent) {
        SortedKey<MessageBodyReader> key = new SortedKey<MessageBodyReader>(MessageBodyReader.class, provider, providerClass, priority, isBuiltin);
        Utils.injectProperties(this.rpf, providerClass, provider);
        Consumes consumeMime = provider.getClass().getAnnotation(Consumes.class);
        RuntimeType type = null;
        ConstrainedTo constrainedTo = providerClass.getAnnotation(ConstrainedTo.class);
        if (constrainedTo != null) {
            type = constrainedTo.value();
        }
        if ((type == null || type == RuntimeType.CLIENT) && this.clientMessageBodyReaders == null) {
            this.clientMessageBodyReaders = parent.getClientMessageBodyReaders().clone();
        }
        if (consumeMime != null) {
            for (String consume : consumeMime.value()) {
                if (type == null) {
                    this.clientMessageBodyReaders.add(MediaType.valueOf((String)consume), key);
                    continue;
                }
                if (type != RuntimeType.CLIENT) continue;
                this.clientMessageBodyReaders.add(MediaType.valueOf((String)consume), key);
            }
        } else if (type == null) {
            this.clientMessageBodyReaders.add(new MediaType("*", "*"), key);
        } else if (type == RuntimeType.CLIENT) {
            this.clientMessageBodyReaders.add(new MediaType("*", "*"), key);
        }
    }

    protected void addMessageBodyWriter(MessageBodyWriter provider, Class<?> providerClass, int priority, boolean isBuiltin, ResteasyProviderFactoryImpl parent) {
        Utils.injectProperties(this.rpf, providerClass, provider);
        Produces consumeMime = provider.getClass().getAnnotation(Produces.class);
        SortedKey<MessageBodyWriter> key = new SortedKey<MessageBodyWriter>(MessageBodyWriter.class, provider, providerClass, priority, isBuiltin);
        RuntimeType type = null;
        ConstrainedTo constrainedTo = providerClass.getAnnotation(ConstrainedTo.class);
        if (constrainedTo != null) {
            type = constrainedTo.value();
        }
        if ((type == null || type == RuntimeType.CLIENT) && this.clientMessageBodyWriters == null) {
            this.clientMessageBodyWriters = parent.getClientMessageBodyWriters().clone();
        }
        if (consumeMime != null) {
            for (String consume : consumeMime.value()) {
                if (type == null) {
                    this.clientMessageBodyWriters.add(MediaType.valueOf((String)consume), key);
                    continue;
                }
                if (type != RuntimeType.CLIENT) continue;
                this.clientMessageBodyWriters.add(MediaType.valueOf((String)consume), key);
            }
        } else if (type == null) {
            this.clientMessageBodyWriters.add(new MediaType("*", "*"), key);
        } else if (type == RuntimeType.CLIENT) {
            this.clientMessageBodyWriters.add(new MediaType("*", "*"), key);
        }
    }

    private void addAsyncClientResponseProvider(AsyncClientResponseProvider provider, Class providerClass, ResteasyProviderFactory parent) {
        Type asyncType = Types.getActualTypeArgumentsOfAnInterface((Class)providerClass, AsyncClientResponseProvider.class)[0];
        Utils.injectProperties(this.rpf, provider.getClass(), provider);
        Class asyncClass = Types.getRawType((Type)asyncType);
        if (this.asyncClientResponseProviders == null) {
            this.asyncClientResponseProviders = new ConcurrentHashMap();
            this.asyncClientResponseProviders.putAll(parent.getAsyncClientResponseProviders());
        }
        this.asyncClientResponseProviders.put(asyncClass, provider);
    }
}

