/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.resteasy.microprofile.config;

import java.util.Collections;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Map;
import javax.servlet.FilterConfig;
import javax.servlet.ServletContext;
import org.eclipse.microprofile.config.spi.ConfigSource;
import org.jboss.resteasy.core.ResteasyContext;

public class FilterConfigSource
implements ConfigSource {
    private volatile String name;

    public Map<String, String> getProperties() {
        FilterConfig config = ResteasyContext.getContextData(FilterConfig.class);
        if (config == null) {
            return Collections.emptyMap();
        }
        HashMap<String, String> map = new HashMap<String, String>();
        Enumeration keys = config.getInitParameterNames();
        if (keys != null) {
            while (keys.hasMoreElements()) {
                String key = (String)keys.nextElement();
                map.put(key, config.getInitParameter(key));
            }
        }
        return map;
    }

    public String getValue(String propertyName) {
        FilterConfig config = ResteasyContext.getContextData(FilterConfig.class);
        if (config == null) {
            return null;
        }
        return config.getInitParameter(propertyName);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getName() {
        if (this.name == null) {
            FilterConfigSource filterConfigSource = this;
            synchronized (filterConfigSource) {
                if (this.name == null) {
                    ServletContext servletContext = ResteasyContext.getContextData(ServletContext.class);
                    FilterConfig filterConfig = ResteasyContext.getContextData(FilterConfig.class);
                    StringBuilder sb = new StringBuilder();
                    this.name = sb.append(servletContext != null ? servletContext.getServletContextName() : null).append(":").append(filterConfig != null ? filterConfig.getFilterName() : null).append(":FilterConfigSource").toString();
                }
            }
        }
        return this.name;
    }

    public int getOrdinal() {
        return 50;
    }
}

