/*
 * Decompiled with CFR 0.152.
 */
package io.reactiverse.reactivecontexts.core;

import io.reactiverse.reactivecontexts.core.CompletableFutureWrapper;
import io.reactiverse.reactivecontexts.core.CompletionStageWrapper;
import io.reactiverse.reactivecontexts.core.ContextPropagator;
import io.reactiverse.reactivecontexts.core.ContextProvider;
import io.reactiverse.reactivecontexts.core.ContextState;
import java.util.ArrayList;
import java.util.List;
import java.util.ServiceLoader;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import java.util.function.BiConsumer;
import java.util.function.BiFunction;
import java.util.function.Consumer;
import java.util.function.Function;

public class Context {
    private static Context instance = new Context();
    private static ThreadLocal<Context> threadInstance = new ThreadLocal();
    private List<ContextProvider<?>> providers = new ArrayList();
    private List<ContextPropagator> propagators = new ArrayList<ContextPropagator>();

    public static void load() {
    }

    public static Context getInstance() {
        Context ret = threadInstance.get();
        if (ret == null) {
            ret = instance;
        }
        return ret;
    }

    public static Context setThreadInstance(Context instance) {
        Context oldInstance = threadInstance.get();
        threadInstance.set(instance);
        return oldInstance;
    }

    public static void clearThreadInstance() {
        threadInstance.remove();
    }

    public Context() {
        for (ContextProvider listener : ServiceLoader.load(ContextProvider.class)) {
            this.providers.add(listener);
        }
        for (ContextPropagator propagator : ServiceLoader.load(ContextPropagator.class)) {
            this.propagators.add(propagator);
            propagator.setup();
        }
    }

    public static ContextState capture() {
        return Context.getInstance().captureState();
    }

    public ContextState captureState() {
        Object[] ret = new Object[this.providers.size()];
        for (int i = 0; i < this.providers.size(); ++i) {
            ContextProvider<?> plugin = this.providers.get(i);
            ret[i] = plugin.capture();
        }
        return new ContextState(this, ret, threadInstance.get());
    }

    public ContextState install(ContextState state) {
        if (this != state.getContext()) {
            throw new IllegalArgumentException("State was captured with different context");
        }
        Object[] oldStates = new Object[this.providers.size()];
        Object[] states = state.getState();
        for (int i = 0; i < this.providers.size(); ++i) {
            ContextProvider<?> plugin = this.providers.get(i);
            oldStates[i] = plugin.install(states[i]);
        }
        return new ContextState(this, oldStates, Context.setThreadInstance(this));
    }

    public void restore(ContextState state) {
        if (this != state.getContext()) {
            throw new IllegalArgumentException("State was captured with different context");
        }
        Object[] states = state.getState();
        for (int i = 0; i < this.providers.size(); ++i) {
            ContextProvider<?> plugin = this.providers.get(i);
            plugin.restore(states[i]);
        }
        Context previousThreadContext = state.getPreviousThreadContext();
        if (previousThreadContext == null) {
            Context.clearThreadInstance();
        } else {
            Context.setThreadInstance(previousThreadContext);
        }
    }

    public static Runnable wrap(Runnable f) {
        return Context.wrap(Context.capture(), f);
    }

    static Runnable wrap(ContextState state, Runnable f) {
        return () -> {
            ContextState oldState = state.install();
            try {
                f.run();
            }
            finally {
                oldState.restore();
            }
        };
    }

    public static <T> Consumer<T> wrap(Consumer<T> f) {
        return Context.wrap(Context.capture(), f);
    }

    static <T> Consumer<T> wrap(ContextState state, Consumer<T> f) {
        return v -> {
            ContextState oldState = state.install();
            try {
                f.accept(v);
            }
            finally {
                oldState.restore();
            }
        };
    }

    public static <T, U> BiConsumer<T, U> wrap(BiConsumer<T, U> f) {
        return Context.wrap(Context.capture(), f);
    }

    static <T, U> BiConsumer<T, U> wrap(ContextState state, BiConsumer<T, U> f) {
        return (t, u) -> {
            ContextState oldState = state.install();
            try {
                f.accept(t, u);
            }
            finally {
                oldState.restore();
            }
        };
    }

    public static <T, U, V> BiFunction<T, U, V> wrap(BiFunction<T, U, V> fn) {
        return Context.wrap(Context.capture(), fn);
    }

    static <T, U, V> BiFunction<T, U, V> wrap(ContextState state, BiFunction<T, U, V> fn) {
        return (t, u) -> {
            ContextState oldState = state.install();
            try {
                Object r = fn.apply(t, u);
                return r;
            }
            finally {
                oldState.restore();
            }
        };
    }

    public static <T, U> Function<T, U> wrap(Function<T, U> fn) {
        return Context.wrap(Context.capture(), fn);
    }

    static <T, U> Function<T, U> wrap(ContextState state, Function<T, U> fn) {
        return v -> {
            ContextState oldState = state.install();
            try {
                Object r = fn.apply(v);
                return r;
            }
            finally {
                oldState.restore();
            }
        };
    }

    public static <T> CompletableFuture<T> wrap(CompletableFuture<T> f) {
        return Context.wrap(Context.capture(), f);
    }

    static <T> CompletableFuture<T> wrap(ContextState state, CompletableFuture<T> f) {
        return new CompletableFutureWrapper<T>(state, f);
    }

    public static <T> CompletionStage<T> wrap(CompletionStage<T> f) {
        return Context.wrap(Context.capture(), f);
    }

    static <T> CompletionStage<T> wrap(ContextState state, CompletionStage<T> f) {
        return new CompletionStageWrapper<T>(state, f);
    }
}

