/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.resteasy.client.jaxrs.internal;

import java.security.KeyStore;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import javax.net.ssl.HostnameVerifier;
import javax.net.ssl.SSLContext;
import javax.ws.rs.RuntimeType;
import javax.ws.rs.core.Configuration;
import org.apache.http.HttpHost;
import org.apache.http.impl.nio.client.HttpAsyncClients;
import org.jboss.resteasy.client.jaxrs.ClientHttpEngine;
import org.jboss.resteasy.client.jaxrs.ResteasyClient;
import org.jboss.resteasy.client.jaxrs.ResteasyClientBuilder;
import org.jboss.resteasy.client.jaxrs.engines.ApacheHttpAsyncClient4Engine;
import org.jboss.resteasy.client.jaxrs.engines.ClientHttpEngineBuilder43;
import org.jboss.resteasy.client.jaxrs.i18n.LogMessages;
import org.jboss.resteasy.client.jaxrs.i18n.Messages;
import org.jboss.resteasy.client.jaxrs.internal.ClientConfiguration;
import org.jboss.resteasy.client.jaxrs.internal.LocalResteasyProviderFactory;
import org.jboss.resteasy.client.jaxrs.internal.ResteasyClientImpl;
import org.jboss.resteasy.core.providerfactory.ResteasyProviderFactoryImpl;
import org.jboss.resteasy.plugins.providers.RegisterBuiltin;
import org.jboss.resteasy.spi.ResteasyProviderFactory;

public class ResteasyClientBuilderImpl
extends ResteasyClientBuilder {
    protected KeyStore truststore;
    protected KeyStore clientKeyStore;
    protected String clientPrivateKeyPassword;
    protected boolean disableTrustManager;
    protected ResteasyClientBuilder.HostnameVerificationPolicy policy = ResteasyClientBuilder.HostnameVerificationPolicy.WILDCARD;
    protected ResteasyProviderFactory providerFactory;
    protected ExecutorService asyncExecutor;
    protected ScheduledExecutorService scheduledExecutorService;
    protected boolean cleanupExecutor;
    protected SSLContext sslContext;
    protected Map<String, Object> properties = new HashMap<String, Object>();
    protected ClientHttpEngine httpEngine;
    protected int connectionPoolSize = 50;
    protected int maxPooledPerRoute = 0;
    protected long connectionTTL = -1L;
    protected TimeUnit connectionTTLUnit = TimeUnit.MILLISECONDS;
    protected long socketTimeout = -1L;
    protected TimeUnit socketTimeoutUnits = TimeUnit.MILLISECONDS;
    protected long establishConnectionTimeout = -1L;
    protected TimeUnit establishConnectionTimeoutUnits = TimeUnit.MILLISECONDS;
    protected int connectionCheckoutTimeoutMs = -1;
    protected HostnameVerifier verifier = null;
    protected HttpHost defaultProxy;
    protected int responseBufferSize;
    protected List<String> sniHostNames = new ArrayList<String>();
    protected boolean trustSelfSignedCertificates = true;

    public ResteasyClientBuilderImpl providerFactory(ResteasyProviderFactory providerFactory) {
        this.providerFactory = providerFactory;
        return this;
    }

    @Deprecated
    public ResteasyClientBuilderImpl asyncExecutor(ExecutorService asyncExecutor) {
        return this.asyncExecutor(asyncExecutor, false);
    }

    @Deprecated
    public ResteasyClientBuilderImpl asyncExecutor(ExecutorService asyncExecutor, boolean cleanupExecutor) {
        this.asyncExecutor = asyncExecutor;
        this.cleanupExecutor = cleanupExecutor;
        return this;
    }

    public ResteasyClientBuilderImpl connectionTTL(long ttl, TimeUnit unit) {
        this.connectionTTL = ttl;
        this.connectionTTLUnit = unit;
        return this;
    }

    public ResteasyClientBuilderImpl readTimeout(long timeout, TimeUnit unit) {
        this.socketTimeout = timeout;
        this.socketTimeoutUnits = unit;
        return this;
    }

    public ResteasyClientBuilderImpl connectTimeout(long timeout, TimeUnit unit) {
        this.establishConnectionTimeout = timeout;
        this.establishConnectionTimeoutUnits = unit;
        return this;
    }

    public ResteasyClientBuilderImpl maxPooledPerRoute(int maxPooledPerRoute) {
        this.maxPooledPerRoute = maxPooledPerRoute;
        return this;
    }

    public ResteasyClientBuilderImpl connectionCheckoutTimeout(long timeout, TimeUnit unit) {
        this.connectionCheckoutTimeoutMs = (int)TimeUnit.MILLISECONDS.convert(timeout, unit);
        return this;
    }

    public ResteasyClientBuilderImpl connectionPoolSize(int connectionPoolSize) {
        this.connectionPoolSize = connectionPoolSize;
        return this;
    }

    public ResteasyClientBuilderImpl responseBufferSize(int size) {
        this.responseBufferSize = size;
        return this;
    }

    public ResteasyClientBuilderImpl disableTrustManager() {
        this.disableTrustManager = true;
        return this;
    }

    public ResteasyClientBuilderImpl hostnameVerification(ResteasyClientBuilder.HostnameVerificationPolicy policy) {
        this.policy = policy;
        return this;
    }

    public ResteasyClientBuilderImpl httpEngine(ClientHttpEngine httpEngine) {
        this.httpEngine = httpEngine;
        return this;
    }

    public ResteasyClientBuilderImpl useAsyncHttpEngine() {
        this.httpEngine = new ApacheHttpAsyncClient4Engine(HttpAsyncClients.createSystem(), true);
        return this;
    }

    public ResteasyClientBuilderImpl sslContext(SSLContext sslContext) {
        this.sslContext = sslContext;
        return this;
    }

    public ResteasyClientBuilderImpl trustStore(KeyStore truststore) {
        this.truststore = truststore;
        return this;
    }

    public ResteasyClientBuilderImpl keyStore(KeyStore keyStore, String password) {
        this.clientKeyStore = keyStore;
        this.clientPrivateKeyPassword = password;
        return this;
    }

    public ResteasyClientBuilderImpl keyStore(KeyStore keyStore, char[] password) {
        this.clientKeyStore = keyStore;
        this.clientPrivateKeyPassword = new String(password);
        return this;
    }

    public ResteasyClientBuilderImpl property(String name, Object value) {
        this.getProviderFactory().property(name, value);
        return this;
    }

    public ResteasyClientBuilderImpl sniHostNames(String ... sniHostNames) {
        this.sniHostNames.addAll(Arrays.asList(sniHostNames));
        return this;
    }

    public ResteasyClientBuilderImpl defaultProxy(String hostname) {
        return this.defaultProxy(hostname, -1, null);
    }

    public ResteasyClientBuilderImpl defaultProxy(String hostname, int port) {
        return this.defaultProxy(hostname, port, null);
    }

    public ResteasyClientBuilderImpl defaultProxy(String hostname, int port, String scheme) {
        this.defaultProxy = hostname != null ? new HttpHost(hostname, port, scheme) : null;
        return this;
    }

    public ResteasyProviderFactory getProviderFactory() {
        if (this.providerFactory == null) {
            this.providerFactory = new LocalResteasyProviderFactory(RegisterBuiltin.getClientInitializedResteasyProviderFactory((ClassLoader)Thread.currentThread().getContextClassLoader()));
            if (ResteasyProviderFactory.peekInstance() != null) {
                this.providerFactory.initializeClientProviders(ResteasyProviderFactory.getInstance());
            }
        }
        return this.providerFactory;
    }

    public ResteasyClient build() {
        ClientHttpEngine engine;
        ClientConfiguration config = new ClientConfiguration(this.getProviderFactory());
        for (Map.Entry<String, Object> entry : this.properties.entrySet()) {
            config.property(entry.getKey(), entry.getValue());
        }
        ExecutorService executor = this.asyncExecutor;
        if (executor == null) {
            this.cleanupExecutor = true;
            executor = Executors.newCachedThreadPool();
        }
        boolean resetProxy = false;
        if (this.defaultProxy == null) {
            resetProxy = true;
            this.setProxyIfNeeded(config);
        }
        ClientHttpEngine clientHttpEngine = engine = this.httpEngine != null ? this.httpEngine : new ClientHttpEngineBuilder43().resteasyClientBuilder(this).build();
        if (resetProxy) {
            this.defaultProxy = null;
        }
        return this.createResteasyClient(engine, executor, this.cleanupExecutor, this.scheduledExecutorService, config);
    }

    private void setProxyIfNeeded(ClientConfiguration clientConfig) {
        try {
            Object proxyHostProp = clientConfig.getProperty("org.jboss.resteasy.jaxrs.client.proxy.host");
            if (proxyHostProp != null) {
                Object proxyPortProp = clientConfig.getProperty("org.jboss.resteasy.jaxrs.client.proxy.port");
                Integer proxyPort = -1;
                if (proxyPortProp != null && proxyPortProp instanceof Number) {
                    proxyPort = ((Number)proxyPortProp).intValue();
                } else if (proxyPortProp != null && proxyPortProp instanceof String) {
                    proxyPort = Integer.parseInt((String)proxyPortProp);
                }
                Object proxySchemeProp = clientConfig.getProperty("org.jboss.resteasy.jaxrs.client.proxy.scheme");
                this.defaultProxy((String)proxyHostProp, proxyPort, (String)proxySchemeProp);
            }
        }
        catch (Exception e) {
            LogMessages.LOGGER.warn((Object)Messages.MESSAGES.unableToSetHttpProxy(), (Throwable)e);
        }
    }

    protected ResteasyClient createResteasyClient(ClientHttpEngine engine, ExecutorService executor, boolean cleanupExecutor, ScheduledExecutorService scheduledExecutorService, ClientConfiguration config) {
        return new ResteasyClientImpl(engine, executor, cleanupExecutor, scheduledExecutorService, config);
    }

    public ResteasyClientBuilderImpl hostnameVerifier(HostnameVerifier verifier) {
        this.verifier = verifier;
        return this;
    }

    public Configuration getConfiguration() {
        return this.getProviderFactory().getConfiguration();
    }

    public ResteasyClientBuilderImpl register(Class<?> componentClass) {
        this.getProviderFactory().register(componentClass);
        return this;
    }

    public ResteasyClientBuilderImpl register(Class<?> componentClass, int priority) {
        this.getProviderFactory().register(componentClass, priority);
        return this;
    }

    public ResteasyClientBuilderImpl register(Class<?> componentClass, Class<?> ... contracts) {
        this.getProviderFactory().register(componentClass, (Class[])contracts);
        return this;
    }

    public ResteasyClientBuilderImpl register(Class<?> componentClass, Map<Class<?>, Integer> contracts) {
        this.getProviderFactory().register(componentClass, contracts);
        return this;
    }

    public ResteasyClientBuilderImpl register(Object component) {
        this.getProviderFactory().register(component);
        return this;
    }

    public ResteasyClientBuilderImpl register(Object component, int priority) {
        this.getProviderFactory().register(component, priority);
        return this;
    }

    public ResteasyClientBuilderImpl register(Object component, Class<?> ... contracts) {
        this.getProviderFactory().register(component, (Class[])contracts);
        return this;
    }

    public ResteasyClientBuilderImpl register(Object component, Map<Class<?>, Integer> contracts) {
        this.getProviderFactory().register(component, contracts);
        return this;
    }

    public ResteasyClientBuilderImpl withConfig(Configuration config) {
        Map contracts;
        this.providerFactory = new ResteasyProviderFactoryImpl(){

            public RuntimeType getRuntimeType() {
                return RuntimeType.CLIENT;
            }
        };
        this.providerFactory.setProperties(config.getProperties());
        for (Class clazz : config.getClasses()) {
            contracts = config.getContracts(clazz);
            try {
                this.register(clazz, contracts);
            }
            catch (RuntimeException e) {
                throw new RuntimeException(Messages.MESSAGES.failedOnRegisteringClass(clazz.getName()), e);
            }
        }
        for (Object obj : config.getInstances()) {
            contracts = config.getContracts(obj.getClass());
            this.register(obj, contracts);
        }
        return this;
    }

    public ResteasyClientBuilder executorService(ExecutorService executorService) {
        return this.asyncExecutor(executorService, false);
    }

    public ResteasyClientBuilder scheduledExecutorService(ScheduledExecutorService scheduledExecutorService) {
        this.scheduledExecutorService = scheduledExecutorService;
        return this;
    }

    public long getConnectionTTL(TimeUnit unit) {
        return this.connectionTTLUnit.equals((Object)unit) ? this.connectionTTL : unit.convert(this.connectionTTL, this.connectionTTLUnit);
    }

    public int getMaxPooledPerRoute() {
        return this.maxPooledPerRoute;
    }

    public long getConnectionCheckoutTimeout(TimeUnit unit) {
        return TimeUnit.MILLISECONDS.equals((Object)unit) ? (long)this.connectionCheckoutTimeoutMs : unit.convert(this.connectionCheckoutTimeoutMs, TimeUnit.MILLISECONDS);
    }

    public int getConnectionPoolSize() {
        return this.connectionPoolSize;
    }

    public int getResponseBufferSize() {
        return this.responseBufferSize;
    }

    public boolean isTrustManagerDisabled() {
        return this.disableTrustManager;
    }

    public boolean isTrustSelfSignedCertificates() {
        return this.trustSelfSignedCertificates;
    }

    public void setIsTrustSelfSignedCertificates(boolean b) {
        this.trustSelfSignedCertificates = b;
    }

    public ResteasyClientBuilder.HostnameVerificationPolicy getHostnameVerification() {
        return this.policy;
    }

    public ClientHttpEngine getHttpEngine() {
        return this.httpEngine;
    }

    public boolean isUseAsyncHttpEngine() {
        return this.httpEngine != null && this.httpEngine instanceof ApacheHttpAsyncClient4Engine;
    }

    public List<String> getSniHostNames() {
        return this.sniHostNames;
    }

    public String getDefaultProxyHostname() {
        return this.defaultProxy != null ? this.defaultProxy.getHostName() : null;
    }

    public int getDefaultProxyPort() {
        return this.defaultProxy != null ? this.defaultProxy.getPort() : -1;
    }

    public String getDefaultProxyScheme() {
        return this.defaultProxy != null ? this.defaultProxy.getSchemeName() : null;
    }

    public long getReadTimeout(TimeUnit unit) {
        return this.socketTimeoutUnits.equals((Object)unit) ? this.socketTimeout : unit.convert(this.socketTimeout, this.socketTimeoutUnits);
    }

    public long getConnectionTimeout(TimeUnit unit) {
        return this.establishConnectionTimeoutUnits.equals((Object)unit) ? this.establishConnectionTimeout : unit.convert(this.establishConnectionTimeout, this.establishConnectionTimeoutUnits);
    }

    public SSLContext getSSLContext() {
        return this.sslContext;
    }

    public KeyStore getKeyStore() {
        return this.clientKeyStore;
    }

    public String getKeyStorePassword() {
        return this.clientPrivateKeyPassword;
    }

    public KeyStore getTrustStore() {
        return this.truststore;
    }

    public HostnameVerifier getHostnameVerifier() {
        return this.verifier;
    }
}

