/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.resteasy.core.providerfactory;

import java.lang.reflect.Type;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.CopyOnWriteArraySet;
import javax.ws.rs.ConstrainedTo;
import javax.ws.rs.Consumes;
import javax.ws.rs.Produces;
import javax.ws.rs.RuntimeType;
import javax.ws.rs.container.ContainerRequestFilter;
import javax.ws.rs.container.ContainerResponseFilter;
import javax.ws.rs.container.DynamicFeature;
import javax.ws.rs.core.MediaType;
import javax.ws.rs.ext.MessageBodyReader;
import javax.ws.rs.ext.MessageBodyWriter;
import javax.ws.rs.ext.ReaderInterceptor;
import javax.ws.rs.ext.WriterInterceptor;
import org.jboss.resteasy.core.MediaTypeMap;
import org.jboss.resteasy.core.interception.jaxrs.ContainerRequestFilterRegistryImpl;
import org.jboss.resteasy.core.interception.jaxrs.ContainerResponseFilterRegistryImpl;
import org.jboss.resteasy.core.interception.jaxrs.ReaderInterceptorRegistryImpl;
import org.jboss.resteasy.core.interception.jaxrs.WriterInterceptorRegistryImpl;
import org.jboss.resteasy.core.providerfactory.ResteasyProviderFactoryImpl;
import org.jboss.resteasy.core.providerfactory.SortedKey;
import org.jboss.resteasy.core.providerfactory.Utils;
import org.jboss.resteasy.resteasy_jaxrs.i18n.Messages;
import org.jboss.resteasy.spi.AsyncResponseProvider;
import org.jboss.resteasy.spi.AsyncStreamProvider;
import org.jboss.resteasy.spi.ResteasyProviderFactory;
import org.jboss.resteasy.spi.interception.JaxrsInterceptorRegistry;
import org.jboss.resteasy.spi.util.Types;

public class ServerHelper {
    private final ResteasyProviderFactoryImpl rpf;
    private MediaTypeMap<SortedKey<MessageBodyReader>> serverMessageBodyReaders;
    private MediaTypeMap<SortedKey<MessageBodyWriter>> serverMessageBodyWriters;
    private JaxrsInterceptorRegistry<ContainerRequestFilter> containerRequestFilterRegistry;
    private JaxrsInterceptorRegistry<ContainerResponseFilter> containerResponseFilterRegistry;
    private JaxrsInterceptorRegistry<ReaderInterceptor> serverReaderInterceptorRegistry;
    private JaxrsInterceptorRegistry<WriterInterceptor> serverWriterInterceptorRegistry;
    private Set<DynamicFeature> serverDynamicFeatures;
    private Map<Class<?>, AsyncResponseProvider> asyncResponseProviders;
    private Map<Class<?>, AsyncStreamProvider> asyncStreamProviders;

    public ServerHelper(ResteasyProviderFactoryImpl rpf) {
        this.rpf = rpf;
    }

    protected void initialize(ResteasyProviderFactoryImpl parent) {
        this.serverDynamicFeatures = parent == null ? new CopyOnWriteArraySet<DynamicFeature>() : new CopyOnWriteArraySet<DynamicFeature>(parent.getServerDynamicFeatures());
        this.asyncResponseProviders = parent == null ? new ConcurrentHashMap(4) : new ConcurrentHashMap(parent.getAsyncResponseProviders());
        this.asyncStreamProviders = parent == null ? new ConcurrentHashMap(4) : new ConcurrentHashMap(parent.getAsyncStreamProviders());
        this.serverMessageBodyReaders = parent == null ? new MediaTypeMap() : parent.getServerMessageBodyReaders().clone();
        this.serverMessageBodyWriters = parent == null ? new MediaTypeMap() : parent.getServerMessageBodyWriters().clone();
        this.containerRequestFilterRegistry = parent == null ? new ContainerRequestFilterRegistryImpl(this.rpf) : parent.getContainerRequestFilterRegistry().clone((ResteasyProviderFactory)this.rpf);
        this.containerResponseFilterRegistry = parent == null ? new ContainerResponseFilterRegistryImpl(this.rpf) : parent.getContainerResponseFilterRegistry().clone((ResteasyProviderFactory)this.rpf);
        this.serverReaderInterceptorRegistry = parent == null ? new ReaderInterceptorRegistryImpl(this.rpf) : parent.getServerReaderInterceptorRegistry().clone((ResteasyProviderFactory)this.rpf);
        this.serverWriterInterceptorRegistry = parent == null ? new WriterInterceptorRegistryImpl(this.rpf) : parent.getServerWriterInterceptorRegistry().clone((ResteasyProviderFactory)this.rpf);
    }

    protected JaxrsInterceptorRegistry<ReaderInterceptor> getServerReaderInterceptorRegistry(ResteasyProviderFactory parent) {
        if (this.serverReaderInterceptorRegistry == null && parent != null) {
            return parent.getServerReaderInterceptorRegistry();
        }
        return this.serverReaderInterceptorRegistry;
    }

    protected JaxrsInterceptorRegistry<WriterInterceptor> getServerWriterInterceptorRegistry(ResteasyProviderFactory parent) {
        if (this.serverWriterInterceptorRegistry == null && parent != null) {
            return parent.getServerWriterInterceptorRegistry();
        }
        return this.serverWriterInterceptorRegistry;
    }

    protected JaxrsInterceptorRegistry<ContainerRequestFilter> getContainerRequestFilterRegistry(ResteasyProviderFactory parent) {
        if (this.containerRequestFilterRegistry == null && parent != null) {
            return parent.getContainerRequestFilterRegistry();
        }
        return this.containerRequestFilterRegistry;
    }

    protected JaxrsInterceptorRegistry<ContainerResponseFilter> getContainerResponseFilterRegistry(ResteasyProviderFactory parent) {
        if (this.containerResponseFilterRegistry == null && parent != null) {
            return parent.getContainerResponseFilterRegistry();
        }
        return this.containerResponseFilterRegistry;
    }

    protected Set<DynamicFeature> getServerDynamicFeatures(ResteasyProviderFactory parent) {
        if (this.serverDynamicFeatures == null && parent != null) {
            return parent.getServerDynamicFeatures();
        }
        return this.serverDynamicFeatures;
    }

    protected Map<Class<?>, AsyncResponseProvider> getAsyncResponseProviders(ResteasyProviderFactory parent) {
        if (this.asyncResponseProviders == null && parent != null) {
            return parent.getAsyncResponseProviders();
        }
        return this.asyncResponseProviders;
    }

    protected Map<Class<?>, AsyncStreamProvider> getAsyncStreamProviders(ResteasyProviderFactory parent) {
        if (this.asyncStreamProviders == null && parent != null) {
            return parent.getAsyncStreamProviders();
        }
        return this.asyncStreamProviders;
    }

    protected void processProviderContracts(Class provider, Integer priorityOverride, boolean isBuiltin, Map<Class<?>, Integer> contracts, Map<Class<?>, Integer> newContracts, ResteasyProviderFactoryImpl parent) {
        int priority;
        int priority2;
        if (Utils.isA(provider, MessageBodyReader.class, contracts)) {
            try {
                priority2 = Utils.getPriority(priorityOverride, contracts, MessageBodyReader.class, provider);
                this.addMessageBodyReader((MessageBodyReader)Utils.createProviderInstance(this.rpf, provider), provider, priority2, isBuiltin, parent);
                newContracts.put(MessageBodyReader.class, priority2);
            }
            catch (Exception e) {
                throw new RuntimeException(Messages.MESSAGES.unableToInstantiateMessageBodyReader(), e);
            }
        }
        if (Utils.isA(provider, MessageBodyWriter.class, contracts)) {
            try {
                priority2 = Utils.getPriority(priorityOverride, contracts, MessageBodyWriter.class, provider);
                this.addMessageBodyWriter((MessageBodyWriter)Utils.createProviderInstance(this.rpf, provider), provider, priority2, isBuiltin, parent);
                newContracts.put(MessageBodyWriter.class, priority2);
            }
            catch (Exception e) {
                throw new RuntimeException(Messages.MESSAGES.unableToInstantiateMessageBodyWriter(), e);
            }
        }
        if (Utils.isA(provider, ContainerRequestFilter.class, contracts)) {
            if (this.containerRequestFilterRegistry == null) {
                this.containerRequestFilterRegistry = parent.getContainerRequestFilterRegistry().clone((ResteasyProviderFactory)this.rpf);
            }
            priority2 = Utils.getPriority(priorityOverride, contracts, ContainerRequestFilter.class, provider);
            this.containerRequestFilterRegistry.registerClass(provider, priority2);
            newContracts.put(ContainerRequestFilter.class, priority2);
        }
        if (Utils.isA(provider, ContainerResponseFilter.class, contracts)) {
            if (this.containerResponseFilterRegistry == null) {
                this.containerResponseFilterRegistry = parent.getContainerResponseFilterRegistry().clone((ResteasyProviderFactory)this.rpf);
            }
            priority2 = Utils.getPriority(priorityOverride, contracts, ContainerResponseFilter.class, provider);
            this.containerResponseFilterRegistry.registerClass(provider, priority2);
            newContracts.put(ContainerResponseFilter.class, priority2);
        }
        if (Utils.isA(provider, ReaderInterceptor.class, contracts)) {
            ConstrainedTo constrainedTo = provider.getAnnotation(ConstrainedTo.class);
            priority = Utils.getPriority(priorityOverride, contracts, ReaderInterceptor.class, provider);
            if (constrainedTo != null && constrainedTo.value() == RuntimeType.SERVER) {
                if (this.serverReaderInterceptorRegistry == null) {
                    this.serverReaderInterceptorRegistry = parent.getServerReaderInterceptorRegistry().clone((ResteasyProviderFactory)this.rpf);
                }
                this.serverReaderInterceptorRegistry.registerClass(provider, priority);
            }
            if (constrainedTo == null) {
                if (this.serverReaderInterceptorRegistry == null) {
                    this.serverReaderInterceptorRegistry = parent.getServerReaderInterceptorRegistry().clone((ResteasyProviderFactory)this.rpf);
                }
                this.serverReaderInterceptorRegistry.registerClass(provider, priority);
            }
            newContracts.put(ReaderInterceptor.class, priority);
        }
        if (Utils.isA(provider, WriterInterceptor.class, contracts)) {
            ConstrainedTo constrainedTo = provider.getAnnotation(ConstrainedTo.class);
            priority = Utils.getPriority(priorityOverride, contracts, WriterInterceptor.class, provider);
            if (constrainedTo != null && constrainedTo.value() == RuntimeType.SERVER) {
                if (this.serverWriterInterceptorRegistry == null) {
                    this.serverWriterInterceptorRegistry = parent.getServerWriterInterceptorRegistry().clone((ResteasyProviderFactory)this.rpf);
                }
                this.serverWriterInterceptorRegistry.registerClass(provider, priority);
            }
            if (constrainedTo == null) {
                if (this.serverWriterInterceptorRegistry == null) {
                    this.serverWriterInterceptorRegistry = parent.getServerWriterInterceptorRegistry().clone((ResteasyProviderFactory)this.rpf);
                }
                this.serverWriterInterceptorRegistry.registerClass(provider, priority);
            }
            newContracts.put(WriterInterceptor.class, priority);
        }
        if (Utils.isA(provider, DynamicFeature.class, contracts)) {
            ConstrainedTo constrainedTo = provider.getAnnotation(ConstrainedTo.class);
            priority = Utils.getPriority(priorityOverride, contracts, DynamicFeature.class, provider);
            if (constrainedTo != null && constrainedTo.value() == RuntimeType.SERVER) {
                if (this.serverDynamicFeatures == null) {
                    this.serverDynamicFeatures = new CopyOnWriteArraySet<DynamicFeature>(parent.getServerDynamicFeatures());
                }
                this.serverDynamicFeatures.add((DynamicFeature)this.rpf.injectedInstance(provider));
            }
            if (constrainedTo == null) {
                if (this.serverDynamicFeatures == null) {
                    this.serverDynamicFeatures = new CopyOnWriteArraySet<DynamicFeature>(parent.getServerDynamicFeatures());
                }
                this.serverDynamicFeatures.add((DynamicFeature)this.rpf.injectedInstance(provider));
            }
            newContracts.put(DynamicFeature.class, priority);
        }
        if (Utils.isA(provider, AsyncResponseProvider.class, contracts)) {
            try {
                this.addAsyncResponseProvider((AsyncResponseProvider)this.rpf.createProviderInstance(provider), provider, parent);
                newContracts.put(AsyncResponseProvider.class, Utils.getPriority(priorityOverride, contracts, AsyncResponseProvider.class, provider));
            }
            catch (Exception e) {
                throw new RuntimeException(Messages.MESSAGES.unableToInstantiateAsyncResponseProvider(), e);
            }
        }
        if (Utils.isA(provider, AsyncStreamProvider.class, contracts)) {
            try {
                this.addAsyncStreamProvider((AsyncStreamProvider)this.rpf.createProviderInstance(provider), provider, parent);
                newContracts.put(AsyncStreamProvider.class, Utils.getPriority(priorityOverride, contracts, AsyncStreamProvider.class, provider));
            }
            catch (Exception e) {
                throw new RuntimeException(Messages.MESSAGES.unableToInstantiateAsyncStreamProvider(), e);
            }
        }
    }

    protected void processProviderInstanceContracts(Object provider, Map<Class<?>, Integer> contracts, Integer priorityOverride, boolean builtIn, Map<Class<?>, Integer> newContracts, ResteasyProviderFactoryImpl parent) {
        int priority;
        int priority2;
        if (Utils.isA(provider, MessageBodyReader.class, contracts)) {
            try {
                priority2 = Utils.getPriority(priorityOverride, contracts, MessageBodyReader.class, provider.getClass());
                this.addMessageBodyReader((MessageBodyReader)provider, provider.getClass(), priority2, builtIn, parent);
                newContracts.put(MessageBodyReader.class, priority2);
            }
            catch (Exception e) {
                throw new RuntimeException(Messages.MESSAGES.unableToInstantiateMessageBodyReader(), e);
            }
        }
        if (Utils.isA(provider, MessageBodyWriter.class, contracts)) {
            try {
                priority2 = Utils.getPriority(priorityOverride, contracts, MessageBodyWriter.class, provider.getClass());
                this.addMessageBodyWriter((MessageBodyWriter)provider, provider.getClass(), priority2, builtIn, parent);
                newContracts.put(MessageBodyWriter.class, priority2);
            }
            catch (Exception e) {
                throw new RuntimeException(Messages.MESSAGES.unableToInstantiateMessageBodyWriter(), e);
            }
        }
        if (Utils.isA(provider, ContainerRequestFilter.class, contracts)) {
            if (this.containerRequestFilterRegistry == null) {
                this.containerRequestFilterRegistry = parent.getContainerRequestFilterRegistry().clone((ResteasyProviderFactory)this.rpf);
            }
            priority2 = Utils.getPriority(priorityOverride, contracts, ContainerRequestFilter.class, provider.getClass());
            this.containerRequestFilterRegistry.registerSingleton((Object)((ContainerRequestFilter)provider), priority2);
            newContracts.put(ContainerRequestFilter.class, priority2);
        }
        if (Utils.isA(provider, ContainerResponseFilter.class, contracts)) {
            if (this.containerResponseFilterRegistry == null) {
                this.containerResponseFilterRegistry = parent.getContainerResponseFilterRegistry().clone((ResteasyProviderFactory)this.rpf);
            }
            priority2 = Utils.getPriority(priorityOverride, contracts, ContainerResponseFilter.class, provider.getClass());
            this.containerResponseFilterRegistry.registerSingleton((Object)((ContainerResponseFilter)provider), priority2);
            newContracts.put(ContainerResponseFilter.class, priority2);
        }
        if (Utils.isA(provider, ReaderInterceptor.class, contracts)) {
            ConstrainedTo constrainedTo = provider.getClass().getAnnotation(ConstrainedTo.class);
            priority = Utils.getPriority(priorityOverride, contracts, ReaderInterceptor.class, provider.getClass());
            if (constrainedTo != null && constrainedTo.value() == RuntimeType.SERVER) {
                if (this.serverReaderInterceptorRegistry == null) {
                    this.serverReaderInterceptorRegistry = parent.getServerReaderInterceptorRegistry().clone((ResteasyProviderFactory)this.rpf);
                }
                this.serverReaderInterceptorRegistry.registerSingleton((Object)((ReaderInterceptor)provider), priority);
            }
            if (constrainedTo == null) {
                if (this.serverReaderInterceptorRegistry == null) {
                    this.serverReaderInterceptorRegistry = parent.getServerReaderInterceptorRegistry().clone((ResteasyProviderFactory)this.rpf);
                }
                this.serverReaderInterceptorRegistry.registerSingleton((Object)((ReaderInterceptor)provider), priority);
            }
            newContracts.put(ReaderInterceptor.class, priority);
        }
        if (Utils.isA(provider, WriterInterceptor.class, contracts)) {
            ConstrainedTo constrainedTo = provider.getClass().getAnnotation(ConstrainedTo.class);
            priority = Utils.getPriority(priorityOverride, contracts, WriterInterceptor.class, provider.getClass());
            if (constrainedTo != null && constrainedTo.value() == RuntimeType.SERVER) {
                if (this.serverWriterInterceptorRegistry == null) {
                    this.serverWriterInterceptorRegistry = parent.getServerWriterInterceptorRegistry().clone((ResteasyProviderFactory)this.rpf);
                }
                this.serverWriterInterceptorRegistry.registerSingleton((Object)((WriterInterceptor)provider), priority);
            }
            if (constrainedTo == null) {
                if (this.serverWriterInterceptorRegistry == null) {
                    this.serverWriterInterceptorRegistry = parent.getServerWriterInterceptorRegistry().clone((ResteasyProviderFactory)this.rpf);
                }
                this.serverWriterInterceptorRegistry.registerSingleton((Object)((WriterInterceptor)provider), priority);
            }
            newContracts.put(WriterInterceptor.class, priority);
        }
        if (Utils.isA(provider, DynamicFeature.class, contracts)) {
            ConstrainedTo constrainedTo = provider.getClass().getAnnotation(ConstrainedTo.class);
            priority = Utils.getPriority(priorityOverride, contracts, DynamicFeature.class, provider.getClass());
            if (constrainedTo != null && constrainedTo.value() == RuntimeType.SERVER) {
                if (this.serverDynamicFeatures == null) {
                    this.serverDynamicFeatures = new CopyOnWriteArraySet<DynamicFeature>(parent.getServerDynamicFeatures());
                }
                this.serverDynamicFeatures.add((DynamicFeature)provider);
            }
            if (constrainedTo == null) {
                if (this.serverDynamicFeatures == null) {
                    this.serverDynamicFeatures = new CopyOnWriteArraySet<DynamicFeature>(parent.getServerDynamicFeatures());
                }
                this.serverDynamicFeatures.add((DynamicFeature)provider);
            }
            newContracts.put(DynamicFeature.class, priority);
        }
        if (Utils.isA(provider, AsyncResponseProvider.class, contracts)) {
            try {
                this.addAsyncResponseProvider((AsyncResponseProvider)provider, provider.getClass(), parent);
                int priority3 = Utils.getPriority(priorityOverride, contracts, AsyncResponseProvider.class, provider.getClass());
                newContracts.put(AsyncResponseProvider.class, priority3);
            }
            catch (Exception e) {
                throw new RuntimeException(Messages.MESSAGES.unableToInstantiateAsyncResponseProvider(), e);
            }
        }
        if (Utils.isA(provider, AsyncStreamProvider.class, contracts)) {
            try {
                this.addAsyncStreamProvider((AsyncStreamProvider)provider, provider.getClass(), parent);
                int priority4 = Utils.getPriority(priorityOverride, contracts, AsyncStreamProvider.class, provider.getClass());
                newContracts.put(AsyncStreamProvider.class, priority4);
            }
            catch (Exception e) {
                throw new RuntimeException(Messages.MESSAGES.unableToInstantiateAsyncStreamProvider(), e);
            }
        }
    }

    protected MediaTypeMap<SortedKey<MessageBodyReader>> getServerMessageBodyReaders(ResteasyProviderFactoryImpl parent) {
        if (this.serverMessageBodyReaders == null && parent != null) {
            return parent.getServerMessageBodyReaders();
        }
        return this.serverMessageBodyReaders;
    }

    protected MediaTypeMap<SortedKey<MessageBodyWriter>> getServerMessageBodyWriters(ResteasyProviderFactoryImpl parent) {
        if (this.serverMessageBodyWriters == null && parent != null) {
            return parent.getServerMessageBodyWriters();
        }
        return this.serverMessageBodyWriters;
    }

    protected void addMessageBodyReader(MessageBodyReader provider, Class<?> providerClass, int priority, boolean isBuiltin, ResteasyProviderFactoryImpl parent) {
        SortedKey<MessageBodyReader> key = new SortedKey<MessageBodyReader>(MessageBodyReader.class, provider, providerClass, priority, isBuiltin);
        Utils.injectProperties(this.rpf, providerClass, provider);
        Consumes consumeMime = provider.getClass().getAnnotation(Consumes.class);
        RuntimeType type = null;
        ConstrainedTo constrainedTo = providerClass.getAnnotation(ConstrainedTo.class);
        if (constrainedTo != null) {
            type = constrainedTo.value();
        }
        if ((type == null || type == RuntimeType.SERVER) && this.serverMessageBodyReaders == null) {
            this.serverMessageBodyReaders = parent.getServerMessageBodyReaders().clone();
        }
        if (consumeMime != null) {
            for (String consume : consumeMime.value()) {
                if (type == null) {
                    this.serverMessageBodyReaders.add(MediaType.valueOf((String)consume), key);
                    continue;
                }
                if (type != RuntimeType.SERVER) continue;
                this.serverMessageBodyReaders.add(MediaType.valueOf((String)consume), key);
            }
        } else if (type == null) {
            this.serverMessageBodyReaders.add(new MediaType("*", "*"), key);
        } else if (type == RuntimeType.SERVER) {
            this.serverMessageBodyReaders.add(new MediaType("*", "*"), key);
        }
    }

    protected void addMessageBodyWriter(MessageBodyWriter provider, Class<?> providerClass, int priority, boolean isBuiltin, ResteasyProviderFactoryImpl parent) {
        Utils.injectProperties(this.rpf, providerClass, provider);
        Produces consumeMime = provider.getClass().getAnnotation(Produces.class);
        SortedKey<MessageBodyWriter> key = new SortedKey<MessageBodyWriter>(MessageBodyWriter.class, provider, providerClass, priority, isBuiltin);
        RuntimeType type = null;
        ConstrainedTo constrainedTo = providerClass.getAnnotation(ConstrainedTo.class);
        if (constrainedTo != null) {
            type = constrainedTo.value();
        }
        if ((type == null || type == RuntimeType.SERVER) && this.serverMessageBodyWriters == null) {
            this.serverMessageBodyWriters = parent.getServerMessageBodyWriters().clone();
        }
        if (consumeMime != null) {
            for (String consume : consumeMime.value()) {
                if (type == null) {
                    this.serverMessageBodyWriters.add(MediaType.valueOf((String)consume), key);
                    continue;
                }
                if (type != RuntimeType.SERVER) continue;
                this.serverMessageBodyWriters.add(MediaType.valueOf((String)consume), key);
            }
        } else if (type == null) {
            this.serverMessageBodyWriters.add(new MediaType("*", "*"), key);
        } else if (type == RuntimeType.SERVER) {
            this.serverMessageBodyWriters.add(new MediaType("*", "*"), key);
        }
    }

    private void addAsyncResponseProvider(AsyncResponseProvider provider, Class providerClass, ResteasyProviderFactory parent) {
        Type asyncType = Types.getActualTypeArgumentsOfAnInterface((Class)providerClass, AsyncResponseProvider.class)[0];
        Utils.injectProperties(this.rpf, provider.getClass(), provider);
        Class asyncClass = Types.getRawType((Type)asyncType);
        if (this.asyncResponseProviders == null) {
            this.asyncResponseProviders = new ConcurrentHashMap();
            this.asyncResponseProviders.putAll(parent.getAsyncResponseProviders());
        }
        this.asyncResponseProviders.put(asyncClass, provider);
    }

    private void addAsyncStreamProvider(AsyncStreamProvider provider, Class providerClass, ResteasyProviderFactory parent) {
        Type asyncType = Types.getActualTypeArgumentsOfAnInterface((Class)providerClass, AsyncStreamProvider.class)[0];
        Utils.injectProperties(this.rpf, provider.getClass(), provider);
        Class asyncClass = Types.getRawType((Type)asyncType);
        if (this.asyncStreamProviders == null) {
            this.asyncStreamProviders = new ConcurrentHashMap();
            this.asyncStreamProviders.putAll(parent.getAsyncStreamProviders());
        }
        this.asyncStreamProviders.put(asyncClass, provider);
    }
}

