/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.resteasy.microprofile.config;

import java.util.Collections;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Map;
import javax.servlet.ServletConfig;
import javax.servlet.ServletContext;
import org.eclipse.microprofile.config.spi.ConfigSource;
import org.jboss.resteasy.core.ResteasyContext;

public class ServletConfigSource
implements ConfigSource {
    private static final boolean SERVLET_AVAILABLE;
    private volatile String name;

    public Map<String, String> getProperties() {
        if (!SERVLET_AVAILABLE) {
            return Collections.emptyMap();
        }
        ServletConfig config = ResteasyContext.getContextData(ServletConfig.class);
        if (config == null) {
            return Collections.emptyMap();
        }
        HashMap<String, String> map = new HashMap<String, String>();
        Enumeration keys = config.getInitParameterNames();
        if (keys != null) {
            while (keys.hasMoreElements()) {
                String key = (String)keys.nextElement();
                map.put(key, config.getInitParameter(key));
            }
        }
        return map;
    }

    public String getValue(String propertyName) {
        if (!SERVLET_AVAILABLE) {
            return null;
        }
        ServletConfig config = ResteasyContext.getContextData(ServletConfig.class);
        if (config == null) {
            return null;
        }
        return config.getInitParameter(propertyName);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getName() {
        if (this.name == null) {
            ServletConfigSource servletConfigSource = this;
            synchronized (servletConfigSource) {
                if (this.name == null) {
                    if (!SERVLET_AVAILABLE) {
                        this.name = this.toString();
                    }
                    ServletContext servletContext = ResteasyContext.getContextData(ServletContext.class);
                    ServletConfig servletConfig = ResteasyContext.getContextData(ServletConfig.class);
                    StringBuilder sb = new StringBuilder();
                    this.name = sb.append(servletContext != null ? servletContext.getServletContextName() : null).append(":").append(servletConfig != null ? servletConfig.getServletName() : null).append(":ServletConfigSource").toString();
                }
            }
        }
        return this.name;
    }

    public int getOrdinal() {
        return 60;
    }

    static {
        Class<?> clazz = null;
        try {
            clazz = Class.forName(ServletConfig.class.getName());
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        SERVLET_AVAILABLE = clazz != null;
    }
}

