/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.resteasy.plugins.server.servlet;

import java.io.IOException;
import java.io.InputStream;
import java.util.Enumeration;
import java.util.List;
import java.util.Map;
import javax.servlet.ServletContext;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.ws.rs.core.HttpHeaders;
import javax.ws.rs.core.MediaType;
import javax.ws.rs.core.MultivaluedMap;
import org.jboss.resteasy.core.SynchronousDispatcher;
import org.jboss.resteasy.core.SynchronousExecutionContext;
import org.jboss.resteasy.plugins.providers.FormUrlEncodedProvider;
import org.jboss.resteasy.plugins.server.BaseHttpRequest;
import org.jboss.resteasy.resteasy_jaxrs.i18n.Messages;
import org.jboss.resteasy.specimpl.MultivaluedMapImpl;
import org.jboss.resteasy.specimpl.ResteasyHttpHeaders;
import org.jboss.resteasy.specimpl.ResteasyUriInfo;
import org.jboss.resteasy.spi.HttpResponse;
import org.jboss.resteasy.spi.ResteasyAsynchronousContext;
import org.jboss.resteasy.util.Encode;

public class HttpServletInputMessage
extends BaseHttpRequest {
    protected ResteasyHttpHeaders httpHeaders;
    protected HttpServletRequest request;
    protected HttpServletResponse servletResponse;
    protected ServletContext servletContext;
    protected SynchronousDispatcher dispatcher;
    protected HttpResponse httpResponse;
    protected String httpMethod;
    protected InputStream overridenStream;
    protected SynchronousExecutionContext executionContext;
    protected boolean wasForwarded;

    public HttpServletInputMessage(HttpServletRequest request, HttpServletResponse servletResponse, ServletContext servletContext, HttpResponse httpResponse, ResteasyHttpHeaders httpHeaders, ResteasyUriInfo uri, String httpMethod, SynchronousDispatcher dispatcher) {
        super(uri);
        this.request = request;
        this.servletResponse = servletResponse;
        this.servletContext = servletContext;
        this.dispatcher = dispatcher;
        this.httpResponse = httpResponse;
        this.httpHeaders = httpHeaders;
        this.httpMethod = httpMethod;
        this.executionContext = new SynchronousExecutionContext(dispatcher, this, httpResponse);
    }

    public MultivaluedMap<String, String> getMutableHeaders() {
        return this.httpHeaders.getMutableHeaders();
    }

    public MultivaluedMap<String, String> getPutFormParameters() {
        if (this.formParameters != null) {
            return this.formParameters;
        }
        MediaType mt = this.getHttpHeaders().getMediaType();
        if (MediaType.APPLICATION_FORM_URLENCODED_TYPE.isCompatible(mt)) {
            try {
                this.formParameters = FormUrlEncodedProvider.parseForm(this.getInputStream(), (String)mt.getParameters().get("charset"));
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        } else {
            throw new IllegalArgumentException(Messages.MESSAGES.requestMediaTypeNotUrlencoded());
        }
        return this.formParameters;
    }

    public MultivaluedMap<String, String> getPutDecodedFormParameters() {
        if (this.decodedFormParameters != null) {
            return this.decodedFormParameters;
        }
        this.decodedFormParameters = Encode.decode(this.getFormParameters());
        return this.decodedFormParameters;
    }

    public Object getAttribute(String attribute) {
        return this.request.getAttribute(attribute);
    }

    public void setAttribute(String name, Object value) {
        this.request.setAttribute(name, value);
    }

    public void removeAttribute(String name) {
        this.request.removeAttribute(name);
    }

    public Enumeration<String> getAttributeNames() {
        return this.request.getAttributeNames();
    }

    @Override
    public MultivaluedMap<String, String> getFormParameters() {
        if (this.formParameters != null) {
            return this.formParameters;
        }
        if (this.request.getMethod().equals("PUT") && (this.request.getParameterMap() == null || this.request.getParameterMap().isEmpty())) {
            return this.getPutFormParameters();
        }
        Map parameterMap = this.request.getParameterMap();
        MultivaluedMap<String, String> queryMap = this.uri.getQueryParameters();
        if (this.request.getMethod().equals("PUT") && this.mapEquals(parameterMap, queryMap)) {
            return this.getPutFormParameters();
        }
        this.formParameters = Encode.encode(this.getDecodedFormParameters());
        return this.formParameters;
    }

    @Override
    public MultivaluedMap<String, String> getDecodedFormParameters() {
        if (this.decodedFormParameters != null) {
            return this.decodedFormParameters;
        }
        if (this.request.getMethod().equals("PUT") && (this.request.getParameterMap() == null || this.request.getParameterMap().isEmpty())) {
            return this.getPutDecodedFormParameters();
        }
        Map parameterMap = this.request.getParameterMap();
        MultivaluedMap<String, String> queryMap = this.uri.getQueryParameters();
        if (this.request.getMethod().equals("PUT") && this.mapEquals(parameterMap, queryMap)) {
            return this.getPutDecodedFormParameters();
        }
        this.decodedFormParameters = new MultivaluedMapImpl();
        Map params = this.request.getParameterMap();
        for (Map.Entry entry : params.entrySet()) {
            String name = (String)entry.getKey();
            String[] values = (String[])entry.getValue();
            MultivaluedMap<String, String> queryParams = this.uri.getQueryParameters();
            List queryValues = (List)queryParams.get((Object)name);
            if (queryValues == null) {
                for (String val : values) {
                    this.decodedFormParameters.add((Object)name, (Object)val);
                }
                continue;
            }
            for (String val : values) {
                if (queryValues.contains(val)) continue;
                this.decodedFormParameters.add((Object)name, (Object)val);
            }
        }
        return this.decodedFormParameters;
    }

    public boolean formParametersRead() {
        return this.decodedFormParameters != null;
    }

    public HttpHeaders getHttpHeaders() {
        return this.httpHeaders;
    }

    public InputStream getInputStream() {
        if (this.overridenStream != null) {
            return this.overridenStream;
        }
        try {
            return this.request.getInputStream();
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public void setInputStream(InputStream stream) {
        this.overridenStream = stream;
    }

    public String getHttpMethod() {
        return this.httpMethod;
    }

    public void setHttpMethod(String method) {
        this.httpMethod = method;
    }

    public ResteasyAsynchronousContext getAsyncContext() {
        return this.executionContext;
    }

    public void forward(String path) {
        try {
            this.wasForwarded = true;
            this.servletContext.getRequestDispatcher(path).forward((ServletRequest)this.request, (ServletResponse)this.servletResponse);
        }
        catch (ServletException e) {
            throw new RuntimeException(e);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public boolean wasForwarded() {
        return this.wasForwarded;
    }

    protected boolean mapEquals(Map<String, String[]> parameterMap, MultivaluedMap<String, String> queryMap) {
        if (parameterMap.size() != queryMap.size()) {
            return false;
        }
        for (String key : parameterMap.keySet()) {
            List queryValues;
            String[] parameterValues = parameterMap.get(key);
            if (parameterValues.length != (queryValues = (List)queryMap.get((Object)key)).size()) {
                return false;
            }
            for (int i = 0; i < parameterValues.length; ++i) {
                if (queryValues.contains(parameterValues[i])) continue;
                return false;
            }
        }
        return true;
    }
}

