/*
 * Decompiled with CFR 0.152.
 */
package io.smallrye.context;

import io.smallrye.context.SmallRyeContextManager;
import java.util.ArrayList;
import java.util.List;
import java.util.ServiceLoader;
import org.eclipse.microprofile.context.spi.ContextManager;
import org.eclipse.microprofile.context.spi.ContextManagerExtension;
import org.eclipse.microprofile.context.spi.ThreadContextProvider;

public class SmallRyeContextManagerBuilder
implements ContextManager.Builder {
    private ClassLoader classLoader = Thread.currentThread().getContextClassLoader();
    private boolean addDiscoveredThreadContextProviders;
    private boolean addDiscoveredContextManagerExtensions;
    private List<ThreadContextProvider> contextProviders = new ArrayList<ThreadContextProvider>();
    private List<ContextManagerExtension> contextManagerExtensions = new ArrayList<ContextManagerExtension>();

    public SmallRyeContextManagerBuilder withThreadContextProviders(ThreadContextProvider ... providers) {
        for (ThreadContextProvider contextProvider : providers) {
            this.contextProviders.add(contextProvider);
        }
        return this;
    }

    public SmallRyeContextManagerBuilder addDiscoveredThreadContextProviders() {
        this.addDiscoveredThreadContextProviders = true;
        return this;
    }

    private List<ThreadContextProvider> discoverThreadContextProviders() {
        ArrayList<ThreadContextProvider> discoveredThreadContextProviders = new ArrayList<ThreadContextProvider>();
        ServiceLoader<ThreadContextProvider> configSourceLoader = ServiceLoader.load(ThreadContextProvider.class, this.classLoader);
        configSourceLoader.forEach(configSource -> discoveredThreadContextProviders.add((ThreadContextProvider)configSource));
        return discoveredThreadContextProviders;
    }

    public SmallRyeContextManagerBuilder withContextManagerExtensions(ContextManagerExtension ... propagators) {
        for (ContextManagerExtension contextPropagator : propagators) {
            this.contextManagerExtensions.add(contextPropagator);
        }
        return this;
    }

    public SmallRyeContextManagerBuilder addDiscoveredContextManagerExtensions() {
        this.addDiscoveredContextManagerExtensions = true;
        return this;
    }

    private List<ContextManagerExtension> discoverContextManagerExtensions() {
        ArrayList<ContextManagerExtension> discoveredContextManagerExtensions = new ArrayList<ContextManagerExtension>();
        ServiceLoader<ContextManagerExtension> configSourceLoader = ServiceLoader.load(ContextManagerExtension.class, this.classLoader);
        configSourceLoader.forEach(configSource -> discoveredContextManagerExtensions.add((ContextManagerExtension)configSource));
        return discoveredContextManagerExtensions;
    }

    public SmallRyeContextManagerBuilder forClassLoader(ClassLoader classLoader) {
        this.classLoader = classLoader;
        return this;
    }

    public SmallRyeContextManager build() {
        if (this.addDiscoveredThreadContextProviders) {
            this.contextProviders.addAll(this.discoverThreadContextProviders());
        }
        if (this.addDiscoveredContextManagerExtensions) {
            this.contextManagerExtensions.addAll(this.discoverContextManagerExtensions());
        }
        return new SmallRyeContextManager(this.contextProviders, this.contextManagerExtensions);
    }
}

