/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.resteasy.core.providerfactory;

import org.jboss.resteasy.core.MediaTypeMap;
import org.jboss.resteasy.spi.util.Types;

public class SortedKey<T>
implements Comparable<SortedKey<T>>,
MediaTypeMap.Typed {
    private final T obj;
    private final boolean isBuiltin;
    private final Class<?> template;
    private final int priority;

    public SortedKey(Class<?> intf, T reader, Class<?> readerClass, int priority, boolean isBuiltin) {
        this.obj = reader;
        Class<Object> t = Types.getTemplateParameterOfInterface(readerClass, intf);
        this.template = t != null ? t : Object.class;
        this.priority = priority;
        this.isBuiltin = isBuiltin;
    }

    public SortedKey(Class<?> intf, T reader, Class<?> readerClass, boolean isBuiltin) {
        this(intf, reader, readerClass, 5000, isBuiltin);
    }

    public SortedKey(Class<?> intf, T reader, Class<?> readerClass) {
        this(intf, reader, readerClass, 5000, false);
    }

    @Override
    public int compareTo(SortedKey<T> tMessageBodyKey) {
        if (this == tMessageBodyKey) {
            return 0;
        }
        if (this.isBuiltin == tMessageBodyKey.isBuiltin) {
            if (this.priority < tMessageBodyKey.priority) {
                return -1;
            }
            if (this.priority == tMessageBodyKey.priority) {
                return 0;
            }
            if (this.priority > tMessageBodyKey.priority) {
                return 1;
            }
        }
        if (this.isBuiltin) {
            return 1;
        }
        return -1;
    }

    @Override
    public Class<?> getType() {
        return this.template;
    }

    public T getObj() {
        return this.obj;
    }
}

