/*
 * Decompiled with CFR 0.152.
 */
package io.smallrye.context.impl;

import io.smallrye.context.SmallRyeContextManager;
import io.smallrye.context.impl.DefaultValues;
import io.smallrye.context.impl.ThreadContextImpl;
import org.eclipse.microprofile.context.ThreadContext;

public class ThreadContextBuilderImpl
implements ThreadContext.Builder {
    private String[] propagated;
    private String[] unchanged;
    private String[] cleared;
    private SmallRyeContextManager manager;
    private String injectionPointName = null;

    public ThreadContextBuilderImpl(SmallRyeContextManager manager) {
        this.manager = manager;
        DefaultValues defaultValues = manager.getDefaultValues();
        this.propagated = defaultValues.getThreadPropagated();
        this.unchanged = defaultValues.getThreadUnchanged();
        this.cleared = defaultValues.getThreadCleared();
    }

    public ThreadContext build() {
        return new ThreadContextImpl(this.manager, this.propagated, this.unchanged, this.cleared, this.injectionPointName);
    }

    public ThreadContext.Builder propagated(String ... types) {
        this.propagated = types;
        return this;
    }

    public ThreadContext.Builder unchanged(String ... types) {
        this.unchanged = types;
        return this;
    }

    public ThreadContext.Builder cleared(String ... types) {
        this.cleared = types;
        return this;
    }

    public ThreadContext.Builder injectionPointName(String name) {
        this.injectionPointName = name;
        return this;
    }
}

