/*
 * Decompiled with CFR 0.152.
 */
package io.smallrye.context.propagators.rxjava2;

import io.reactivex.Single;
import io.reactivex.SingleObserver;
import io.reactivex.disposables.Disposable;
import io.reactivex.functions.BiFunction;
import java.util.concurrent.Executor;
import org.eclipse.microprofile.context.ThreadContext;

public class ContextPropagatorOnSingleCreateAction
implements BiFunction<Single, SingleObserver, SingleObserver> {
    private ThreadContext threadContext;

    public ContextPropagatorOnSingleCreateAction(ThreadContext threadContext) {
        this.threadContext = threadContext;
    }

    public SingleObserver apply(Single s, SingleObserver o) throws Exception {
        return new ContextCapturerSingle(s, o, this.threadContext.currentContextExecutor());
    }

    static final class ContextCapturerSingle<T>
    implements SingleObserver<T> {
        private final SingleObserver<T> source;
        private final Executor contextExecutor;

        public ContextCapturerSingle(Single<T> s, SingleObserver<T> o, Executor contextExecutor) {
            this.source = o;
            this.contextExecutor = contextExecutor;
        }

        public void onError(Throwable t) {
            this.contextExecutor.execute(() -> this.source.onError(t));
        }

        public void onSubscribe(Disposable d) {
            this.contextExecutor.execute(() -> this.source.onSubscribe(d));
        }

        public void onSuccess(T v) {
            this.contextExecutor.execute(() -> this.source.onSuccess(v));
        }
    }
}

