/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.resteasy.microprofile.client;

import java.lang.annotation.Annotation;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.CompletionException;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.stream.Collectors;
import javax.enterprise.context.spi.CreationalContext;
import javax.enterprise.inject.spi.Bean;
import javax.enterprise.inject.spi.BeanManager;
import javax.enterprise.inject.spi.CDI;
import javax.enterprise.inject.spi.InterceptionType;
import javax.enterprise.inject.spi.Interceptor;
import javax.ws.rs.ProcessingException;
import javax.ws.rs.client.ResponseProcessingException;
import javax.ws.rs.ext.ParamConverter;
import javax.ws.rs.ext.ParamConverterProvider;
import org.jboss.logging.Logger;
import org.jboss.resteasy.client.jaxrs.ResteasyClient;
import org.jboss.resteasy.microprofile.client.ExceptionMapping;
import org.jboss.resteasy.microprofile.client.InvocationContextImpl;
import org.jboss.resteasy.microprofile.client.RestClientProxy;
import org.jboss.resteasy.microprofile.client.header.ClientHeaderFillingException;

public class ProxyInvocationHandler
implements InvocationHandler {
    private static final Logger LOGGER = Logger.getLogger(ProxyInvocationHandler.class);
    public static final Type[] NO_TYPES = new Type[0];
    private final Object target;
    private final Set<Object> providerInstances;
    private final Map<Method, List<InvocationContextImpl.InterceptorInvocation>> interceptorChains;
    private final ResteasyClient client;
    private final CreationalContext<?> creationalContext;
    private final AtomicBoolean closed;

    public ProxyInvocationHandler(Class<?> restClientInterface, Object target, Set<Object> providerInstances, ResteasyClient client) {
        this.target = target;
        this.providerInstances = providerInstances;
        this.client = client;
        this.closed = new AtomicBoolean();
        BeanManager beanManager = ProxyInvocationHandler.getBeanManager(restClientInterface);
        if (beanManager != null) {
            this.creationalContext = beanManager.createCreationalContext(null);
            this.interceptorChains = ProxyInvocationHandler.initInterceptorChains(beanManager, this.creationalContext, restClientInterface);
        } else {
            this.creationalContext = null;
            this.interceptorChains = Collections.emptyMap();
        }
    }

    @Override
    public Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
        List<InvocationContextImpl.InterceptorInvocation> chain;
        if (RestClientProxy.class.equals(method.getDeclaringClass())) {
            return this.invokeRestClientProxyMethod(proxy, method, args);
        }
        if (method.getName().equals("close") && (args == null || args.length == 0)) {
            this.close();
            return null;
        }
        if (this.closed.get()) {
            throw new IllegalStateException("RestClientProxy is closed");
        }
        boolean replacementNeeded = false;
        Object[] argsReplacement = args != null ? new Object[args.length] : null;
        Annotation[][] parameterAnnotations = method.getParameterAnnotations();
        for (Object p : this.providerInstances) {
            if (!(p instanceof ParamConverterProvider)) continue;
            int index = 0;
            Object[] objectArray = args;
            int n = args.length;
            int n2 = 0;
            while (n2 < n) {
                block29: {
                    block31: {
                        Object arg;
                        block30: {
                            Type[] genericTypes;
                            arg = objectArray[n2];
                            if (arg == null) break block29;
                            if (parameterAnnotations[index].length <= 0) break block30;
                            ParamConverter converter = ((ParamConverterProvider)p).getConverter(arg.getClass(), null, parameterAnnotations[index]);
                            if (converter == null || (genericTypes = this.getGenericTypes(converter.getClass())).length != 1) break block31;
                            switch (genericTypes[0].getTypeName()) {
                                case "java.lang.String": {
                                    ParamConverter stringConverter = converter;
                                    argsReplacement[index] = stringConverter.toString((Object)((String)arg));
                                    replacementNeeded = true;
                                    break block31;
                                }
                                case "java.lang.Integer": {
                                    ParamConverter intConverter = converter;
                                    argsReplacement[index] = intConverter.toString((Object)((Integer)arg));
                                    replacementNeeded = true;
                                    break block31;
                                }
                                case "java.lang.Boolean": {
                                    ParamConverter boolConverter = converter;
                                    argsReplacement[index] = boolConverter.toString((Object)((Boolean)arg));
                                    replacementNeeded = true;
                                    break block31;
                                }
                            }
                            break block29;
                        }
                        argsReplacement[index] = arg;
                    }
                    ++index;
                }
                ++n2;
            }
        }
        if (replacementNeeded) {
            args = argsReplacement;
        }
        if ((chain = this.interceptorChains.get(method)) != null) {
            return new InvocationContextImpl(this.target, method, args, chain).proceed();
        }
        try {
            return method.invoke(this.target, args);
        }
        catch (InvocationTargetException e) {
            Throwable cause = e.getCause();
            if (cause instanceof CompletionException) {
                cause = cause.getCause();
            }
            if (cause instanceof ExceptionMapping.HandlerException) {
                ((ExceptionMapping.HandlerException)((Object)cause)).mapException(method);
            }
            if (cause instanceof ResponseProcessingException) {
                ResponseProcessingException rpe = (ResponseProcessingException)cause;
                if ((cause = rpe.getCause()) instanceof RuntimeException) {
                    throw cause;
                }
            } else {
                if (cause instanceof ProcessingException && cause.getCause() instanceof ClientHeaderFillingException) {
                    throw cause.getCause().getCause();
                }
                if (cause instanceof RuntimeException) {
                    throw cause;
                }
            }
            throw e;
        }
    }

    private Object invokeRestClientProxyMethod(Object proxy, Method method, Object[] args) throws Throwable {
        switch (method.getName()) {
            case "getClient": {
                return this.client;
            }
            case "close": {
                this.close();
                return null;
            }
        }
        throw new IllegalStateException("Unsupported RestClientProxy method: " + method);
    }

    private void close() {
        if (this.closed.compareAndSet(false, true)) {
            if (this.creationalContext != null) {
                this.creationalContext.release();
            }
            this.client.close();
        }
    }

    private Type[] getGenericTypes(Class<?> aClass) {
        Type[] genericInterfaces = aClass.getGenericInterfaces();
        Type[] genericTypes = NO_TYPES;
        Type[] typeArray = genericInterfaces;
        int n = genericInterfaces.length;
        int n2 = 0;
        while (n2 < n) {
            Type genericInterface = typeArray[n2];
            if (genericInterface instanceof ParameterizedType) {
                genericTypes = ((ParameterizedType)genericInterface).getActualTypeArguments();
            }
            ++n2;
        }
        return genericTypes;
    }

    private static List<Annotation> getBindings(Annotation[] annotations, BeanManager beanManager) {
        if (annotations.length == 0) {
            return Collections.emptyList();
        }
        ArrayList<Annotation> bindings = new ArrayList<Annotation>();
        Annotation[] annotationArray = annotations;
        int n = annotations.length;
        int n2 = 0;
        while (n2 < n) {
            Annotation annotation = annotationArray[n2];
            if (beanManager.isInterceptorBinding(annotation.annotationType())) {
                bindings.add(annotation);
            }
            ++n2;
        }
        return bindings;
    }

    private static BeanManager getBeanManager(Class<?> restClientInterface) {
        try {
            CDI current = CDI.current();
            return current != null ? current.getBeanManager() : null;
        }
        catch (IllegalStateException e) {
            LOGGER.warnf("CDI container is not available - interceptor bindings declared on %s will be ignored", (Object)restClientInterface.getSimpleName());
            return null;
        }
    }

    private static Map<Method, List<InvocationContextImpl.InterceptorInvocation>> initInterceptorChains(BeanManager beanManager, CreationalContext<?> creationalContext, Class<?> restClientInterface) {
        HashMap chains = new HashMap();
        HashMap<Interceptor, Object> interceptorInstances = new HashMap<Interceptor, Object>();
        List<Annotation> classLevelBindings = ProxyInvocationHandler.getBindings(restClientInterface.getAnnotations(), beanManager);
        Method[] methodArray = restClientInterface.getMethods();
        int n = methodArray.length;
        int n2 = 0;
        while (n2 < n) {
            Method method = methodArray[n2];
            if (!method.isDefault() && !Modifier.isStatic(method.getModifiers())) {
                Annotation[] interceptorBindings;
                List interceptors;
                List<Annotation> methodLevelBindings = ProxyInvocationHandler.getBindings(method.getAnnotations(), beanManager);
                if (!(classLevelBindings.isEmpty() && methodLevelBindings.isEmpty() || (interceptors = beanManager.resolveInterceptors(InterceptionType.AROUND_INVOKE, interceptorBindings = ProxyInvocationHandler.merge(methodLevelBindings, classLevelBindings))).isEmpty())) {
                    ArrayList<InvocationContextImpl.InterceptorInvocation> chain = new ArrayList<InvocationContextImpl.InterceptorInvocation>();
                    for (Interceptor interceptor : interceptors) {
                        chain.add(new InvocationContextImpl.InterceptorInvocation(interceptor, interceptorInstances.computeIfAbsent(interceptor, i -> beanManager.getReference((Bean)i, (Type)i.getBeanClass(), creationalContext))));
                    }
                    chains.put(method, chain);
                }
            }
            ++n2;
        }
        return chains.isEmpty() ? Collections.emptyMap() : chains;
    }

    private static Annotation[] merge(List<Annotation> methodLevelBindings, List<Annotation> classLevelBindings) {
        Set types = methodLevelBindings.stream().map(a -> a.annotationType()).collect(Collectors.toSet());
        ArrayList<Annotation> merged = new ArrayList<Annotation>(methodLevelBindings);
        for (Annotation annotation : classLevelBindings) {
            if (types.contains(annotation.annotationType())) continue;
            merged.add(annotation);
        }
        return merged.toArray(new Annotation[0]);
    }
}

