/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.resteasy.microprofile.client.header;

import java.lang.invoke.MethodHandle;
import java.lang.invoke.MethodHandles;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.stream.Collectors;
import org.eclipse.microprofile.rest.client.RestClientDefinitionException;
import org.jboss.logging.Logger;
import org.jboss.resteasy.microprofile.client.header.ClientHeaderFillingException;

class ComputedHeaderValueFiller {
    private static final Logger LOGGER = Logger.getLogger(ComputedHeaderValueFiller.class);
    private final Method method;
    private final MethodHandle methodHandle;
    private final String headerName;
    private final boolean required;
    private final boolean withParam;

    ComputedHeaderValueFiller(String methodSpecifierString, String headerName, boolean required, Class<?> interfaceClass, Object clientProxy) {
        this.required = required;
        this.headerName = headerName;
        String methodSpecifier = methodSpecifierString.substring(1, methodSpecifierString.length() - 1);
        this.method = this.resolveMethod(methodSpecifier, interfaceClass);
        this.methodHandle = this.method.isDefault() ? this.createMethodHandle(this.method, clientProxy) : null;
        this.withParam = this.method.getParameterCount() == 1;
    }

    private MethodHandle createMethodHandle(Method method, Object clientProxy) {
        try {
            Constructor constructor = MethodHandles.Lookup.class.getDeclaredConstructor(Class.class);
            constructor.setAccessible(true);
            MethodHandles.Lookup lookup = (MethodHandles.Lookup)constructor.newInstance(method.getDeclaringClass());
            return lookup.in(method.getDeclaringClass()).unreflectSpecial(method, method.getDeclaringClass()).bindTo(clientProxy);
        }
        catch (IllegalAccessException | InstantiationException | NoSuchMethodException | InvocationTargetException e) {
            throw new RestClientDefinitionException("Failed to generate method handle for " + method, (Throwable)e);
        }
    }

    private Method resolveMethod(String methodSpecifier, Class<?> interfaceClass) {
        Class<?> clazz;
        String methodName;
        int lastDot = methodSpecifier.lastIndexOf(46);
        if (lastDot == methodSpecifier.length()) {
            throw new RestClientDefinitionException("Invalid string to specify method: " + methodSpecifier + " for header: '" + this.headerName + "' on class " + interfaceClass.getCanonicalName());
        }
        if (lastDot > -1) {
            methodName = methodSpecifier.substring(lastDot + 1);
            String className = methodSpecifier.substring(0, lastDot);
            ClassLoader loader = Thread.currentThread().getContextClassLoader();
            try {
                clazz = Class.forName(className, true, loader);
            }
            catch (ClassNotFoundException e) {
                throw new RestClientDefinitionException("No class '" + className + "' found " + "for filling header '" + this.headerName + " on " + interfaceClass.getCanonicalName(), (Throwable)e);
            }
        } else {
            clazz = interfaceClass;
            methodName = methodSpecifier;
        }
        Method method = null;
        boolean resolved = false;
        try {
            method = clazz.getMethod(methodName, new Class[0]);
            resolved = true;
        }
        catch (NoSuchMethodException noSuchMethodException) {
            // empty catch block
        }
        if (!resolved) {
            try {
                method = clazz.getMethod(methodName, String.class);
                resolved = true;
            }
            catch (NoSuchMethodException noSuchMethodException) {
                // empty catch block
            }
        }
        if (resolved) {
            return method;
        }
        throw new RestClientDefinitionException("Could not resolve method '" + methodSpecifier + "' for filling header '" + this.headerName + " on " + interfaceClass.getCanonicalName());
    }

    List<String> generateValues() {
        try {
            Object result = this.methodHandle != null ? (this.withParam ? this.methodHandle.invokeWithArguments(this.headerName) : this.methodHandle.invokeWithArguments(new Object[0])) : (this.withParam ? this.method.invoke(null, this.headerName) : this.method.invoke(null, new Object[0]));
            if (result instanceof String[]) {
                return Arrays.asList((String[])result);
            }
            if (result instanceof List) {
                return this.castListToListOfStrings((List)result);
            }
            return Collections.singletonList(String.valueOf(result));
        }
        catch (Throwable e) {
            if (this.required) {
                throw new ClientHeaderFillingException("Failed to invoke header generation method: " + this.method, e);
            }
            LOGGER.warnv(e, "Invoking header generation method {0} failed", (Object)this.method.toString());
            return Collections.emptyList();
        }
    }

    private List<String> castListToListOfStrings(List<?> result) {
        return result.stream().map(val -> val instanceof String ? (String)val : String.valueOf(val)).collect(Collectors.toList());
    }
}

