/*
 * Decompiled with CFR 0.152.
 */
package io.smallrye.context.impl;

import io.smallrye.context.impl.ThreadContextImpl;
import io.smallrye.context.impl.ThreadContextProviderPlan;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.concurrent.Callable;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Executor;
import java.util.concurrent.Future;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.function.Supplier;
import org.eclipse.microprofile.context.ManagedExecutor;

public class ManagedExecutorImpl
extends ThreadPoolExecutor
implements ManagedExecutor {
    private final ThreadContextImpl threadContext;
    private final int maxAsync;
    private final int maxQueued;
    private final String injectionPointName;
    private final Executor noPropagationExecutor = new NoPropagationExecutor();

    public ManagedExecutorImpl(int maxAsync, int maxQueued, ThreadContextImpl threadContext) {
        this(maxAsync, maxQueued, threadContext, null);
    }

    public ManagedExecutorImpl(int maxAsync, int maxQueued, ThreadContextImpl threadContext, String injectionPointName) {
        super(maxAsync == -1 ? Runtime.getRuntime().availableProcessors() : maxAsync, maxAsync == -1 ? Runtime.getRuntime().availableProcessors() : maxAsync, 5000L, TimeUnit.MILLISECONDS, new LinkedBlockingQueue<Runnable>(maxQueued == -1 ? Integer.MAX_VALUE : maxQueued), new ThreadPoolExecutor.AbortPolicy());
        this.allowCoreThreadTimeOut(true);
        this.threadContext = threadContext;
        this.maxAsync = maxAsync;
        this.maxQueued = maxQueued;
        this.injectionPointName = injectionPointName;
    }

    @Override
    public void shutdown() {
        super.shutdown();
    }

    @Override
    public List<Runnable> shutdownNow() {
        return super.shutdownNow();
    }

    @Override
    public boolean isShutdown() {
        return super.isShutdown();
    }

    @Override
    public boolean isTerminated() {
        return super.isTerminated();
    }

    @Override
    public boolean awaitTermination(long timeout, TimeUnit unit) throws InterruptedException {
        return super.awaitTermination(timeout, unit);
    }

    @Override
    public <T> Future<T> submit(Callable<T> task) {
        return super.submit(this.threadContext.contextualCallableUnlessContextualized(task));
    }

    @Override
    public <T> Future<T> submit(Runnable task, T result) {
        return super.submit(this.threadContext.contextualRunnableUnlessContextualized(task), result);
    }

    @Override
    public Future<?> submit(Runnable task) {
        return super.submit(this.threadContext.contextualRunnableUnlessContextualized(task));
    }

    @Override
    public <T> List<Future<T>> invokeAll(Collection<? extends Callable<T>> tasks) throws InterruptedException {
        ArrayList<Callable<T>> wrappedTasks = new ArrayList<Callable<T>>(tasks.size());
        for (Callable<T> task : tasks) {
            wrappedTasks.add(this.threadContext.contextualCallableUnlessContextualized(task));
        }
        return super.invokeAll(wrappedTasks);
    }

    @Override
    public <T> List<Future<T>> invokeAll(Collection<? extends Callable<T>> tasks, long timeout, TimeUnit unit) throws InterruptedException {
        ArrayList<Callable<T>> wrappedTasks = new ArrayList<Callable<T>>(tasks.size());
        for (Callable<T> task : tasks) {
            wrappedTasks.add(this.threadContext.contextualCallableUnlessContextualized(task));
        }
        return super.invokeAll(wrappedTasks, timeout, unit);
    }

    @Override
    public <T> T invokeAny(Collection<? extends Callable<T>> tasks) throws InterruptedException, ExecutionException {
        ArrayList<Callable<T>> wrappedTasks = new ArrayList<Callable<T>>(tasks.size());
        for (Callable<T> task : tasks) {
            wrappedTasks.add(this.threadContext.contextualCallableUnlessContextualized(task));
        }
        return super.invokeAny(wrappedTasks);
    }

    @Override
    public <T> T invokeAny(Collection<? extends Callable<T>> tasks, long timeout, TimeUnit unit) throws InterruptedException, ExecutionException, TimeoutException {
        ArrayList<Callable<T>> wrappedTasks = new ArrayList<Callable<T>>(tasks.size());
        for (Callable<T> task : tasks) {
            wrappedTasks.add(this.threadContext.contextualCallableUnlessContextualized(task));
        }
        return super.invokeAny(wrappedTasks, timeout, unit);
    }

    @Override
    public void execute(Runnable command) {
        super.execute(this.threadContext.contextualRunnableUnlessContextualized(command));
    }

    private void executeWithoutPropagation(Runnable command) {
        super.execute(command);
    }

    public <U> CompletableFuture<U> completedFuture(U value) {
        return this.threadContext.withContextCapture(CompletableFuture.completedFuture(value), this);
    }

    public <U> CompletionStage<U> completedStage(U value) {
        return this.completedFuture(value);
    }

    public <U> CompletableFuture<U> failedFuture(Throwable ex) {
        CompletableFuture ret = new CompletableFuture();
        ret.completeExceptionally(ex);
        return this.threadContext.withContextCapture(ret, this);
    }

    public <U> CompletionStage<U> failedStage(Throwable ex) {
        return this.failedFuture(ex);
    }

    public CompletableFuture<Void> runAsync(Runnable runnable) {
        return this.threadContext.withContextCapture(CompletableFuture.runAsync(this.threadContext.contextualRunnableUnlessContextualized(runnable), this.noPropagationExecutor), this);
    }

    public <U> CompletableFuture<U> supplyAsync(Supplier<U> supplier) {
        return this.threadContext.withContextCapture(CompletableFuture.supplyAsync(this.threadContext.contextualSupplierUnlessContextualized(supplier), this.noPropagationExecutor), this);
    }

    public <U> CompletableFuture<U> newIncompleteFuture() {
        CompletableFuture ret = new CompletableFuture();
        return this.threadContext.withContextCapture(ret, this);
    }

    @Override
    public String toString() {
        String DELIMITER = ", ";
        StringBuilder builder = new StringBuilder();
        builder.append(ManagedExecutorImpl.class.getName()).append(", ");
        builder.append("with maxAsync: ").append(this.maxAsync).append(", ");
        builder.append("with maxQueued: ").append(this.maxQueued).append(", ");
        builder.append("with cleared contexts: ").append(this.threadContext.getPlan().clearedProviders).append(", ");
        builder.append("with propagated contexts: ").append(this.threadContext.getPlan().propagatedProviders).append(", ");
        builder.append("with unchanged contexts: ").append(this.threadContext.getPlan().unchangedProviders);
        if (this.injectionPointName != null) {
            builder.append(", ").append(" with injection point name: ").append(this.injectionPointName);
        }
        return builder.toString();
    }

    public ThreadContextProviderPlan getThreadContextProviderPlan() {
        return this.threadContext.getPlan();
    }

    public int getMaxAsync() {
        return this.maxAsync;
    }

    public int getMaxQueued() {
        return this.maxQueued;
    }

    public String getInjectionPointName() {
        return this.injectionPointName;
    }

    private class NoPropagationExecutor
    implements Executor {
        private NoPropagationExecutor() {
        }

        @Override
        public void execute(Runnable command) {
            ManagedExecutorImpl.this.executeWithoutPropagation(command);
        }
    }
}

