/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.resteasy.core;

import java.io.IOException;
import java.lang.annotation.Annotation;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import java.lang.reflect.Type;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.HashSet;
import java.util.Map;
import java.util.concurrent.CompletionStage;
import javax.servlet.ServletOutputStream;
import javax.servlet.WriteListener;
import javax.ws.rs.container.ResourceInfo;
import javax.ws.rs.core.Application;
import javax.ws.rs.ext.Providers;
import javax.ws.rs.sse.Sse;
import javax.ws.rs.sse.SseEventSink;
import org.jboss.resteasy.core.CompletionStageHolder;
import org.jboss.resteasy.core.ResteasyContext;
import org.jboss.resteasy.plugins.providers.sse.SseImpl;
import org.jboss.resteasy.resteasy_jaxrs.i18n.Messages;
import org.jboss.resteasy.spi.HttpRequest;
import org.jboss.resteasy.spi.HttpResponse;
import org.jboss.resteasy.spi.LoggableFailure;
import org.jboss.resteasy.spi.ResteasyProviderFactory;
import org.jboss.resteasy.spi.ValueInjector;
import org.jboss.resteasy.spi.util.Types;

public class ContextParameterInjector
implements ValueInjector {
    private Class<?> rawType;
    private Class<?> proxy;
    private ResteasyProviderFactory factory;
    private Type genericType;
    private Annotation[] annotations;
    private volatile boolean outputStreamWasWritten = false;

    public ContextParameterInjector(Class<?> proxy, Class<?> rawType, Type genericType, Annotation[] annotations, ResteasyProviderFactory factory) {
        this.rawType = rawType;
        this.genericType = genericType;
        this.proxy = proxy;
        this.factory = factory;
        this.annotations = annotations;
    }

    public Object inject(HttpRequest request, HttpResponse response, boolean unwrapAsync) {
        if (this.rawType.equals(Providers.class)) {
            return this.factory;
        }
        if (!this.rawType.isInterface() || this.rawType.equals(SseEventSink.class) || ContextParameterInjector.hasAsyncContextData(this.factory, this.genericType)) {
            return this.unwrapIfRequired(request, this.factory.getContextData(this.rawType, this.genericType, this.annotations, unwrapAsync), unwrapAsync);
        }
        if (this.rawType.equals(Sse.class)) {
            return new SseImpl();
        }
        if (this.rawType == CompletionStage.class) {
            return new CompletionStageHolder((CompletionStage)this.createProxy());
        }
        return this.createProxy();
    }

    private static boolean hasAsyncContextData(ResteasyProviderFactory factory, Type genericType) {
        return factory.getAsyncContextInjectors().containsKey(Types.boxPrimitives((Type)genericType));
    }

    private Object unwrapIfRequired(HttpRequest request, Object contextData, boolean unwrapAsync) {
        if (unwrapAsync && this.rawType != CompletionStage.class && contextData instanceof CompletionStage) {
            boolean resolved;
            if (request != null && !(resolved = ((CompletionStage)contextData).toCompletableFuture().isDone())) {
                if (!request.getAsyncContext().isSuspended()) {
                    request.getAsyncContext().suspend();
                }
                Map<Class<?>, Object> contextDataMap = ResteasyContext.getContextDataMap();
                return ((CompletionStage)contextData).thenApply(value -> {
                    ResteasyContext.pushContextDataMap(contextDataMap);
                    return value;
                });
            }
            return (CompletionStage)contextData;
        }
        if (this.rawType == CompletionStage.class && contextData instanceof CompletionStage) {
            return new CompletionStageHolder((CompletionStage)contextData);
        }
        if (!unwrapAsync && this.rawType != CompletionStage.class && contextData instanceof CompletionStage) {
            throw new LoggableFailure(Messages.MESSAGES.shouldBeUnreachable());
        }
        return contextData;
    }

    public Object inject(boolean unwrapAsync) {
        if (this.rawType.equals(Application.class) || this.rawType.equals(SseEventSink.class) || ContextParameterInjector.hasAsyncContextData(this.factory, this.genericType)) {
            return this.factory.getContextData(this.rawType, this.genericType, this.annotations, unwrapAsync);
        }
        if (this.rawType.equals(Sse.class)) {
            return new SseImpl();
        }
        if (!this.rawType.isInterface()) {
            Object delegate = this.factory.getContextData(this.rawType, this.genericType, this.annotations, unwrapAsync);
            if (delegate != null) {
                return this.unwrapIfRequired(null, delegate, unwrapAsync);
            }
            throw new RuntimeException(Messages.MESSAGES.illegalToInjectNonInterfaceType());
        }
        if (this.rawType == CompletionStage.class) {
            return new CompletionStageHolder((CompletionStage)this.createProxy());
        }
        return this.createProxy();
    }

    protected Object createProxy() {
        if (this.proxy != null) {
            try {
                return this.proxy.getConstructors()[0].newInstance(new GenericDelegatingProxy());
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        }
        final Object delegate = this.factory.getContextData(this.rawType, this.genericType, this.annotations, false);
        Class<?>[] intfs = this.computeInterfaces(delegate, this.rawType);
        ClassLoader clazzLoader = null;
        SecurityManager sm = System.getSecurityManager();
        clazzLoader = sm == null ? (delegate == null ? this.rawType.getClassLoader() : delegate.getClass().getClassLoader()) : AccessController.doPrivileged(new PrivilegedAction<ClassLoader>(){

            @Override
            public ClassLoader run() {
                return delegate == null ? ContextParameterInjector.this.rawType.getClassLoader() : delegate.getClass().getClassLoader();
            }
        });
        return Proxy.newProxyInstance(clazzLoader, intfs, (InvocationHandler)new GenericDelegatingProxy());
    }

    boolean outputStreamWasWrittenTo() {
        return this.outputStreamWasWritten;
    }

    protected Class<?>[] computeInterfaces(Object delegate, Class<?> cls) {
        HashSet set = new HashSet();
        set.add(cls);
        if (delegate != null) {
            for (Class<?> delegateClass = delegate.getClass(); delegateClass != null; delegateClass = delegateClass.getSuperclass()) {
                for (Class<?> intf : delegateClass.getInterfaces()) {
                    set.add(intf);
                    for (Class<?> superIntf : intf.getInterfaces()) {
                        set.add(superIntf);
                    }
                }
            }
        }
        return set.toArray(new Class[0]);
    }

    private final class ContextOutputStream
    extends ServletOutputStream {
        private ServletOutputStream delegate;

        ContextOutputStream(ServletOutputStream delegate) {
            this.delegate = delegate;
        }

        public void print(String s) throws IOException {
            this.delegate.print(s);
            ContextParameterInjector.this.outputStreamWasWritten = true;
        }

        public void print(boolean b) throws IOException {
            this.delegate.print(b);
            ContextParameterInjector.this.outputStreamWasWritten = true;
        }

        public void print(char c) throws IOException {
            this.delegate.print(c);
            ContextParameterInjector.this.outputStreamWasWritten = true;
        }

        public void print(int i) throws IOException {
            this.delegate.print(i);
            ContextParameterInjector.this.outputStreamWasWritten = true;
        }

        public void print(long l) throws IOException {
            this.delegate.print(l);
            ContextParameterInjector.this.outputStreamWasWritten = true;
        }

        public void print(float f) throws IOException {
            this.delegate.print(f);
            ContextParameterInjector.this.outputStreamWasWritten = true;
        }

        public void print(double d) throws IOException {
            this.delegate.print(d);
            ContextParameterInjector.this.outputStreamWasWritten = true;
        }

        public void println() throws IOException {
            this.delegate.println();
            ContextParameterInjector.this.outputStreamWasWritten = true;
        }

        public void println(String s) throws IOException {
            this.delegate.println(s);
            ContextParameterInjector.this.outputStreamWasWritten = true;
        }

        public void println(boolean b) throws IOException {
            this.delegate.println(b);
            ContextParameterInjector.this.outputStreamWasWritten = true;
        }

        public void println(char c) throws IOException {
            this.delegate.print(c);
            ContextParameterInjector.this.outputStreamWasWritten = true;
        }

        public void println(int i) throws IOException {
            this.delegate.println(i);
            ContextParameterInjector.this.outputStreamWasWritten = true;
        }

        public void println(long l) throws IOException {
            this.delegate.println(l);
            ContextParameterInjector.this.outputStreamWasWritten = true;
        }

        public void println(float f) throws IOException {
            this.delegate.println(f);
            ContextParameterInjector.this.outputStreamWasWritten = true;
        }

        public void println(double d) throws IOException {
            this.delegate.println(d);
            ContextParameterInjector.this.outputStreamWasWritten = true;
        }

        public boolean isReady() {
            return this.delegate.isReady();
        }

        public void setWriteListener(WriteListener writeListener) {
            this.delegate.setWriteListener(writeListener);
        }

        public void write(byte[] b) throws IOException {
            this.delegate.write(b);
            ContextParameterInjector.this.outputStreamWasWritten = true;
        }

        public void write(byte[] b, int off, int len) throws IOException {
            this.delegate.write(b, off, len);
            ContextParameterInjector.this.outputStreamWasWritten = true;
        }

        public void write(int b) throws IOException {
            this.delegate.write(b);
            ContextParameterInjector.this.outputStreamWasWritten = true;
        }

        public void flush() throws IOException {
            this.delegate.flush();
        }

        public void close() throws IOException {
            this.delegate.close();
        }
    }

    private class GenericDelegatingProxy
    implements InvocationHandler {
        private GenericDelegatingProxy() {
        }

        @Override
        public Object invoke(Object o, Method method, Object[] objects) throws Throwable {
            try {
                Object delegate = ContextParameterInjector.this.factory.getContextData(ContextParameterInjector.this.rawType, ContextParameterInjector.this.genericType, ContextParameterInjector.this.annotations, false);
                if (delegate == null) {
                    String name = method.getName();
                    if (o instanceof ResourceInfo && ("getResourceMethod".equals(name) || "getResourceClass".equals(name))) {
                        return null;
                    }
                    if ("getContextResolver".equals(name)) {
                        return method.invoke((Object)ContextParameterInjector.this.factory, objects);
                    }
                    throw new LoggableFailure(Messages.MESSAGES.unableToFindContextualData(ContextParameterInjector.this.rawType.getName()));
                }
                if ("javax.servlet.http.HttpServletResponse".equals(ContextParameterInjector.this.rawType.getName()) && "getOutputStream".equals(method.getName())) {
                    ServletOutputStream sos = (ServletOutputStream)method.invoke(delegate, objects);
                    return new ContextOutputStream(sos);
                }
                return method.invoke(delegate, objects);
            }
            catch (IllegalAccessException e) {
                throw new RuntimeException(e);
            }
            catch (IllegalArgumentException e) {
                throw new RuntimeException(e);
            }
            catch (InvocationTargetException e) {
                throw e.getCause();
            }
        }
    }
}

