/*
 * Decompiled with CFR 0.152.
 */
package io.smallrye.context.impl;

import io.smallrye.context.ActiveContextState;
import io.smallrye.context.CapturedContextState;
import io.smallrye.context.SmallRyeContextManager;
import io.smallrye.context.impl.CompletableFutureWrapper;
import io.smallrye.context.impl.CompletionStageWrapper;
import io.smallrye.context.impl.Contextualized;
import io.smallrye.context.impl.ThreadContextProviderPlan;
import java.util.concurrent.Callable;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import java.util.concurrent.Executor;
import java.util.function.BiConsumer;
import java.util.function.BiFunction;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Supplier;
import org.eclipse.microprofile.context.ManagedExecutor;
import org.eclipse.microprofile.context.ThreadContext;

public class ThreadContextImpl
implements ThreadContext {
    private final SmallRyeContextManager manager;
    private final ThreadContextProviderPlan plan;
    private final String injectionPointName;

    public ThreadContextImpl(SmallRyeContextManager manager, String[] propagated, String[] unchanged, String[] cleared) {
        this(manager, propagated, unchanged, cleared, null);
    }

    public ThreadContextImpl(SmallRyeContextManager manager, String[] propagated, String[] unchanged, String[] cleared, String injectionPointName) {
        this.manager = manager;
        this.plan = manager.getProviderPlan(propagated, unchanged, cleared);
        this.injectionPointName = injectionPointName;
    }

    private void checkPrecontextualized(Object action) {
        if (action instanceof Contextualized) {
            throw new IllegalArgumentException("Action is already contextualized");
        }
    }

    public ThreadContextProviderPlan getPlan() {
        return this.plan;
    }

    public <T> CompletableFuture<T> withContextCapture(CompletableFuture<T> future) {
        return this.withContextCapture(future, null);
    }

    <T> CompletableFuture<T> withContextCapture(CompletableFuture<T> future, ManagedExecutor executor) {
        return new CompletableFutureWrapper<T>(this, future, executor);
    }

    public <T> CompletionStage<T> withContextCapture(CompletionStage<T> future) {
        return new CompletionStageWrapper<T>(this, future);
    }

    public Executor currentContextExecutor() {
        return this.withContext(this.manager.captureContext(this.plan));
    }

    Executor withContext(CapturedContextState state) {
        return runnable -> {
            ActiveContextState activeState = state.begin();
            try {
                runnable.run();
            }
            finally {
                activeState.endContext();
            }
        };
    }

    public <T, U> BiConsumer<T, U> contextualConsumer(BiConsumer<T, U> consumer) {
        return this.contextualConsumer(this.manager.captureContext(this.plan), consumer);
    }

    <T, U> BiConsumer<T, U> contextualConsumerUnlessContextualized(BiConsumer<T, U> consumer) {
        if (consumer instanceof Contextualized) {
            return consumer;
        }
        return this.contextualConsumer(consumer);
    }

    <T, U> BiConsumer<T, U> contextualConsumer(CapturedContextState state, BiConsumer<T, U> consumer) {
        this.checkPrecontextualized(consumer);
        return new ContextualBiConsumer(consumer, state);
    }

    public <T, U, R> BiFunction<T, U, R> contextualFunction(BiFunction<T, U, R> function) {
        return this.contextualFunction(this.manager.captureContext(this.plan), function);
    }

    <T, U, R> BiFunction<T, U, R> contextualFunctionUnlessContextualized(BiFunction<T, U, R> function) {
        if (function instanceof Contextualized) {
            return function;
        }
        return this.contextualFunction(function);
    }

    <T, U, R> BiFunction<T, U, R> contextualFunction(CapturedContextState state, BiFunction<T, U, R> function) {
        this.checkPrecontextualized(function);
        return new ContextualBiFunction(state, function);
    }

    public <R> Callable<R> contextualCallable(Callable<R> callable) {
        return this.contextualCallable(this.manager.captureContext(this.plan), callable);
    }

    <R> Callable<R> contextualCallableUnlessContextualized(Callable<R> callable) {
        if (callable instanceof Contextualized) {
            return callable;
        }
        return this.contextualCallable(callable);
    }

    <R> Callable<R> contextualCallable(CapturedContextState state, Callable<R> callable) {
        this.checkPrecontextualized(callable);
        return new ContextualCallable(state, callable);
    }

    public <T> Consumer<T> contextualConsumer(Consumer<T> consumer) {
        return this.contextualConsumer(this.manager.captureContext(this.plan), consumer);
    }

    <T> Consumer<T> contextualConsumerUnlessContextualized(Consumer<T> consumer) {
        if (consumer instanceof Contextualized) {
            return consumer;
        }
        return this.contextualConsumer(consumer);
    }

    <T> Consumer<T> contextualConsumer(CapturedContextState state, Consumer<T> consumer) {
        this.checkPrecontextualized(consumer);
        return new ContextualConsumer(state, consumer);
    }

    public <T, R> Function<T, R> contextualFunction(Function<T, R> function) {
        return this.contextualFunction(this.manager.captureContext(this.plan), function);
    }

    <T, R> Function<T, R> contextualFunctionUnlessContextualized(Function<T, R> function) {
        if (function instanceof Contextualized) {
            return function;
        }
        return this.contextualFunction(function);
    }

    <T, R> Function<T, R> contextualFunction(CapturedContextState state, Function<T, R> function) {
        this.checkPrecontextualized(function);
        return new ContextualFunction(state, function);
    }

    public Runnable contextualRunnable(Runnable runnable) {
        return this.contextualRunnable(this.manager.captureContext(this.plan), runnable);
    }

    Runnable contextualRunnableUnlessContextualized(Runnable runnable) {
        if (runnable instanceof Contextualized) {
            return runnable;
        }
        return this.contextualRunnable(runnable);
    }

    Runnable contextualRunnable(CapturedContextState state, Runnable runnable) {
        this.checkPrecontextualized(runnable);
        return new ContextualRunnable(runnable, state);
    }

    public <R> Supplier<R> contextualSupplier(Supplier<R> supplier) {
        return this.contextualSupplier(this.manager.captureContext(this.plan), supplier);
    }

    <R> Supplier<R> contextualSupplierUnlessContextualized(Supplier<R> supplier) {
        if (supplier instanceof Contextualized) {
            return supplier;
        }
        return this.contextualSupplier(supplier);
    }

    <R> Supplier<R> contextualSupplier(CapturedContextState state, Supplier<R> supplier) {
        this.checkPrecontextualized(supplier);
        return new ContextualSupplier(state, supplier);
    }

    public String toString() {
        String DELIMITER = ", ";
        StringBuilder builder = new StringBuilder();
        builder.append(ThreadContextImpl.class.getName()).append(", ");
        builder.append("with cleared contexts: ").append(this.plan.clearedProviders).append(", ");
        builder.append("with propagated contexts: ").append(this.plan.propagatedProviders).append(", ");
        builder.append("with unchanged contexts: ").append(this.plan.unchangedProviders);
        if (this.injectionPointName != null) {
            builder.append(", ").append(" with injection point name: ").append(this.injectionPointName);
        }
        return builder.toString();
    }

    private final class ContextualBiConsumer<T, U>
    implements BiConsumer<T, U>,
    Contextualized {
        private final BiConsumer<T, U> consumer;
        private final CapturedContextState state;

        private ContextualBiConsumer(BiConsumer<T, U> consumer, CapturedContextState state) {
            this.consumer = consumer;
            this.state = state;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void accept(T t, U u) {
            ActiveContextState activeState = this.state.begin();
            try {
                this.consumer.accept(t, u);
            }
            finally {
                activeState.endContext();
            }
        }
    }

    private final class ContextualBiFunction<T, U, R>
    implements BiFunction<T, U, R>,
    Contextualized {
        private final CapturedContextState state;
        private final BiFunction<T, U, R> function;

        private ContextualBiFunction(CapturedContextState state, BiFunction<T, U, R> function) {
            this.state = state;
            this.function = function;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public R apply(T t, U u) {
            ActiveContextState activeState = this.state.begin();
            try {
                R r = this.function.apply(t, u);
                return r;
            }
            finally {
                activeState.endContext();
            }
        }
    }

    private final class ContextualCallable<R>
    implements Callable<R>,
    Contextualized {
        private final CapturedContextState state;
        private final Callable<R> callable;

        private ContextualCallable(CapturedContextState state, Callable<R> callable) {
            this.state = state;
            this.callable = callable;
        }

        @Override
        public R call() throws Exception {
            ActiveContextState activeState = this.state.begin();
            try {
                R r = this.callable.call();
                return r;
            }
            finally {
                activeState.endContext();
            }
        }
    }

    private final class ContextualConsumer<T>
    implements Consumer<T>,
    Contextualized {
        private final CapturedContextState state;
        private final Consumer<T> consumer;

        private ContextualConsumer(CapturedContextState state, Consumer<T> consumer) {
            this.state = state;
            this.consumer = consumer;
        }

        @Override
        public void accept(T t) {
            ActiveContextState activeState = this.state.begin();
            try {
                this.consumer.accept(t);
            }
            finally {
                activeState.endContext();
            }
        }
    }

    private final class ContextualFunction<T, R>
    implements Function<T, R>,
    Contextualized {
        private final CapturedContextState state;
        private final Function<T, R> function;

        private ContextualFunction(CapturedContextState state, Function<T, R> function) {
            this.state = state;
            this.function = function;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public R apply(T t) {
            ActiveContextState activeState = this.state.begin();
            try {
                R r = this.function.apply(t);
                return r;
            }
            finally {
                activeState.endContext();
            }
        }
    }

    private final class ContextualRunnable
    implements Runnable,
    Contextualized {
        private final Runnable runnable;
        private final CapturedContextState state;

        private ContextualRunnable(Runnable runnable, CapturedContextState state) {
            this.runnable = runnable;
            this.state = state;
        }

        @Override
        public void run() {
            ActiveContextState activeState = this.state.begin();
            try {
                this.runnable.run();
            }
            finally {
                activeState.endContext();
            }
        }
    }

    private final class ContextualSupplier<R>
    implements Supplier<R>,
    Contextualized {
        private final CapturedContextState state;
        private final Supplier<R> supplier;

        private ContextualSupplier(CapturedContextState state, Supplier<R> supplier) {
            this.state = state;
            this.supplier = supplier;
        }

        @Override
        public R get() {
            ActiveContextState activeState = this.state.begin();
            try {
                R r = this.supplier.get();
                return r;
            }
            finally {
                activeState.endContext();
            }
        }
    }
}

