/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.resteasy.plugins.server.sun.http;

import com.sun.net.httpserver.HttpContext;
import com.sun.net.httpserver.HttpExchange;
import com.sun.net.httpserver.HttpHandler;
import java.io.IOException;
import org.jboss.resteasy.core.Dispatcher;
import org.jboss.resteasy.core.SynchronousDispatcher;
import org.jboss.resteasy.core.ThreadLocalResteasyProviderFactory;
import org.jboss.resteasy.logging.Logger;
import org.jboss.resteasy.plugins.server.sun.http.HttpServerRequest;
import org.jboss.resteasy.plugins.server.sun.http.HttpServerResponse;
import org.jboss.resteasy.spi.HttpRequest;
import org.jboss.resteasy.spi.HttpResponse;
import org.jboss.resteasy.spi.ResteasyProviderFactory;

public class ResteasyHttpHandler
implements HttpHandler {
    protected Dispatcher dispatcher;
    protected ResteasyProviderFactory providerFactory;
    private static final Logger logger = Logger.getLogger(ResteasyHttpHandler.class);

    public void setDispatcher(Dispatcher dispatcher) {
        this.dispatcher = dispatcher;
    }

    public void setProviderFactory(ResteasyProviderFactory providerFactory) {
        this.providerFactory = providerFactory;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void handle(HttpExchange httpExchange) throws IOException {
        ResteasyProviderFactory defaultInstance;
        HttpServerResponse response = new HttpServerResponse(this.providerFactory, httpExchange);
        HttpServerRequest request = null;
        try {
            request = new HttpServerRequest((SynchronousDispatcher)this.dispatcher, response, httpExchange);
        }
        catch (Exception e) {
            logger.trace("Error parsing request", (Throwable)e);
            httpExchange.sendResponseHeaders(400, -1L);
            return;
        }
        try {
            defaultInstance = ResteasyProviderFactory.getInstance();
            if (defaultInstance instanceof ThreadLocalResteasyProviderFactory) {
                ThreadLocalResteasyProviderFactory.push((ResteasyProviderFactory)this.providerFactory);
            }
            try {
                ResteasyProviderFactory.pushContext(HttpExchange.class, (Object)httpExchange);
                ResteasyProviderFactory.pushContext(HttpContext.class, (Object)httpExchange.getHttpContext());
                this.dispatcher.invoke((HttpRequest)request, (HttpResponse)response);
                if (!response.isCommitted()) {
                    response.commitHeaders();
                }
            }
            catch (Exception ex) {
                logger.error("WTF!", (Throwable)ex);
                if (!response.isCommitted()) {
                    httpExchange.sendResponseHeaders(500, -1L);
                }
            }
            finally {
                ResteasyProviderFactory.clearContextData();
                httpExchange.getResponseBody().close();
            }
        }
        finally {
            defaultInstance = ResteasyProviderFactory.getInstance();
            if (defaultInstance instanceof ThreadLocalResteasyProviderFactory) {
                ThreadLocalResteasyProviderFactory.pop();
            }
        }
    }
}

