/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.resteasy.plugins.providers.multipart;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.lang.annotation.Annotation;
import java.lang.reflect.Type;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.UUID;
import javax.activation.DataHandler;
import javax.activation.DataSource;
import javax.ws.rs.WebApplicationException;
import javax.ws.rs.core.MediaType;
import javax.ws.rs.core.MultivaluedMap;
import javax.ws.rs.core.Response;
import javax.ws.rs.ext.Providers;
import javax.xml.bind.JAXBContext;
import javax.xml.bind.JAXBException;
import javax.xml.bind.Marshaller;
import javax.xml.bind.Unmarshaller;
import javax.xml.bind.attachment.AttachmentMarshaller;
import javax.xml.bind.attachment.AttachmentUnmarshaller;
import javax.xml.transform.Source;
import javax.xml.transform.stream.StreamSource;
import org.jboss.resteasy.plugins.providers.jaxb.AbstractJAXBProvider;
import org.jboss.resteasy.plugins.providers.multipart.InputPart;
import org.jboss.resteasy.plugins.providers.multipart.MultipartRelatedInput;
import org.jboss.resteasy.plugins.providers.multipart.MultipartRelatedOutput;
import org.jboss.resteasy.plugins.providers.multipart.OutputPart;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class XopWithMultipartRelatedJAXBProvider
extends AbstractJAXBProvider<Object> {
    public XopWithMultipartRelatedJAXBProvider(Providers providers) {
        this.providers = providers;
    }

    protected boolean isReadWritable(Class<?> type, Type genericType, Annotation[] annotations, MediaType mediaType) {
        throw new UnsupportedOperationException("This provider and this method are not ment for stand alone usage.");
    }

    public Object readFrom(Class<Object> type, Type genericType, Annotation[] annotations, MediaType mediaType, MultivaluedMap<String, String> httpHeaders, InputStream entityStream, final MultipartRelatedInput xopPackage) throws IOException {
        try {
            InputPart rootPart = xopPackage.getRootPart();
            JAXBContext jaxb = this.findJAXBContext(type, annotations, rootPart.getMediaType(), true);
            Unmarshaller unmarshaller = jaxb.createUnmarshaller();
            unmarshaller.setAttachmentUnmarshaller(new AttachmentUnmarshaller(){

                public byte[] getAttachmentAsByteArray(String cid) {
                    InputPart inputPart = this.getInputPart(cid);
                    try {
                        return inputPart.getBody(byte[].class, null);
                    }
                    catch (IOException e) {
                        throw new IllegalArgumentException("Exception while extracting attachment with cid = " + cid + " from xop message to a byte[].", e);
                    }
                }

                public DataHandler getAttachmentAsDataHandler(final String cid) {
                    final InputPart inputPart = this.getInputPart(cid);
                    return new DataHandler(new DataSource(){

                        public String getContentType() {
                            return inputPart.getMediaType().toString();
                        }

                        public String getName() {
                            return cid;
                        }

                        public InputStream getInputStream() throws IOException {
                            return inputPart.getBody(InputStream.class, null);
                        }

                        public OutputStream getOutputStream() throws IOException {
                            throw new IOException("This DataSource represents an incoming xop message part. Getting an OutputStream on it is not allowed.");
                        }
                    });
                }

                protected InputPart getInputPart(String cid) {
                    InputPart inputPart;
                    int cidIndex = (cid = cid.trim()).indexOf("cid:");
                    if (cidIndex == 0) {
                        cid = cid.substring(4).trim();
                    }
                    if ((inputPart = xopPackage.getRelatedMap().get(cid)) == null) {
                        throw new IllegalArgumentException("No attachment with cid = " + cid + " found in xop message.");
                    }
                    return inputPart;
                }

                public boolean isXOPPackage() {
                    return true;
                }
            });
            return unmarshaller.unmarshal((Source)new StreamSource(rootPart.getBody(InputStream.class, null)));
        }
        catch (JAXBException e) {
            Response response = Response.serverError().build();
            throw new WebApplicationException((Throwable)e, response);
        }
    }

    public void writeTo(Object t, Class<?> type, Type genericType, Annotation[] annotations, MediaType mediaType, MultivaluedMap<String, Object> httpHeaders, final MultipartRelatedOutput xopPackage) throws IOException {
        try {
            LinkedHashMap<String, String> mediaTypeParameters = new LinkedHashMap<String, String>();
            mediaTypeParameters.put("charset", "UTF-8");
            mediaTypeParameters.put("type", "text/xml");
            MediaType xopRootMediaType = new MediaType("application", "xop+xml", mediaTypeParameters);
            Marshaller marshaller = this.getMarshaller(type, annotations, xopRootMediaType);
            marshaller.setAttachmentMarshaller(new AttachmentMarshaller(){

                public String addMtomAttachment(DataHandler data, String elementNamespace, String elementLocalName) {
                    String cid = this.generateContentId();
                    xopPackage.addPart((Object)data.getDataSource(), MediaType.valueOf((String)data.getContentType()), cid, "binary");
                    return "cid:" + cid;
                }

                public String addMtomAttachment(byte[] data, int offset, int length, String mimeType, String elementNamespace, String elementLocalName) {
                    String cid = this.generateContentId();
                    ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(data, offset, length);
                    xopPackage.addPart((Object)byteArrayInputStream, MediaType.valueOf((String)mimeType), cid, "binary");
                    return "cid:" + cid;
                }

                protected String generateContentId() {
                    return UUID.randomUUID().toString();
                }

                public String addSwaRefAttachment(DataHandler data) {
                    throw new UnsupportedOperationException("SwaRefs are not supported in xop creation.");
                }

                public boolean isXOPPackage() {
                    return true;
                }
            });
            ByteArrayOutputStream xml = new ByteArrayOutputStream();
            marshaller.marshal(t, (OutputStream)xml);
            OutputPart outputPart = xopPackage.addPart((Object)xml.toString(XopWithMultipartRelatedJAXBProvider.getCharset((MediaType)xopRootMediaType)), xopRootMediaType, UUID.randomUUID().toString(), null);
            List<OutputPart> outputParts = xopPackage.getParts();
            outputParts.remove(outputPart);
            outputParts.add(0, outputPart);
        }
        catch (JAXBException e) {
            Response response = Response.serverError().build();
            throw new WebApplicationException((Throwable)e, response);
        }
    }
}

