/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.resteasy.plugins.server.netty;

import io.netty.buffer.ByteBuf;
import io.netty.buffer.Unpooled;
import io.netty.channel.ChannelHandlerContext;
import io.netty.handler.codec.http.DefaultHttpContent;
import java.io.IOException;
import java.io.OutputStream;
import org.jboss.resteasy.plugins.server.netty.NettyHttpResponse;

public class ChunkOutputStream
extends OutputStream {
    final ByteBuf buffer;
    final ChannelHandlerContext ctx;
    final NettyHttpResponse response;

    ChunkOutputStream(NettyHttpResponse response, ChannelHandlerContext ctx, int chunksize) {
        this.response = response;
        if (chunksize < 1) {
            throw new IllegalArgumentException("Chunk size must be at least 1");
        }
        this.buffer = Unpooled.buffer((int)0, (int)chunksize);
        this.ctx = ctx;
    }

    @Override
    public void write(int b) throws IOException {
        if (this.buffer.maxWritableBytes() < 1) {
            this.flush();
        }
        this.buffer.writeByte(b);
    }

    public void reset() {
        if (this.response.isCommitted()) {
            throw new IllegalStateException("response is committed");
        }
        this.buffer.clear();
    }

    @Override
    public void close() throws IOException {
        this.flush();
        super.close();
    }

    @Override
    public void write(byte[] b, int off, int len) throws IOException {
        int dataLengthLeftToWrite;
        int spaceLeftInCurrentChunk;
        int dataToWriteOffset = off;
        for (dataLengthLeftToWrite = len; (spaceLeftInCurrentChunk = this.buffer.maxWritableBytes()) < dataLengthLeftToWrite; dataLengthLeftToWrite -= spaceLeftInCurrentChunk) {
            this.buffer.writeBytes(b, dataToWriteOffset, spaceLeftInCurrentChunk);
            dataToWriteOffset += spaceLeftInCurrentChunk;
            this.flush();
        }
        if (dataLengthLeftToWrite > 0) {
            this.buffer.writeBytes(b, dataToWriteOffset, dataLengthLeftToWrite);
        }
    }

    @Override
    public void flush() throws IOException {
        if (!this.buffer.isWritable()) {
            return;
        }
        if (!this.response.isCommitted()) {
            this.response.prepareChunkStream();
        }
        this.ctx.writeAndFlush((Object)new DefaultHttpContent(this.buffer.copy()));
        this.buffer.clear();
        super.flush();
    }
}

